/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalController;
import net.citizensnpcs.api.ai.GoalSelector;
import net.citizensnpcs.api.ai.PrioritisableGoal;
import net.citizensnpcs.api.ai.SimpleGoalEntry;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.ForwardingBehaviorGoalAdapter;

public class SimpleGoalController
implements GoalController {
    private final List<Goal> executingGoals = Lists.newArrayList();
    private int executingPriority = -1;
    private Goal executingRootGoal;
    private boolean hasPrioritisableGoal;
    private volatile boolean paused;
    private final List<GoalController.GoalEntry> possibleGoals = Lists.newArrayList();
    private final GoalSelector selector = new SimpleGoalSelector();

    @Override
    public void addBehavior(Behavior behavior, int n) {
        if (behavior instanceof Goal) {
            this.addGoal((Goal)((Object)behavior), n);
            return;
        }
        this.addGoal(BehaviorGoalAdapter.create(behavior), n);
    }

    @Override
    public void addGoal(Goal goal, int n) {
        Objects.requireNonNull(goal, "goal cannot be null");
        Preconditions.checkState((n > 0 && n < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"priority must be greater than 0");
        SimpleGoalEntry simpleGoalEntry = new SimpleGoalEntry(goal, n);
        if (this.possibleGoals.contains(simpleGoalEntry)) {
            return;
        }
        this.possibleGoals.add(simpleGoalEntry);
        Collections.sort(this.possibleGoals);
    }

    private void addGoalToExecution(Goal goal) {
        this.executingGoals.add(goal);
        goal.run(this.selector);
    }

    @Override
    public void addPrioritisableGoal(final PrioritisableGoal prioritisableGoal) {
        Objects.requireNonNull(prioritisableGoal, "goal cannot be null");
        this.possibleGoals.add(new GoalController.GoalEntry(){

            @Override
            public int compareTo(GoalController.GoalEntry goalEntry) {
                int n = this.getPriority();
                return goalEntry.getPriority() > n ? 1 : (goalEntry.getPriority() < n ? -1 : 0);
            }

            @Override
            public Behavior getBehavior() {
                return prioritisableGoal instanceof Behavior ? (Behavior)((Object)prioritisableGoal) : (prioritisableGoal instanceof ForwardingBehaviorGoalAdapter ? ((ForwardingBehaviorGoalAdapter)((Object)prioritisableGoal)).getWrapped() : null);
            }

            @Override
            public Goal getGoal() {
                return prioritisableGoal;
            }

            @Override
            public int getPriority() {
                return prioritisableGoal.getPriority();
            }
        });
        this.hasPrioritisableGoal = true;
    }

    @Override
    public void cancelCurrentExecution() {
        this.finishCurrentGoalExecution();
    }

    @Override
    public void clear() {
        this.finishCurrentGoalExecution();
        this.possibleGoals.clear();
    }

    private void finishCurrentGoalExecution() {
        if (this.executingRootGoal == null) {
            return;
        }
        this.resetGoalList();
        this.executingPriority = -1;
        this.executingRootGoal = null;
    }

    @Override
    public boolean isExecutingGoal() {
        return this.executingRootGoal != null;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public Iterator<GoalController.GoalEntry> iterator() {
        final Iterator<GoalController.GoalEntry> iterator = this.possibleGoals.iterator();
        return new Iterator<GoalController.GoalEntry>(){
            GoalController.GoalEntry cur;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public GoalController.GoalEntry next() {
                this.cur = (GoalController.GoalEntry)iterator.next();
                return this.cur;
            }

            @Override
            public void remove() {
                iterator.remove();
                if (this.cur.getGoal() == SimpleGoalController.this.executingRootGoal) {
                    SimpleGoalController.this.finishCurrentGoalExecution();
                }
            }
        };
    }

    @Override
    public void removeBehavior(Behavior behavior) {
        for (int i = 0; i < this.possibleGoals.size(); ++i) {
            Goal goal = this.possibleGoals.get(i).getGoal();
            if (!goal.equals(behavior)) continue;
            this.possibleGoals.remove(i--);
            if (goal != this.executingRootGoal) continue;
            this.finishCurrentGoalExecution();
        }
    }

    @Override
    public void removeGoal(Goal goal) {
        int n;
        Objects.requireNonNull(goal, "goal cannot be null");
        for (n = 0; n < this.possibleGoals.size(); ++n) {
            Goal goal2 = this.possibleGoals.get(n).getGoal();
            if (!goal2.equals(goal)) continue;
            this.possibleGoals.remove(n--);
            if (goal2 != this.executingRootGoal) continue;
            this.finishCurrentGoalExecution();
        }
        if (goal instanceof PrioritisableGoal) {
            n = 0;
            for (GoalController.GoalEntry goalEntry : this.possibleGoals) {
                if (!(goalEntry.getGoal() instanceof PrioritisableGoal)) continue;
                n = 1;
                break;
            }
            if (n == 0) {
                this.hasPrioritisableGoal = false;
            }
        }
    }

    private void resetGoalList() {
        for (int i = 0; i < this.executingGoals.size(); ++i) {
            this.executingGoals.get(i).reset();
        }
        this.executingGoals.clear();
    }

    @Override
    public void run() {
        if (this.possibleGoals.isEmpty() || this.paused) {
            return;
        }
        this.trySelectGoal();
        for (int i = 0; i < this.executingGoals.size(); ++i) {
            Goal goal = this.executingGoals.get(i);
            goal.run(this.selector);
        }
    }

    @Override
    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    private void setupExecution(GoalController.GoalEntry goalEntry) {
        this.finishCurrentGoalExecution();
        this.executingPriority = goalEntry.getPriority();
        this.executingRootGoal = goalEntry.getGoal();
        this.addGoalToExecution(goalEntry.getGoal());
    }

    private void trySelectGoal() {
        int n = Math.max(this.executingPriority, 1);
        if (this.hasPrioritisableGoal) {
            Collections.sort(this.possibleGoals);
        }
        for (int i = this.possibleGoals.size() - 1; i >= 0; --i) {
            GoalController.GoalEntry goalEntry = this.possibleGoals.get(i);
            if (n > goalEntry.getPriority()) {
                return;
            }
            if (goalEntry.getGoal() == this.executingRootGoal || !goalEntry.getGoal().shouldExecute(this.selector)) continue;
            if (i == 0) {
                this.setupExecution(goalEntry);
                return;
            }
            for (int j = i - 1; j >= 0; --j) {
                int n2;
                boolean bl;
                GoalController.GoalEntry goalEntry2 = this.possibleGoals.get(j);
                boolean bl2 = bl = goalEntry2.getPriority() != goalEntry.getPriority();
                if (!bl && j != 0) continue;
                if (bl) {
                    ++j;
                }
                if ((n2 = (int)Math.floor(Math.random() * (double)(i - j + 1) + (double)j)) >= this.possibleGoals.size() || n2 < 0) {
                    this.setupExecution(goalEntry);
                    break;
                }
                GoalController.GoalEntry goalEntry3 = this.possibleGoals.get(n2);
                if (goalEntry3.getPriority() != goalEntry.getPriority()) {
                    this.setupExecution(goalEntry);
                    break;
                }
                this.setupExecution(goalEntry3);
                break;
            }
            return;
        }
    }

    public class SimpleGoalSelector
    implements GoalSelector {
        @Override
        public void finish() {
            SimpleGoalController.this.finishCurrentGoalExecution();
        }

        @Override
        public void finishAndRemove() {
            Goal goal = SimpleGoalController.this.executingRootGoal;
            this.finish();
            if (goal != null) {
                SimpleGoalController.this.removeGoal(goal);
            }
        }

        @Override
        public void select(Goal goal) {
            SimpleGoalController.this.resetGoalList();
            SimpleGoalController.this.addGoalToExecution(goal);
        }

        @Override
        public void selectAdditional(Goal ... goalArray) {
            for (Goal goal : goalArray) {
                SimpleGoalController.this.addGoalToExecution(goal);
            }
        }
    }
}

