/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.flocking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.citizensnpcs.api.ai.flocking.NPCFlock;
import net.citizensnpcs.api.npc.NPC;

public class GroupNPCFlock
implements NPCFlock {
    private final List<NPC> npcs = new ArrayList<NPC>();
    private final double radius;

    public GroupNPCFlock(Iterable<NPC> iterable, double d) {
        this.radius = d;
    }

    @Override
    public Collection<NPC> getNearby(NPC nPC) {
        if (this.radius < 0.0) {
            return this.npcs;
        }
        return this.npcs.stream().filter(nPC2 -> nPC2.getStoredLocation().distance(nPC.getStoredLocation()) < this.radius).collect(Collectors.toList());
    }

    public List<NPC> getNPCs() {
        return this.npcs;
    }

    public static GroupNPCFlock create(Iterable<NPC> iterable) {
        return new GroupNPCFlock(iterable, -1.0);
    }

    public static GroupNPCFlock createWithRadius(Iterable<NPC> iterable, double d) {
        return new GroupNPCFlock(iterable, d);
    }
}

