/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.flocking;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.flocking.NPCFlock;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Entity;

public class RadiusNPCFlock
implements NPCFlock {
    private Collection<NPC> cached;
    private int cacheTicks = 0;
    private final int maxCacheTicks;
    private final double radius;

    public RadiusNPCFlock(double d) {
        this(d, 30);
    }

    public RadiusNPCFlock(double d, int n) {
        this.radius = d;
        this.maxCacheTicks = n;
    }

    @Override
    public Collection<NPC> getNearby(NPC nPC) {
        if (this.cached != null && this.cacheTicks++ < this.maxCacheTicks) {
            return this.cached;
        }
        this.cached = null;
        this.cacheTicks = 0;
        ArrayList arrayList = Lists.newArrayList();
        for (Entity entity : nPC.getEntity().getNearbyEntities(this.radius, this.radius, this.radius)) {
            NPC nPC2 = CitizensAPI.getNPCRegistry().getNPC(entity);
            if (nPC2 == null || !nPC2.getNavigator().isNavigating()) continue;
            arrayList.add(nPC2);
        }
        if (this.maxCacheTicks <= 0) {
            return arrayList;
        }
        this.cached = arrayList;
        return this.cached;
    }
}

