/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.goals;

import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;

public class MoveToGoal
extends BehaviorGoalAdapter {
    private boolean finished;
    private final NPC npc;
    private CancelReason reason;
    private final Location target;

    public MoveToGoal(NPC nPC, Location location) {
        this.npc = nPC;
        this.target = location;
    }

    @Override
    public void reset() {
        this.npc.getNavigator().cancelNavigation();
        this.reason = null;
        this.finished = false;
    }

    @Override
    public BehaviorStatus run() {
        if (this.finished) {
            return this.reason == null ? BehaviorStatus.SUCCESS : BehaviorStatus.FAILURE;
        }
        return BehaviorStatus.RUNNING;
    }

    @Override
    public boolean shouldExecute() {
        boolean bl;
        boolean bl2 = bl = !this.npc.getNavigator().isNavigating() && this.target != null;
        if (bl) {
            this.npc.getNavigator().setTarget(this.target);
            this.npc.getNavigator().getLocalParameters().addSingleUseCallback(cancelReason -> {
                this.finished = true;
                this.reason = cancelReason;
            });
        }
        return bl;
    }
}

