/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.goals;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class TargetNearbyEntityGoal
extends BehaviorGoalAdapter {
    private final boolean aggressive;
    private boolean finished;
    private final NPC npc;
    private final double radius;
    private CancelReason reason;
    private Entity target;
    private final Set<EntityType> targetTypes;

    private TargetNearbyEntityGoal(NPC nPC, Set<EntityType> set, boolean bl, double d) {
        this.npc = nPC;
        this.targetTypes = set;
        this.aggressive = bl;
        this.radius = d;
    }

    @Override
    public void reset() {
        this.npc.getNavigator().cancelNavigation();
        this.target = null;
        this.finished = false;
        this.reason = null;
    }

    @Override
    public BehaviorStatus run() {
        if (this.finished) {
            return this.reason == null ? BehaviorStatus.SUCCESS : BehaviorStatus.FAILURE;
        }
        return BehaviorStatus.RUNNING;
    }

    @Override
    public boolean shouldExecute() {
        if (this.targetTypes.isEmpty() || !this.npc.isSpawned()) {
            return false;
        }
        List list = this.npc.getEntity().getNearbyEntities(this.radius, this.radius, this.radius);
        this.target = null;
        for (Entity entity : list) {
            if (!this.targetTypes.contains(entity.getType())) continue;
            this.target = entity;
            break;
        }
        if (this.target != null) {
            this.npc.getNavigator().setTarget(this.target, this.aggressive);
            this.npc.getNavigator().getLocalParameters().addSingleUseCallback(cancelReason -> {
                this.reason = cancelReason;
                this.finished = true;
            });
            return true;
        }
        return false;
    }

    public static Builder builder(NPC nPC) {
        return new Builder(nPC);
    }

    public static class Builder {
        private boolean aggressive;
        private final NPC npc;
        private double radius = 10.0;
        private Set<EntityType> targetTypes = EnumSet.noneOf(EntityType.class);

        public Builder(NPC nPC) {
            this.npc = nPC;
        }

        public Builder aggressive(boolean bl) {
            this.aggressive = bl;
            return this;
        }

        public TargetNearbyEntityGoal build() {
            return new TargetNearbyEntityGoal(this.npc, this.targetTypes, this.aggressive, this.radius);
        }

        public Builder radius(double d) {
            this.radius = d;
            return this;
        }

        public Builder targets(Set<EntityType> set) {
            this.targetTypes = set;
            return this;
        }
    }
}

