/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.goals;

import ch.ethz.globis.phtree.PhTreeSolid;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Listener;

public class WanderGoal
extends BehaviorGoalAdapter
implements Listener {
    private int delay;
    private int delayedTicks;
    private final Function<NPC, Location> fallback;
    private boolean forceFinish;
    private int movingTicks;
    private final NPC npc;
    private boolean pathfind;
    private boolean paused;
    private Location target;
    private final Supplier<PhTreeSolid<Boolean>> tree;
    private final Supplier<Object> worldguardRegion;
    private int xrange;
    private int yrange;
    private static final Random RANDOM = new Random();

    private WanderGoal(NPC nPC, boolean bl, int n, int n2, Supplier<PhTreeSolid<Boolean>> supplier, Function<NPC, Location> function, Supplier<Object> supplier2, int n3) {
        this.npc = nPC;
        this.pathfind = bl;
        this.worldguardRegion = supplier2;
        this.xrange = n;
        this.yrange = n2;
        this.tree = supplier;
        this.fallback = function;
        this.delay = n3;
    }

    public Function<Block, Boolean> blockFilter() {
        return block -> {
            Object object;
            if ((MinecraftBlockExaminer.isLiquidOrInLiquid(block.getRelative(BlockFace.UP)) || MinecraftBlockExaminer.isLiquidOrInLiquid(block.getRelative(0, 2, 0))) && this.npc.getNavigator().getDefaultParameters().avoidWater()) {
                return false;
            }
            if (this.worldguardRegion != null && (object = this.worldguardRegion.get()) != null) {
                try {
                    if (!((ProtectedRegion)object).contains(BukkitAdapter.asBlockVector((Location)block.getLocation()))) {
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (this.tree != null) {
                object = new long[]{block.getX(), block.getY(), block.getZ()};
                if (this.tree.get() != null && !this.tree.get().queryIntersect((long[])object, (long[])object).hasNext()) {
                    return false;
                }
            }
            return true;
        };
    }

    private Location findRandomPosition() {
        Location location = MinecraftBlockExaminer.findRandomValidLocation(this.npc.getStoredLocation(), this.pathfind ? this.xrange : 1, this.pathfind ? this.yrange : 1, this.blockFilter(), RANDOM);
        if (location == null && this.fallback != null) {
            return this.fallback.apply(this.npc);
        }
        return location;
    }

    public void pause() {
        this.paused = true;
        if (this.target != null) {
            if (this.pathfind) {
                this.npc.getNavigator().cancelNavigation();
            } else {
                this.npc.setMoveDestination(null);
            }
        }
    }

    @Override
    public void reset() {
        this.target = null;
        this.movingTicks = 0;
        this.delayedTicks = this.delay;
        this.forceFinish = false;
    }

    @Override
    public BehaviorStatus run() {
        if (this.paused || this.forceFinish) {
            return BehaviorStatus.SUCCESS;
        }
        if (this.pathfind) {
            if (!this.npc.getNavigator().isNavigating()) {
                return BehaviorStatus.SUCCESS;
            }
        } else {
            if (!(this.npc.getEntity().getLocation().distance(this.target) >= 0.1)) {
                return BehaviorStatus.SUCCESS;
            }
            this.npc.setMoveDestination(this.target);
            if (this.movingTicks-- <= 0) {
                this.npc.setMoveDestination(null);
                return BehaviorStatus.SUCCESS;
            }
        }
        return BehaviorStatus.RUNNING;
    }

    public void setDelay(int n) {
        this.delay = n;
        this.delayedTicks = n;
        this.forceFinish = true;
    }

    public void setPathfind(boolean bl) {
        this.pathfind = bl;
        this.forceFinish = true;
    }

    public void setXYRange(int n, int n2) {
        this.xrange = n;
        this.yrange = n2;
        this.forceFinish = true;
    }

    @Override
    public boolean shouldExecute() {
        if (!this.npc.isSpawned() || this.npc.getNavigator().isNavigating() || this.paused || this.delayedTicks-- > 0) {
            return false;
        }
        Location location = this.findRandomPosition();
        if (location == null) {
            return false;
        }
        if (this.pathfind) {
            this.npc.getNavigator().setTarget(location);
            this.npc.getNavigator().getLocalParameters().stuckAction(null);
            this.npc.getNavigator().getLocalParameters().addSingleUseCallback(cancelReason -> {
                this.forceFinish = true;
            });
        } else {
            Random random = new Random();
            location.setX(location.getX() + random.nextDouble() * 0.5);
            location.setZ(location.getZ() + random.nextDouble() * 0.5);
            this.movingTicks = 20 + random.nextInt(20);
        }
        this.target = location;
        return true;
    }

    public void unpause() {
        this.paused = false;
    }

    public static Builder builder(NPC nPC) {
        return new Builder(nPC);
    }

    public static class Builder {
        private int delay = 10;
        private Function<NPC, Location> fallback;
        private final NPC npc;
        private boolean pathfind = true;
        private Supplier<PhTreeSolid<Boolean>> tree;
        private Supplier<Object> worldguardRegion;
        private int xrange = 10;
        private int yrange = 2;

        private Builder(NPC nPC) {
            this.npc = nPC;
            this.tree = null;
            this.fallback = null;
            this.worldguardRegion = null;
        }

        public WanderGoal build() {
            return new WanderGoal(this.npc, this.pathfind, this.xrange, this.yrange, this.tree, this.fallback, this.worldguardRegion, this.delay);
        }

        public Builder delay(int n) {
            this.delay = n;
            return this;
        }

        public Builder fallback(Function<NPC, Location> function) {
            this.fallback = function;
            return this;
        }

        public Builder pathfind(boolean bl) {
            this.pathfind = bl;
            return this;
        }

        public Builder regionCentres(Supplier<Iterable<Location>> supplier) {
            this.tree = () -> {
                PhTreeSolid phTreeSolid = PhTreeSolid.create((int)3);
                for (Location location : (Iterable)supplier.get()) {
                    long[] lArray = new long[]{location.getBlockX() - this.xrange, location.getBlockY() - this.yrange, location.getBlockZ() - this.xrange};
                    long[] lArray2 = new long[]{location.getBlockX() + this.xrange, location.getBlockY() + this.yrange, location.getBlockZ() + this.xrange};
                    phTreeSolid.put(lArray, lArray2, (Object)true);
                }
                return phTreeSolid;
            };
            return this;
        }

        public Builder tree(Supplier<PhTreeSolid<Boolean>> supplier) {
            this.tree = supplier;
            return this;
        }

        public Builder worldguardRegion(Supplier<Object> supplier) {
            this.worldguardRegion = supplier;
            return this;
        }

        public Builder xrange(int n) {
            this.xrange = n;
            return this;
        }

        public Builder yrange(int n) {
            this.yrange = n;
            return this;
        }
    }
}

