/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.speech;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.citizensnpcs.api.ai.speech.Talkable;
import net.citizensnpcs.api.ai.speech.TalkableEntity;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Entity;

public class SpeechContext
implements Iterable<Talkable> {
    private String message;
    private List<Talkable> recipients = Collections.emptyList();
    private Talkable talker = null;

    public SpeechContext() {
    }

    public SpeechContext(NPC nPC, String string) {
        if (nPC != null) {
            this.setTalker(nPC.getEntity());
        }
        this.message = string;
    }

    public SpeechContext(NPC nPC, String string, Entity entity) {
        this(nPC, string);
        if (entity != null) {
            this.addRecipient(entity);
        }
    }

    public SpeechContext(String string) {
        this.message = string;
    }

    public SpeechContext(String string, Entity entity) {
        this.message = string;
        if (entity != null) {
            this.addRecipient(entity);
        }
    }

    public SpeechContext addRecipient(Entity entity) {
        if (this.recipients.isEmpty()) {
            this.recipients = new ArrayList<Talkable>();
        }
        this.recipients.add(new TalkableEntity(entity));
        return this;
    }

    public SpeechContext addRecipients(List<Talkable> list) {
        if (this.recipients.isEmpty()) {
            this.recipients = new ArrayList<Talkable>();
        }
        this.recipients.addAll(list);
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public Talkable getTalker() {
        return this.talker;
    }

    public boolean hasRecipients() {
        return !this.recipients.isEmpty();
    }

    @Override
    public Iterator<Talkable> iterator() {
        Iterator<Talkable> iterator = this.recipients.iterator();
        return iterator;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setTalker(Entity entity) {
        this.talker = new TalkableEntity(entity);
    }

    public int size() {
        return this.recipients.size();
    }
}

