/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.Condition;

public abstract class Precondition
extends BehaviorGoalAdapter {
    protected final Condition condition;

    protected Precondition(Condition condition) {
        this.condition = condition;
    }

    public static Precondition runPrecondition(Condition condition) {
        return new RunPrecondition(condition);
    }

    public static Precondition wrappingPrecondition(Behavior behavior, Condition condition) {
        return new WrappingPrecondition(behavior, condition);
    }

    private static class RunPrecondition
    extends Precondition {
        public RunPrecondition(Condition condition) {
            super(condition);
        }

        @Override
        public void reset() {
        }

        @Override
        public BehaviorStatus run() {
            return this.condition.get() ? BehaviorStatus.SUCCESS : BehaviorStatus.FAILURE;
        }

        @Override
        public boolean shouldExecute() {
            return true;
        }
    }

    private static class WrappingPrecondition
    extends Precondition {
        private final Behavior wrapping;

        public WrappingPrecondition(Behavior behavior, Condition condition) {
            super(condition);
            this.wrapping = behavior;
        }

        @Override
        public void reset() {
            this.wrapping.reset();
        }

        @Override
        public BehaviorStatus run() {
            return this.wrapping.run();
        }

        @Override
        public boolean shouldExecute() {
            return this.condition.get() ? this.wrapping.shouldExecute() : false;
        }
    }
}

