/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.Selector;

public class Selectors {
    private static final Comparator<Behavior> BEHAVIOR_COMPARATOR = (behavior, behavior2) -> ((Comparable)((Object)behavior)).compareTo(behavior2);

    private Selectors() {
    }

    public static Function<List<Behavior>, Behavior> prioritySelectionFunction() {
        return new PrioritySelection(BEHAVIOR_COMPARATOR);
    }

    public static Selector.Builder prioritySelector(Comparator<Behavior> comparator, Behavior ... behaviorArray) {
        return Selectors.prioritySelector(comparator, Arrays.asList(behaviorArray));
    }

    public static Selector.Builder prioritySelector(Comparator<Behavior> comparator, Collection<Behavior> collection) {
        Preconditions.checkArgument((collection.size() > 0 ? 1 : 0) != 0, (Object)"must have at least one behavior for comparison");
        return Selector.selecting(collection).selectionFunction(new PrioritySelection(comparator));
    }

    public static final class PrioritySelection
    implements Function<List<Behavior>, Behavior> {
        private final Comparator<Behavior> comparator;

        private PrioritySelection(Comparator<Behavior> comparator) {
            this.comparator = comparator;
        }

        @Override
        public Behavior apply(List<Behavior> list) {
            Collections.sort(list, this.comparator);
            return list.get(list.size() - 1);
        }
    }
}

