/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import java.util.function.Supplier;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;

public class StatusMapper
extends BehaviorGoalAdapter {
    private final Supplier<BehaviorStatus> to;
    private final Behavior wrapping;

    private StatusMapper(Behavior behavior, Supplier<BehaviorStatus> supplier) {
        this.wrapping = behavior;
        this.to = supplier;
    }

    @Override
    public void reset() {
        this.wrapping.reset();
    }

    @Override
    public BehaviorStatus run() {
        return this.to.get();
    }

    @Override
    public boolean shouldExecute() {
        return this.wrapping.shouldExecute();
    }

    public static StatusMapper mapping(Behavior behavior, Supplier<BehaviorStatus> supplier) {
        return new StatusMapper(behavior, supplier);
    }

    public static Behavior singleUse(final Behavior behavior) {
        return new Behavior(){

            @Override
            public void reset() {
                behavior.reset();
            }

            @Override
            public BehaviorStatus run() {
                BehaviorStatus behaviorStatus = behavior.run();
                switch (behaviorStatus) {
                    case FAILURE: 
                    case SUCCESS: {
                        return BehaviorStatus.RESET_AND_REMOVE;
                    }
                }
                return behaviorStatus;
            }

            @Override
            public boolean shouldExecute() {
                return behavior.shouldExecute();
            }
        };
    }
}

