/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.citizensnpcs.api.astar.Plan;

public abstract class AStarNode
implements Comparable<AStarNode> {
    float g;
    float h;
    AStarNode parent;
    List<AStarNode> parents;

    protected AStarNode(AStarNode aStarNode) {
        this.parent = aStarNode;
    }

    public abstract Plan buildPlan();

    @Override
    public int compareTo(AStarNode aStarNode) {
        return Float.compare(this.g + this.h, aStarNode.g + aStarNode.h);
    }

    public abstract boolean equals(Object var1);

    public abstract Iterable<AStarNode> getNeighbours();

    protected AStarNode getParent() {
        return this.parent;
    }

    protected float getPathCost() {
        return this.g + this.h;
    }

    public abstract int hashCode();

    protected <T extends AStarNode> Iterable<T> orderedPath() {
        if (this.parents != null) {
            return this.parents;
        }
        this.parents = Lists.newArrayList();
        AStarNode aStarNode = this;
        while (aStarNode != null) {
            this.parents.add(aStarNode);
            aStarNode = aStarNode.parent;
        }
        Collections.reverse(this.parents);
        return this.parents;
    }
}

