/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.event.NPCEvent;
import net.citizensnpcs.api.event.NPCOpenDoorEvent;
import net.citizensnpcs.api.event.NPCOpenGateEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.material.Door;
import org.bukkit.material.MaterialData;
import org.bukkit.scheduler.BukkitRunnable;

public class DoorExaminer
implements BlockExaminer {
    @Override
    public float getCost(BlockSource blockSource, PathPoint pathPoint) {
        return 0.0f;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource blockSource, PathPoint pathPoint) {
        if (!MinecraftBlockExaminer.canStandOn(blockSource.getMaterialAt(pathPoint.getVector().getBlockX(), pathPoint.getVector().getBlockY() - 1, pathPoint.getVector().getBlockZ()))) {
            return BlockExaminer.PassableState.IGNORE;
        }
        Block block = blockSource.getBlockAt(pathPoint.getVector());
        if (MinecraftBlockExaminer.isDoor(block.getType()) && DoorExaminer.isBottomDoor(block) || MinecraftBlockExaminer.isGate(block.getType())) {
            pathPoint.addCallback(new DoorOpener());
            return BlockExaminer.PassableState.PASSABLE;
        }
        return BlockExaminer.PassableState.IGNORE;
    }

    private static Block getCorrectDoor(Block block) {
        if (SpigotUtil.isUsing1_13API()) {
            BlockData blockData = block.getBlockData();
            if (!(blockData instanceof Bisected)) {
                return block;
            }
            return ((Bisected)blockData).getHalf() == Bisected.Half.BOTTOM ? block : block.getRelative(BlockFace.DOWN);
        }
        MaterialData materialData = block.getState().getData();
        if (!(materialData instanceof Door)) {
            return block;
        }
        Door door = (Door)materialData;
        boolean bl = !door.isTopHalf();
        return bl ? block : block.getRelative(BlockFace.DOWN);
    }

    private static boolean isBottomDoor(Block block) {
        if (SpigotUtil.isUsing1_13API()) {
            BlockData blockData = block.getBlockData();
            if (!(blockData instanceof Bisected)) {
                return false;
            }
            return ((Bisected)blockData).getHalf() == Bisected.Half.BOTTOM;
        }
        MaterialData materialData = block.getState().getData();
        if (!(materialData instanceof Door)) {
            return false;
        }
        Door door = (Door)materialData;
        return !door.isTopHalf();
    }

    private static class DoorOpener
    implements PathPoint.PathCallback {
        private boolean opened;
        private static boolean SUPPORTS_SOUNDS = true;
        private static boolean SUPPORTS_SWING_ANIMATION = true;

        private DoorOpener() {
        }

        private void close(NPC nPC, Block block) {
            Openable openable;
            if (SpigotUtil.isUsing1_13API()) {
                openable = (Openable)block.getBlockData();
                if (!openable.isOpen()) {
                    return;
                }
                openable.setOpen(false);
                block.setBlockData((BlockData)openable);
                block.getState().update();
            } else {
                openable = (block = DoorExaminer.getCorrectDoor(block)).getState();
                org.bukkit.material.Openable openable2 = (org.bukkit.material.Openable)openable.getData();
                if (!openable2.isOpen()) {
                    return;
                }
                openable2.setOpen(false);
                openable.setData((MaterialData)openable2);
                openable.update();
            }
            if (SUPPORTS_SOUNDS) {
                try {
                    openable = MinecraftBlockExaminer.isDoor(block.getType()) ? (block.getType() == Material.IRON_DOOR ? Sound.BLOCK_IRON_DOOR_CLOSE : Sound.BLOCK_WOODEN_DOOR_CLOSE) : Sound.BLOCK_FENCE_GATE_CLOSE;
                    block.getWorld().playSound(block.getLocation(), (Sound)openable, 2.0f, 1.0f);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    SUPPORTS_SOUNDS = false;
                }
            }
            this.tryArmSwing(nPC);
        }

        @Override
        public void onReached(final NPC nPC, final Block block) {
            final Location location = block.getLocation().add(0.5, 0.0, 0.5);
            new BukkitRunnable(){

                public void run() {
                    if (!nPC.getNavigator().isNavigating()) {
                        if (opened && nPC.getStoredLocation().distance(location) <= 1.8) {
                            this.close(nPC, block);
                        }
                        this.cancel();
                        return;
                    }
                    if (nPC.getStoredLocation().distance(location) > 1.8) {
                        this.close(nPC, block);
                        this.cancel();
                    }
                }
            }.runTaskTimer(CitizensAPI.getPlugin(), 3L, 1L);
        }

        private void open(NPC nPC, Block block) {
            Openable openable;
            if (SpigotUtil.isUsing1_13API()) {
                openable = (Openable)block.getBlockData();
                if (openable.isOpen()) {
                    return;
                }
                NPCEvent nPCEvent = MinecraftBlockExaminer.isDoor(block.getType()) ? new NPCOpenDoorEvent(nPC, block) : new NPCOpenGateEvent(nPC, block);
                Bukkit.getPluginManager().callEvent((Event)nPCEvent);
                if (nPCEvent.isCancelled()) {
                    return;
                }
                openable.setOpen(true);
                block.setBlockData((BlockData)openable);
                block.getState().update();
            } else {
                openable = (block = DoorExaminer.getCorrectDoor(block)).getState();
                org.bukkit.material.Openable openable2 = (org.bukkit.material.Openable)openable.getData();
                if (openable2.isOpen()) {
                    return;
                }
                NPCEvent nPCEvent = MinecraftBlockExaminer.isDoor(block.getType()) ? new NPCOpenDoorEvent(nPC, block) : new NPCOpenGateEvent(nPC, block);
                Bukkit.getPluginManager().callEvent((Event)nPCEvent);
                if (nPCEvent.isCancelled()) {
                    return;
                }
                openable2.setOpen(true);
                openable.setData((MaterialData)openable2);
                openable.update();
            }
            if (SUPPORTS_SOUNDS) {
                try {
                    openable = MinecraftBlockExaminer.isDoor(block.getType()) ? (block.getType() == Material.IRON_DOOR ? Sound.BLOCK_IRON_DOOR_OPEN : Sound.BLOCK_WOODEN_DOOR_OPEN) : Sound.BLOCK_FENCE_GATE_OPEN;
                    block.getWorld().playSound(block.getLocation(), (Sound)openable, 2.0f, 1.0f);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    SUPPORTS_SOUNDS = false;
                }
            }
            this.tryArmSwing(nPC);
        }

        @Override
        public void run(NPC nPC, Block block, List<Block> list, int n) {
            if (this.opened || !MinecraftBlockExaminer.isDoor(block.getType()) && !MinecraftBlockExaminer.isGate(block.getType()) || nPC.getStoredLocation().distance(block.getLocation().add(0.5, 0.0, 0.5)) > 2.5) {
                return;
            }
            this.open(nPC, block);
            this.opened = true;
        }

        private void tryArmSwing(NPC nPC) {
            if (SUPPORTS_SWING_ANIMATION && nPC.getEntity() instanceof LivingEntity) {
                try {
                    ((LivingEntity)nPC.getEntity()).swingMainHand();
                }
                catch (Exception exception) {
                    SUPPORTS_SWING_ANIMATION = false;
                }
            }
        }
    }
}

