/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.citizensnpcs.api.astar.Agent;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class Path
implements Plan {
    private List<Block> blockList;
    private int index = 0;
    private final PathEntry[] path;

    public Path(Collection<Vector> collection) {
        this.path = (PathEntry[])Iterables.toArray((Iterable)Iterables.transform(collection, vector -> new PathEntry((Vector)vector, Collections.emptyList())), PathEntry.class);
    }

    Path(Iterable<VectorNode> iterable) {
        this.path = this.cull(iterable);
    }

    private PathEntry[] cull(Iterable<VectorNode> iterable) {
        ArrayList arrayList = Lists.newArrayList();
        for (VectorNode vectorNode : iterable) {
            for (Vector vector : vectorNode.getPathVectors()) {
                arrayList.add(new PathEntry(vector, vectorNode.callbacks));
            }
        }
        return arrayList.toArray(new PathEntry[arrayList.size()]);
    }

    public List<Block> getBlocks(World world) {
        return Arrays.asList(this.path).stream().map(pathEntry -> world.getBlockAt(pathEntry.vector.getBlockX(), pathEntry.vector.getBlockY(), pathEntry.vector.getBlockZ())).collect(Collectors.toList());
    }

    public Vector getCurrentVector() {
        return this.path[this.index].vector;
    }

    public Iterable<Vector> getPath() {
        return Iterables.transform(Arrays.asList(this.path), pathEntry -> pathEntry.vector);
    }

    @Override
    public boolean isComplete() {
        return this.index >= this.path.length;
    }

    public void run(NPC nPC) {
        this.path[this.index].run(nPC);
    }

    public String toString() {
        return Arrays.toString(this.path);
    }

    @Override
    public void update(Agent agent) {
        if (this.isComplete()) {
            return;
        }
        this.path[this.index].onComplete((NPC)agent);
        ++this.index;
    }

    private class PathEntry {
        final List<PathPoint.PathCallback> callbacks;
        final Vector vector;

        private PathEntry(Vector vector, List<PathPoint.PathCallback> list) {
            this.vector = vector;
            this.callbacks = list;
        }

        public void onComplete(NPC nPC) {
            if (this.callbacks == null) {
                return;
            }
            Block block = nPC.getEntity().getWorld().getBlockAt(this.vector.getBlockX(), this.vector.getBlockY(), this.vector.getBlockZ());
            for (PathPoint.PathCallback pathCallback : this.callbacks) {
                pathCallback.onReached(nPC, block);
            }
        }

        public void run(NPC nPC) {
            if (this.callbacks == null) {
                return;
            }
            Block block = nPC.getEntity().getWorld().getBlockAt(this.vector.getBlockX(), this.vector.getBlockY(), this.vector.getBlockZ());
            for (PathPoint.PathCallback pathCallback : this.callbacks) {
                if (Path.this.blockList == null) {
                    Path.this.blockList = Lists.transform(Arrays.asList(Path.this.path), pathEntry -> nPC.getEntity().getWorld().getBlockAt(pathEntry.vector.getBlockX(), pathEntry.vector.getBlockY(), pathEntry.vector.getBlockZ()));
                }
                pathCallback.run(nPC, block, Path.this.blockList, Path.this.index);
            }
        }

        public String toString() {
            return this.vector.toString();
        }
    }
}

