/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Squid;
import org.bukkit.entity.WaterMob;
import org.bukkit.util.Vector;

public class SwimmingExaminer
implements BlockExaminer {
    private boolean canSwimInLava;
    private final NPC npc;
    private static final Vector UP = new Vector(0, 1, 0);

    public SwimmingExaminer(NPC nPC) {
        this.npc = nPC;
    }

    public boolean canSwimInLava() {
        return this.canSwimInLava;
    }

    @Override
    public float getCost(BlockSource blockSource, PathPoint pathPoint) {
        if (SwimmingExaminer.isWaterMob(this.npc.getEntity()) && !MinecraftBlockExaminer.isLiquidOrInLiquid(blockSource.getBlockAt(pathPoint.getVector()))) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource blockSource, PathPoint pathPoint) {
        Vector vector = pathPoint.getVector();
        if (!MinecraftBlockExaminer.isLiquidOrInLiquid(blockSource.getWorld().getBlockAt(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ()))) {
            return BlockExaminer.PassableState.IGNORE;
        }
        if (SwimmingExaminer.isWaterMob(this.npc.getEntity())) {
            return BlockExaminer.PassableState.PASSABLE;
        }
        Block block = blockSource.getBlockAt(vector.clone().add(UP));
        return this.isSwimmableLiquid(block.getType()) || MinecraftBlockExaminer.canStandIn(block) ? BlockExaminer.PassableState.PASSABLE : BlockExaminer.PassableState.UNPASSABLE;
    }

    private boolean isSwimmableLiquid(Material material) {
        if (material == Material.LAVA || !SpigotUtil.isUsing1_13API() && material == Material.valueOf((String)"STATIONARY_LAVA")) {
            return this.canSwimInLava();
        }
        return material == Material.WATER || !SpigotUtil.isUsing1_13API() && material == Material.valueOf((String)"STATIONARY_WATER");
    }

    public void setCanSwimInLava(boolean bl) {
        this.canSwimInLava = bl;
    }

    public static boolean isWaterMob(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (!SpigotUtil.isUsing1_13API()) {
            return entity instanceof Squid;
        }
        return entity instanceof WaterMob || entity.getType().name().equals("TURTLE") || entity.getType().name().equals("FROG") || entity.getType().name().equals("AXOLOTL");
    }
}

