/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import net.citizensnpcs.api.astar.AStarGoal;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class VectorGoal
implements AStarGoal<VectorNode> {
    private final Vector goal;
    private final float leeway;

    public VectorGoal(Location location, float f) {
        if (!MinecraftBlockExaminer.canStandIn(location.getBlock().getType())) {
            location = MinecraftBlockExaminer.findValidLocationAbove(location, 2);
        }
        this.leeway = f;
        this.goal = location.toVector();
        this.goal.setX(this.goal.getBlockX()).setY(this.goal.getBlockY()).setZ(this.goal.getBlockZ());
    }

    @Override
    public float g(VectorNode vectorNode, VectorNode vectorNode2) {
        return vectorNode.distance(vectorNode2);
    }

    public Vector getGoalVector() {
        return this.goal.clone();
    }

    @Override
    public float getInitialCost(VectorNode vectorNode) {
        return (float)vectorNode.getVector().distance(this.goal);
    }

    @Override
    public float h(VectorNode vectorNode) {
        return vectorNode.heuristicDistance(this.goal);
    }

    @Override
    public boolean isFinished(VectorNode vectorNode) {
        double d = vectorNode.location.distance(this.goal);
        return this.goal.equals((Object)vectorNode.location) || d <= (double)this.leeway;
    }
}

