/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.NeighbourGeneratorBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.astar.pathfinder.VectorGoal;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class VectorNode
extends AStarNode
implements PathPoint {
    private float blockCost = -1.0f;
    List<PathPoint.PathCallback> callbacks;
    private final PathInfo info;
    Vector location;
    Vector locationCache;
    List<Vector> pathVectors;
    private static final BlockExaminer[] EMPTY_BLOCK_EXAMINER = new BlockExaminer[0];
    private static final float TIEBREAKER = 1.001f;

    public VectorNode(VectorGoal vectorGoal, Location location, BlockSource blockSource, BlockExaminer ... blockExaminerArray) {
        this(null, vectorGoal, location.toVector(), blockSource, blockExaminerArray);
    }

    public VectorNode(VectorNode vectorNode, Vector vector, PathInfo pathInfo) {
        super(vectorNode);
        this.location = new Vector(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
        this.info = pathInfo;
    }

    public VectorNode(VectorNode vectorNode, VectorGoal vectorGoal, Vector vector, BlockSource blockSource, BlockExaminer ... blockExaminerArray) {
        this(vectorNode, vector, new PathInfo(blockSource, blockExaminerArray == null ? EMPTY_BLOCK_EXAMINER : blockExaminerArray, vectorGoal));
    }

    @Override
    public void addCallback(PathPoint.PathCallback pathCallback) {
        if (this.callbacks == null) {
            this.callbacks = Lists.newArrayList();
        }
        this.callbacks.add(pathCallback);
    }

    @Override
    public Plan buildPlan() {
        return new Path(this.orderedPath());
    }

    @Override
    public VectorNode createAtOffset(Vector vector) {
        return new VectorNode(this, vector, this.info);
    }

    public float distance(VectorNode vectorNode) {
        return (float)this.location.distance(vectorNode.location);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        VectorNode vectorNode = (VectorNode)object;
        return Objects.equals(this.location, vectorNode.location);
    }

    private float getBlockCost() {
        if (this.blockCost == -1.0f) {
            this.blockCost = 0.0f;
            for (BlockExaminer blockExaminer : this.info.examiners) {
                this.blockCost += blockExaminer.getCost(this.info.blockSource, this);
            }
        }
        return this.blockCost;
    }

    @Override
    public Vector getGoal() {
        return this.info.goal.getGoalVector();
    }

    @Override
    public Iterable<AStarNode> getNeighbours() {
        List<PathPoint> list = null;
        for (BlockExaminer blockExaminer : this.info.examiners) {
            if (!(blockExaminer instanceof NeighbourGeneratorBlockExaminer)) continue;
            list = ((NeighbourGeneratorBlockExaminer)blockExaminer).getNeighbours(this.info.blockSource, this);
            break;
        }
        if (list == null) {
            list = this.getNeighbours(this.info.blockSource, this);
        }
        ArrayList arrayList = Lists.newArrayList();
        for (PathPoint pathPoint : list) {
            if (!this.isPassable(pathPoint)) continue;
            arrayList.add((AStarNode)((Object)pathPoint));
        }
        return arrayList;
    }

    public List<PathPoint> getNeighbours(BlockSource blockSource, PathPoint pathPoint) {
        return this.getNeighbours(blockSource, pathPoint, true);
    }

    public List<PathPoint> getNeighbours(BlockSource blockSource, PathPoint pathPoint, boolean bl) {
        ArrayList arrayList = Lists.newArrayList();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    Vector vector;
                    int n;
                    if (i == 0 && j == 0 && k == 0 || !SpigotUtil.checkYSafe(n = this.location.getBlockY() + j, blockSource.getWorld()) || (vector = new Vector(this.location.getX() + (double)i, (double)n, this.location.getZ() + (double)k)).equals((Object)this.location) || i != 0 && k != 0 && bl && (!this.isPassable(pathPoint.createAtOffset(new Vector(this.location.getX() + (double)i, (double)n, this.location.getZ()))) || !this.isPassable(pathPoint.createAtOffset(new Vector(this.location.getX(), (double)n, this.location.getZ() + (double)k))))) continue;
                    arrayList.add(pathPoint.createAtOffset(vector));
                }
            }
        }
        return arrayList;
    }

    @Override
    public PathPoint getParentPoint() {
        return (PathPoint)((Object)this.getParent());
    }

    @Override
    public List<Vector> getPathVectors() {
        return this.pathVectors != null ? this.pathVectors : ImmutableList.of((Object)this.location);
    }

    @Override
    public Vector getVector() {
        if (this.locationCache == null) {
            this.locationCache = this.location.clone();
        }
        return this.locationCache.setX(this.location.getBlockX()).setY(this.location.getBlockY()).setZ(this.location.getBlockZ());
    }

    @Override
    public int hashCode() {
        return 31 + (this.location == null ? 0 : this.location.hashCode());
    }

    public float heuristicDistance(Vector vector) {
        return (float)(this.location.distance(vector) + (double)this.getBlockCost()) * 1.001f;
    }

    private boolean isPassable(PathPoint pathPoint) {
        boolean bl = false;
        for (BlockExaminer blockExaminer : this.info.examiners) {
            BlockExaminer.PassableState passableState = blockExaminer.isPassable(this.info.blockSource, pathPoint);
            if (passableState == BlockExaminer.PassableState.IGNORE) continue;
            bl = passableState == BlockExaminer.PassableState.PASSABLE;
        }
        return bl;
    }

    @Override
    public void setPathVectors(List<Vector> list) {
        this.pathVectors = list;
    }

    @Override
    public void setVector(Vector vector) {
        this.location = vector;
    }

    private static class PathInfo {
        private final BlockSource blockSource;
        private final BlockExaminer[] examiners;
        private final VectorGoal goal;

        private PathInfo(BlockSource blockSource, BlockExaminer[] blockExaminerArray, VectorGoal vectorGoal) {
            this.blockSource = blockSource;
            this.examiners = blockExaminerArray;
            this.goal = vectorGoal;
        }
    }
}

