/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.command;

import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.Arg;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandAnnotationProcessor;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Injector;
import net.citizensnpcs.api.command.RequirementsProcessor;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.command.exception.NoPermissionsException;
import net.citizensnpcs.api.command.exception.ServerCommandException;
import net.citizensnpcs.api.command.exception.UnhandledCommandException;
import net.citizensnpcs.api.command.exception.WrappedCommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Paginator;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;
import org.joml.Quaternionfc;

public class CommandManager
implements TabCompleter {
    private final Map<Class<? extends Annotation>, CommandAnnotationProcessor> annotationProcessors = Maps.newHashMap();
    private final Map<String, CommandInfo> commands = Maps.newHashMap();
    private TimeUnit defaultDurationUnits;
    private Injector injector;
    private Function<Command, String> translationPrefixProvider;
    private static final String COMMAND_FORMAT = "<green>/{{%s%s <green>- [[%s";
    private static final Logger logger = Logger.getLogger(CommandManager.class.getCanonicalName());

    public CommandManager() {
        this.registerAnnotationProcessor(new RequirementsProcessor());
    }

    public void execute(org.bukkit.command.Command command, String[] stringArray, CommandSender commandSender, Object ... objectArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        stringArray2[0] = command.getName().toLowerCase();
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        this.executeCommand(stringArray2, commandSender, objectArray2);
    }

    private void executeCommand(String[] stringArray, CommandSender commandSender, Object[] objectArray) {
        Object object;
        CommandContext commandContext;
        String string = stringArray[0].toLowerCase();
        String string2 = stringArray.length > 1 ? stringArray[1] : "";
        boolean bl = string2.toLowerCase().equals("help");
        CommandInfo commandInfo = this.getCommand(string, string2);
        if (commandInfo == null || commandInfo.method == null) {
            if (bl) {
                this.executeHelp(stringArray, commandSender);
                return;
            }
            commandInfo = this.commands.get(string + " *");
        }
        if (commandInfo == null && stringArray.length > 2) {
            commandInfo = this.getCommand(string, stringArray[1], stringArray[2]);
        }
        if (commandInfo == null) {
            throw new UnhandledCommandException();
        }
        if (!commandInfo.serverCommand && commandSender instanceof ConsoleCommandSender) {
            throw new ServerCommandException();
        }
        if (!this.hasPermission(commandInfo, commandSender)) {
            throw new NoPermissionsException();
        }
        Command command = commandInfo.commandAnnotation;
        if (command.parsePlaceholders()) {
            commandContext = objectArray.length > 2 && objectArray[2] instanceof NPC ? (NPC)objectArray[2] : null;
            for (int i = 1; i < stringArray.length; ++i) {
                stringArray[i] = Placeholders.replace(stringArray[i], commandSender, (NPC)((Object)commandContext));
            }
        }
        commandContext = new CommandContext(commandSender, stringArray);
        if (command.requiresFlags() && !commandContext.hasAnyFlags()) {
            throw new CommandUsageException("", this.getUsage(stringArray, command));
        }
        if (commandContext.argsLength() < command.min()) {
            throw new CommandUsageException("citizens.commands.requirements.too-few-arguments", this.getUsage(stringArray, command));
        }
        if (command.max() != -1 && commandContext.argsLength() > command.max()) {
            throw new CommandUsageException("citizens.commands.requirements.too-many-arguments", this.getUsage(stringArray, command));
        }
        if (!command.flags().contains("*")) {
            for (char c : commandContext.getFlags()) {
                if (command.flags().indexOf(String.valueOf(c)) != -1) continue;
                throw new CommandUsageException("Unknown flag: " + c, this.getUsage(stringArray, command));
            }
        }
        objectArray[0] = commandContext;
        for (Annotation annotation : commandInfo.annotations) {
            object = this.annotationProcessors.get(annotation.annotationType());
            object.process(commandSender, commandContext, annotation, objectArray);
        }
        if (commandInfo.methodArguments.size() > 0) {
            objectArray = Arrays.copyOf(objectArray, objectArray.length + commandInfo.methodArguments.size());
            for (Map.Entry entry : commandInfo.methodArguments.entrySet()) {
                object = ((InjectedCommandArgument)entry.getValue()).paramType;
                Object object2 = ((InjectedCommandArgument)entry.getValue()).getInput(commandContext);
                if (object2 != null) {
                    if (((InjectedCommandArgument)entry.getValue()).validator != null) {
                        object2 = ((InjectedCommandArgument)entry.getValue()).validator.validate(commandContext, commandSender, objectArray.length > 2 && objectArray[2] instanceof NPC ? (NPC)objectArray[2] : null, object2.toString());
                    } else if (object == Material.class) {
                        object2 = SpigotUtil.isUsing1_13API() ? Material.matchMaterial((String)object2.toString(), (boolean)false) : Material.matchMaterial((String)object2.toString());
                    } else if (Enum.class.isAssignableFrom((Class<?>)object)) {
                        object2 = CommandManager.matchEnum((Enum[])((Enum[])((Class)object).getEnumConstants()), (String)object2.toString().toUpperCase());
                    } else if (object == Double.TYPE || object == Double.class) {
                        object2 = Double.parseDouble(object2.toString());
                    } else if (object == Integer.TYPE || object == Integer.class) {
                        object2 = Integer.parseInt(object2.toString());
                    } else if (object == Boolean.TYPE || object == Boolean.class) {
                        object2 = Boolean.parseBoolean(object2.toString());
                    } else if (object == Float.TYPE || object == Float.class) {
                        object2 = Float.valueOf(Float.parseFloat(object2.toString()));
                    } else if (object == Location.class) {
                        object2 = CommandContext.parseLocation(commandContext.getSenderLocation(), object2.toString());
                    } else if (object == ItemStack.class) {
                        object2 = CommandContext.parseItemStack(object2.toString());
                    } else if (object == UUID.class) {
                        object2 = UUID.fromString(object2.toString());
                    } else if (object == Duration.class) {
                        object2 = SpigotUtil.parseDuration(object2.toString(), this.defaultDurationUnits);
                    } else if (object == Vector.class) {
                        object2 = CommandContext.parseVector(object2.toString());
                    } else if (Quaternionfc.class.isAssignableFrom((Class<?>)object)) {
                        object2 = CommandContext.parseQuaternion(object2.toString());
                    }
                }
                objectArray[((Integer)entry.getKey()).intValue()] = object2;
            }
        }
        try {
            commandInfo.method.invoke(commandInfo.instance, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.log(Level.SEVERE, "Failed to execute command", illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.SEVERE, "Failed to execute command", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof CommandException) {
                if (invocationTargetException.getCause() instanceof CommandUsageException && ((CommandUsageException)invocationTargetException.getCause()).getUsage() == null) {
                    ((CommandUsageException)invocationTargetException.getCause()).setUsage(this.getUsage(stringArray, command));
                }
                throw (CommandException)invocationTargetException.getCause();
            }
            throw new WrappedCommandException(invocationTargetException.getCause());
        }
    }

    private void executeHelp(String[] stringArray, CommandSender commandSender) {
        if (!commandSender.hasPermission("citizens." + stringArray[0] + ".help")) {
            throw new NoPermissionsException();
        }
        int n = 1;
        try {
            n = stringArray.length == 3 ? Integer.parseInt(stringArray[2]) : n;
        }
        catch (NumberFormatException numberFormatException) {
            this.sendSpecificHelp(commandSender, stringArray[0], stringArray[2]);
            return;
        }
        this.sendHelp(commandSender, stringArray[0], n);
    }

    public boolean executeSafe(org.bukkit.command.Command command, String[] stringArray, CommandSender commandSender, Object ... objectArray) {
        block11: {
            try {
                try {
                    this.execute(command, stringArray, commandSender, objectArray);
                }
                catch (ServerCommandException serverCommandException) {
                    Messaging.sendTr(commandSender, "citizens.commands.requirements.must-be-ingame", new Object[0]);
                }
                catch (CommandUsageException commandUsageException) {
                    if (commandUsageException.getMessage() != null && !commandUsageException.getMessage().isEmpty()) {
                        Messaging.sendError(commandSender, commandUsageException.getMessage());
                    }
                    Messaging.sendError(commandSender, commandUsageException.getUsage());
                }
                catch (UnhandledCommandException unhandledCommandException) {
                    Messaging.sendErrorTr(commandSender, "citizens.commands.unknown-command", new Object[0]);
                    return false;
                }
                catch (WrappedCommandException wrappedCommandException) {
                    if (wrappedCommandException.getCause() instanceof NumberFormatException) {
                        if (Messaging.isDebugging()) {
                            wrappedCommandException.printStackTrace();
                        }
                        Messaging.sendErrorTr(commandSender, "citizens.commands.invalid-number", new Object[0]);
                        break block11;
                    }
                    throw wrappedCommandException.getCause();
                }
                catch (CommandException commandException) {
                    Messaging.sendError(commandSender, commandException.getMessage());
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (!(commandSender instanceof Player)) break block11;
                Messaging.sendErrorTr(commandSender, "citizens.commands.console-error", new Object[0]);
                Messaging.sendError(commandSender, throwable.getClass().getName() + ": " + throwable.getMessage());
            }
        }
        return true;
    }

    private String format(Command command, String string) {
        String string2 = command.desc();
        if (this.translationPrefixProvider != null && string2.isEmpty()) {
            string2 = this.translationPrefixProvider.apply(command) + ".description";
        }
        return String.format(COMMAND_FORMAT, string, command.usage().isEmpty() ? "" : " " + command.usage(), Messaging.tryTranslate(string2));
    }

    public String getClosestCommandModifier(String string, String string2) {
        int n = Integer.MAX_VALUE;
        string = string.toLowerCase();
        String string3 = "";
        for (String string4 : this.commands.keySet()) {
            int n2;
            String[] stringArray = string4.split(" ");
            if (stringArray.length <= 1 || !stringArray[0].equals(string) || n <= (n2 = CommandManager.getLevenshteinDistance(string2, stringArray[1]))) continue;
            n = n2;
            string3 = stringArray[1];
        }
        return string3;
    }

    public CommandInfo getCommand(String ... stringArray) {
        return this.commands.get(Joiner.on((char)' ').join((Object[])stringArray).toLowerCase());
    }

    public List<CommandInfo> getCommands(String string) {
        string = string.toLowerCase();
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry<String, CommandInfo> entry : this.commands.entrySet()) {
            if (!entry.getKey().startsWith(string) || entry.getValue() == null) continue;
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    private List<String> getLines(CommandSender commandSender, String string) {
        HashSet hashSet = Sets.newHashSet();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CommandInfo commandInfo : this.getCommands(string)) {
            Command command = commandInfo.getCommandAnnotation();
            if (hashSet.contains(commandInfo) || !commandSender.hasPermission("citizens.admin") && !commandSender.hasPermission(command.permission())) continue;
            arrayList.add(this.format(command, string));
            if (command.modifiers().length <= 0) continue;
            hashSet.add(commandInfo);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private String getUsage(String[] stringArray, Command command) {
        return "/" + (stringArray[0] + " ") + command.usage();
    }

    public boolean hasCommand(org.bukkit.command.Command command, String ... stringArray) {
        String string = command.getName().toLowerCase();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        stringArray2[0] = string;
        return this.hasCommand(stringArray2);
    }

    public boolean hasCommand(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("parts must not be empty");
        }
        return this.commands.containsKey(Joiner.on((char)' ').join((Object[])stringArray)) || this.commands.containsKey(stringArray[0] + " *");
    }

    private boolean hasPermission(CommandInfo commandInfo, CommandSender commandSender) {
        Command command = commandInfo.commandAnnotation;
        return command.permission().isEmpty() || commandSender.hasPermission(command.permission()) || commandSender.hasPermission("citizens.admin");
    }

    public List<String> onTabComplete(CommandSender commandSender, org.bukkit.command.Command command, String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray.length <= 2 && stringArray[0].equalsIgnoreCase("help")) {
            return this.getCommands(command.getName().toLowerCase()).stream().map(commandInfo -> ((CommandInfo)commandInfo).commandAnnotation.modifiers().length > 0 ? ((CommandInfo)commandInfo).commandAnnotation.modifiers()[0] : null).collect(Collectors.toList());
        }
        if (stringArray.length <= 1) {
            String string2 = stringArray.length == 1 ? stringArray[0] : "";
            for (String string3 : this.commands.keySet()) {
                String string4;
                String[] stringArray2 = string3.split(" ");
                String string5 = stringArray2[0];
                if (!string5.equalsIgnoreCase(command.getName()) || stringArray2.length < 2 || !(string4 = stringArray2[1]).startsWith(string2)) continue;
                arrayList.add(string4);
            }
            return arrayList;
        }
        CommandInfo commandInfo2 = this.getCommand(command.getName().toLowerCase(), stringArray[0]);
        if (commandInfo2 == null && stringArray.length > 1) {
            commandInfo2 = this.getCommand(command.getName().toLowerCase(), stringArray[0], stringArray[1]);
        }
        if (commandInfo2 == null) {
            return arrayList;
        }
        String[] stringArray3 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray3, 1, stringArray.length);
        stringArray3[0] = command.getName().toLowerCase();
        CommandContext commandContext = new CommandContext(false, commandSender, stringArray3);
        arrayList.addAll(commandInfo2.getArgTabCompletions(commandContext, commandSender, stringArray.length - 1));
        String string6 = (stringArray3.length >= 2 ? stringArray3[stringArray3.length - 2] : stringArray3[stringArray3.length - 1]).toLowerCase();
        String string7 = string6.replaceFirst("--", "");
        if (string6.startsWith("--") && commandInfo2.valueFlags().contains(string7)) {
            arrayList.addAll(commandInfo2.getFlagTabCompletions(commandContext, commandSender, string7));
        } else {
            string6 = stringArray3[stringArray3.length - 1];
            string7 = string6.replaceFirst("--", "");
            boolean bl = string6.isEmpty() || ImmutableSet.of((Object)"-", (Object)"--").contains((Object)string6);
            for (String string8 : commandInfo2.valueFlags()) {
                if ((!string6.startsWith("--") || !string8.startsWith(string7)) && (!bl || commandContext.hasValueFlag(string8))) continue;
                arrayList.add("--" + string8);
            }
            String string9 = commandInfo2.commandAnnotation.flags();
            for (int i = 0; i < string9.length(); ++i) {
                char c = string9.charAt(i);
                if (!string6.isEmpty() || commandContext.hasFlag(c)) continue;
                arrayList.add("-" + c);
            }
        }
        return arrayList;
    }

    public void register(Class<?> clazz) {
        this.registerMethods(clazz, null);
    }

    public void registerAnnotationProcessor(CommandAnnotationProcessor commandAnnotationProcessor) {
        this.annotationProcessors.put(commandAnnotationProcessor.getAnnotationClass(), commandAnnotationProcessor);
    }

    private void registerMethods(Class<?> clazz, Method method) {
        Object object = this.injector != null ? this.injector.getInstance(clazz) : null;
        this.registerMethods(clazz, method, object);
    }

    private void registerMethods(Class<?> clazz, Method method, Object object) {
        for (Method method2 : clazz.getMethods()) {
            int n;
            Class<? extends Annotation> clazz2;
            if (!method2.isAnnotationPresent(Command.class) || !Modifier.isStatic(method2.getModifiers()) && object == null) continue;
            Command command = method2.getAnnotation(Command.class);
            CommandInfo commandInfo = new CommandInfo(command, method2);
            commandInfo.instance = object;
            ArrayList arrayList = Lists.newArrayList();
            for (Annotation object32 : method2.getDeclaringClass().getAnnotations()) {
                clazz2 = object32.annotationType();
                if (!this.annotationProcessors.containsKey(clazz2)) continue;
                arrayList.add(object32);
            }
            Object[] objectArray = method2.getAnnotations();
            int n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                Annotation annotation = objectArray[n];
                clazz2 = annotation.annotationType();
                if (!this.annotationProcessors.containsKey(clazz2)) continue;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Annotation annotation2 = (Annotation)iterator.next();
                    if (annotation2.annotationType() != clazz2) continue;
                    iterator.remove();
                }
                arrayList.add(annotation);
            }
            if (arrayList.size() > 0) {
                commandInfo.annotations = arrayList;
            }
            if ((objectArray = method2.getParameterTypes()).length <= 1 || objectArray[1] == CommandSender.class) {
                commandInfo.serverCommand = true;
            }
            Parameter[] parameterArray = method2.getParameters();
            for (n = 0; n < parameterArray.length; ++n) {
                for (Annotation annotation : parameterArray[n].getAnnotations()) {
                    if (annotation instanceof Flag) {
                        commandInfo.addFlagAnnotation(n, (Class<?>)objectArray[n], (Flag)annotation);
                        continue;
                    }
                    if (!(annotation instanceof Arg)) continue;
                    commandInfo.addArgAnnotation(n, (Class<?>)objectArray[n], (Arg)annotation);
                }
            }
            for (String string : command.aliases()) {
                for (String string2 : command.modifiers()) {
                    this.commands.put(string + " " + string2, commandInfo);
                }
                if (this.commands.containsKey(string + " help")) continue;
                this.commands.put(string + " help", null);
            }
        }
    }

    public void registerTabCompletion(JavaPlugin javaPlugin) {
        for (String string : this.commands.keySet()) {
            PluginCommand pluginCommand = javaPlugin.getCommand(string.split(" ")[0]);
            if (pluginCommand == null) continue;
            pluginCommand.setTabCompleter((TabCompleter)this);
        }
    }

    private void sendHelp(CommandSender commandSender, String string, int n) {
        if (string.equalsIgnoreCase("npc")) {
            string = "NPC";
        }
        Paginator paginator = new Paginator().header(CommandManager.capitalize(string) + " " + Messaging.tr("citizens.commands.help.header", new Object[0])).console(commandSender instanceof ConsoleCommandSender);
        for (String string2 : this.getLines(commandSender, string.toLowerCase())) {
            paginator.addLine(string2);
        }
        if (!paginator.sendPage(commandSender, n)) {
            throw new CommandException("citizens.commands.page-missing", n);
        }
    }

    private void sendSpecificHelp(CommandSender commandSender, String string, String string2) {
        String string3;
        String string4;
        CommandInfo commandInfo = this.getCommand(string, string2);
        if (commandInfo == null) {
            throw new CommandException("citizens.commands.help.command-missing", string + " " + string2);
        }
        Messaging.send(commandSender, this.format(commandInfo.getCommandAnnotation(), string));
        String string5 = Messaging.tryTranslate(commandInfo.getCommandAnnotation().help());
        if (this.translationPrefixProvider != null && !(string4 = this.translationPrefixProvider.apply(commandInfo.getCommandAnnotation()) + ".help").equals(string3 = Messaging.tryTranslate(string4)) && !string3.isEmpty()) {
            string5 = string3;
        }
        if (string5.isEmpty()) {
            return;
        }
        Messaging.send(commandSender, "<aqua>" + string5);
    }

    public void setDefaultDurationUnits(TimeUnit timeUnit) {
        this.defaultDurationUnits = timeUnit;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public void setTranslationPrefixProvider(Function<Command, String> function) {
        this.translationPrefixProvider = function;
    }

    private static String capitalize(Object object) {
        String string = object.toString();
        return string.length() == 0 ? "" : Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    private static int getLevenshteinDistance(String string, String string2) {
        int n;
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n2 = string.length();
        int n3 = string2.length();
        if (n2 == 0) {
            return n3;
        }
        if (n3 == 0) {
            return n2;
        }
        int[] nArray = new int[n2 + 1];
        int[] nArray2 = new int[n2 + 1];
        for (n = 0; n <= n2; ++n) {
            nArray[n] = n;
        }
        for (int i = 1; i <= n3; ++i) {
            char c = string2.charAt(i - 1);
            nArray2[0] = i;
            for (n = 1; n <= n2; ++n) {
                int n4 = string.charAt(n - 1) == c ? 0 : 1;
                nArray2[n] = Math.min(Math.min(nArray2[n - 1] + 1, nArray[n] + 1), nArray[n - 1] + n4);
            }
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        return nArray[n2];
    }

    private static <T extends Enum<?>> T matchEnum(T[] TArray, String string) {
        string = string.toLowerCase().replace('-', '_').replace(' ', '_');
        for (T t : TArray) {
            if (!string.equals(((Enum)t).name().toLowerCase()) && (!string.equals("item") || !((Enum)t).name().equals("DROPPED_ITEM"))) continue;
            return t;
        }
        for (T t : TArray) {
            String string2 = ((Enum)t).name().toLowerCase();
            if (!string2.replace("_", "").equals(string) && !string2.startsWith(string)) continue;
            return t;
        }
        return null;
    }

    public class CommandInfo {
        private List<Annotation> annotations = Lists.newArrayList();
        private final Command commandAnnotation;
        public Object instance;
        private final Method method;
        private final Map<Integer, InjectedCommandArgument> methodArguments = Maps.newHashMap();
        public boolean serverCommand;
        private Collection<String> valueFlags;

        public CommandInfo(Command command, Method method) {
            this.commandAnnotation = command;
            this.method = method;
        }

        public void addArgAnnotation(int n, Class<?> clazz, Arg arg) {
            this.methodArguments.put(n, new InjectedCommandArgument(CommandManager.this.injector, clazz, arg));
        }

        public void addFlagAnnotation(int n, Class<?> clazz, Flag flag) {
            this.methodArguments.put(n, new InjectedCommandArgument(CommandManager.this.injector, clazz, flag));
        }

        private Collection<String> calculateValueFlags() {
            this.valueFlags = new HashSet<String>();
            for (InjectedCommandArgument injectedCommandArgument : this.methodArguments.values()) {
                injectedCommandArgument.getValueFlag().ifPresent(string -> this.valueFlags.add((String)string));
            }
            this.valueFlags.addAll(Arrays.asList(this.commandAnnotation.valueFlags()));
            return this.valueFlags;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CommandInfo commandInfo = (CommandInfo)object;
            return Objects.equals(this.commandAnnotation, commandInfo.commandAnnotation);
        }

        public Collection<? extends String> getArgTabCompletions(CommandContext commandContext, CommandSender commandSender, int n) {
            ArrayList arrayList = Lists.newArrayList();
            for (InjectedCommandArgument injectedCommandArgument : this.methodArguments.values()) {
                if (!injectedCommandArgument.matches(n)) continue;
                String string = n < commandContext.argsLength() ? commandContext.getString(n) : "";
                arrayList.addAll(Collections2.filter((Collection)injectedCommandArgument.getTabCompletions(commandContext, commandSender), string2 -> string.isEmpty() || string2.toLowerCase().startsWith(string.toLowerCase())));
            }
            return arrayList;
        }

        public Command getCommandAnnotation() {
            return this.commandAnnotation;
        }

        public Collection<String> getFlagTabCompletions(CommandContext commandContext, CommandSender commandSender, String string) {
            ArrayList arrayList = Lists.newArrayList();
            for (InjectedCommandArgument injectedCommandArgument : this.methodArguments.values()) {
                if (!injectedCommandArgument.matches(string)) continue;
                String string3 = commandContext.getFlag(string, "");
                arrayList.addAll(Collections2.filter((Collection)injectedCommandArgument.getTabCompletions(commandContext, commandSender), string2 -> string3.isEmpty() || string2.toLowerCase().startsWith(string3.toLowerCase())));
            }
            return arrayList;
        }

        public int hashCode() {
            return 31 + (this.commandAnnotation == null ? 0 : this.commandAnnotation.hashCode());
        }

        public Collection<String> valueFlags() {
            return this.valueFlags == null ? this.calculateValueFlags() : this.valueFlags;
        }
    }

    private static class InjectedCommandArgument {
        private final String[] completions;
        private Arg.CompletionsProvider completionsProvider;
        private final String defaultValue;
        private int index = -1;
        private final String[] names;
        private final Class<?> paramType;
        private String permission;
        private Arg.FlagValidator<?> validator;

        public InjectedCommandArgument(Injector injector, Class<?> clazz, Arg arg) {
            this.paramType = clazz;
            this.names = new String[0];
            this.index = arg.value();
            this.completions = arg.completions();
            String string = this.defaultValue = arg.defValue().isEmpty() ? null : arg.defValue();
            if (arg.validator() != Arg.FlagValidator.Identity.class) {
                this.validator = (Arg.FlagValidator)injector.getInstance(arg.validator());
            }
            if (arg.completionsProvider() != Arg.CompletionsProvider.Identity.class) {
                this.completionsProvider = (Arg.CompletionsProvider)injector.getInstance(arg.completionsProvider());
            }
        }

        public InjectedCommandArgument(Injector injector, Class<?> clazz, Flag flag) {
            this.paramType = clazz;
            this.names = flag.value();
            for (int i = 0; i < this.names.length; ++i) {
                this.names[i] = this.names[i].toLowerCase();
            }
            this.permission = flag.permission().isEmpty() ? null : flag.permission();
            this.completions = flag.completions();
            String string = this.defaultValue = flag.defValue().isEmpty() ? null : flag.defValue();
            if (flag.validator() != Arg.FlagValidator.Identity.class) {
                this.validator = (Arg.FlagValidator)injector.getInstance(flag.validator());
            }
            if (flag.completionsProvider() != Arg.CompletionsProvider.Identity.class) {
                this.completionsProvider = (Arg.CompletionsProvider)injector.getInstance(flag.completionsProvider());
            }
        }

        public Object getInput(CommandContext commandContext) {
            if (this.names.length > 0) {
                String string = this.names[0];
                String string2 = commandContext.getFlag(string, this.defaultValue);
                if (string2 == null && this.names.length > 1 && !this.names[1].isEmpty()) {
                    string2 = commandContext.getFlag(this.names[1], this.defaultValue);
                }
                return string2;
            }
            return commandContext.getString(this.index, this.defaultValue);
        }

        private Collection<String> getTabCompletions(CommandContext commandContext, CommandSender commandSender) {
            if (this.permission != null && !commandSender.hasPermission(this.permission)) {
                return Collections.emptyList();
            }
            if (this.completionsProvider != null) {
                return this.completionsProvider.getCompletions(commandContext, commandSender, CitizensAPI.getDefaultNPCSelector().getSelected(commandSender));
            }
            if (this.completions.length > 0) {
                return Arrays.asList(this.completions);
            }
            if (Enum.class.isAssignableFrom(this.paramType)) {
                Enum[] enumArray = (Enum[])this.paramType.getEnumConstants();
                return Lists.transform(Arrays.asList(enumArray), Enum::name);
            }
            if (this.paramType == Boolean.TYPE || this.paramType == Boolean.class) {
                return Arrays.asList("true", "false");
            }
            return Collections.emptyList();
        }

        public Optional<String> getValueFlag() {
            return this.names.length == 0 ? Optional.empty() : Optional.of(this.names[0]);
        }

        public boolean matches(int n) {
            return this.index == n;
        }

        public boolean matches(String string) {
            return this.names.length > 0 && (this.names[0].equalsIgnoreCase(string) || this.names.length > 1 && this.names[1].equalsIgnoreCase(string));
        }
    }
}

