/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.gui;

import java.util.Arrays;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CitizensInventoryClickEvent
extends InventoryClickEvent {
    private final InventoryClickEvent event;
    private final ItemStack result;

    public CitizensInventoryClickEvent(InventoryClickEvent inventoryClickEvent, int n) {
        super(inventoryClickEvent.getView(), inventoryClickEvent.getSlotType(), inventoryClickEvent.getSlot(), inventoryClickEvent.getClick(), inventoryClickEvent.getAction(), inventoryClickEvent.getHotbarButton());
        this.event = inventoryClickEvent;
        this.result = this.getResult(inventoryClickEvent, n);
    }

    public ItemStack getCurrentItem() {
        return this.event.getCurrentItem() == null || this.event.getCurrentItem().getType() == Material.AIR ? null : this.event.getCurrentItem();
    }

    public ItemStack getCurrentItemNonNull() {
        return this.event.getCurrentItem() == null ? new ItemStack(Material.AIR, 0) : this.event.getCurrentItem();
    }

    public ItemStack getCursor() {
        return this.event.getCursor() == null || this.event.getCursor().getType() == Material.AIR ? null : this.event.getCursor();
    }

    public ItemStack getCursorNonNull() {
        return this.event.getCursor() == null ? new ItemStack(Material.AIR, 0) : this.event.getCursor();
    }

    private ItemStack getResult(InventoryClickEvent inventoryClickEvent, int n) {
        ItemStack itemStack = inventoryClickEvent.getCurrentItem() == null || inventoryClickEvent.getCurrentItem().getType() == Material.AIR ? inventoryClickEvent.getCursor().clone() : inventoryClickEvent.getCurrentItem().clone();
        int n2 = inventoryClickEvent.getCurrentItem() == null || inventoryClickEvent.getCurrentItem().getType() == Material.AIR ? 0 : inventoryClickEvent.getCurrentItem().getAmount();
        switch (inventoryClickEvent.getAction()) {
            case PICKUP_ONE: {
                itemStack.setAmount(n2 - 1);
                break;
            }
            case PICKUP_SOME: {
                itemStack.setAmount(n2 - n);
                break;
            }
            case PICKUP_HALF: {
                itemStack.setAmount((int)Math.floor((double)n2 / 2.0));
                break;
            }
            case PICKUP_ALL: {
                itemStack = null;
                break;
            }
            case PLACE_ALL: 
            case PLACE_SOME: {
                itemStack.setAmount(Math.min(n2 + inventoryClickEvent.getCursor().getAmount(), itemStack.getType().getMaxStackSize()));
                break;
            }
            case PLACE_ONE: {
                itemStack.setAmount(Math.min(n2 + 1, itemStack.getType().getMaxStackSize()));
                break;
            }
            default: {
                inventoryClickEvent.setCancelled(true);
                inventoryClickEvent.setResult(Event.Result.DENY);
                return null;
            }
        }
        return itemStack;
    }

    public ItemStack getResultItem() {
        return this.result;
    }

    public ItemStack getResultItemNonNull() {
        return this.result == null ? new ItemStack(Material.AIR, 0) : this.result;
    }

    public void setCancelled(boolean bl) {
        this.event.setCancelled(bl);
    }

    public void setCurrentItem(ItemStack itemStack) {
        this.event.setCurrentItem(itemStack);
    }

    public void setCurrentItemDescription(String string) {
        ItemMeta itemMeta = this.getCurrentItem().getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        itemMeta.setLore(Arrays.asList(Messaging.parseComponents(string).split("\n")));
        this.event.getCurrentItem().setItemMeta(itemMeta);
    }

    public void setCursor(ItemStack itemStack) {
        this.event.setCursor(itemStack);
    }

    public void setResult(Event.Result result) {
        this.event.setResult(result);
    }
}

