/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.citizensnpcs.api.gui.CitizensInventoryClickEvent;
import net.citizensnpcs.api.gui.ClickHandler;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.gui.MenuSlot;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InputMenus {
    public static BooleanSlotHandler clickToggle(Function<Boolean, String> function, boolean bl) {
        return new BooleanSlotHandler(function, bl);
    }

    public static InventoryMenuPage filteredStringSetter(Supplier<String> supplier, Function<String, Boolean> function) {
        return new StringInputMenu(supplier, function);
    }

    public static <T> InventoryMenuPage picker(String string, Consumer<Choice<T>> consumer, Choice<T> ... choiceArray) {
        return new ChoiceInputMenu(string, Choice.Type.PICKER, list -> consumer.accept(list.size() > 0 ? (Choice)list.get(0) : null), choiceArray);
    }

    public static InventoryMenuPage stringSetter(Supplier<String> supplier, Consumer<String> consumer) {
        return new StringInputMenu(supplier, string -> {
            consumer.accept((String)string);
            return true;
        });
    }

    public static <T> InventoryMenuPage toggle(String string, Consumer<List<Choice<T>>> consumer, Choice<T> ... choiceArray) {
        return new ChoiceInputMenu<T>(string, Choice.Type.TOGGLE, consumer, choiceArray);
    }

    public static BooleanSlotHandler toggler(Consumer<Boolean> consumer, boolean bl2) {
        return new BooleanSlotHandler(bl -> {
            consumer.accept((Boolean)bl);
            return bl != false ? ChatColor.GREEN + "On" : ChatColor.RED + "Off";
        }, bl2);
    }

    public static class BooleanSlotHandler
    implements Consumer<CitizensInventoryClickEvent> {
        private final Function<Boolean, String> transformer;
        private boolean value;

        public BooleanSlotHandler(Function<Boolean, String> function) {
            this(function, false);
        }

        public BooleanSlotHandler(Function<Boolean, String> function, boolean bl) {
            this.transformer = function;
            this.value = bl;
        }

        @Override
        public void accept(CitizensInventoryClickEvent citizensInventoryClickEvent) {
            this.value = !this.value;
            citizensInventoryClickEvent.setCurrentItemDescription(this.transformer.apply(this.value));
            citizensInventoryClickEvent.setResult(Event.Result.DENY);
        }
    }

    @Menu(type=InventoryType.ANVIL)
    private static class StringInputMenu
    extends InventoryMenuPage {
        private final Function<String, Boolean> callback;
        private MenuContext ctx;
        @MenuSlot(slot={0, 0}, material=Material.PAPER, amount=1)
        private InventoryMenuSlot from;
        private final Supplier<String> initialValue;

        public StringInputMenu(Supplier<String> supplier, Function<String, Boolean> function) {
            this.initialValue = supplier;
            this.callback = function;
        }

        @ClickHandler(slot={0, 0})
        public void cancel(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
            citizensInventoryClickEvent.setCancelled(true);
            this.ctx.getMenu().transitionBack();
        }

        @Override
        public void initialise(MenuContext menuContext) {
            this.ctx = menuContext;
            ItemStack itemStack = this.from.getCurrentItem();
            ItemMeta itemMeta = itemStack.getItemMeta();
            String string = this.initialValue.get();
            itemMeta.setDisplayName(string == null ? "Not set" : string);
            itemStack.setItemMeta(itemMeta);
        }

        @ClickHandler(slot={0, 2})
        public void save(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
            String string;
            citizensInventoryClickEvent.setCancelled(true);
            String string2 = string = inventoryMenuSlot.getCurrentItem() != null && inventoryMenuSlot.getCurrentItem().getItemMeta() != null ? inventoryMenuSlot.getCurrentItem().getItemMeta().getDisplayName() : null;
            if (string != null && (string.isEmpty() || string.equalsIgnoreCase("Not set") || string.equalsIgnoreCase("null"))) {
                string = null;
            }
            if (this.callback.apply(string).booleanValue()) {
                this.ctx.getMenu().transitionBack();
            }
        }
    }

    @Menu(type=InventoryType.CHEST)
    private static class ChoiceInputMenu<T>
    extends InventoryMenuPage {
        private final Consumer<List<Choice<T>>> callback;
        private final Choice<T>[] choices;
        private final String title;
        private final Choice.Type type;

        public ChoiceInputMenu(String string, Choice.Type type, Consumer<List<Choice<T>>> consumer, Choice<T>[] choiceArray) {
            this.title = string;
            this.callback = consumer;
            this.choices = choiceArray;
            this.type = type;
        }

        @Override
        public Inventory createInventory(String string) {
            if (this.choices.length <= 3) {
                return Bukkit.createInventory(null, (InventoryType)InventoryType.HOPPER, (String)this.title);
            }
            return Bukkit.createInventory(null, (int)Math.min(54, this.choices.length / 5 * 9 + 9), (String)this.title);
        }

        @Override
        public void initialise(MenuContext menuContext) {
            for (int i = 0; i < this.choices.length; ++i) {
                Choice<T> choice = this.choices[i];
                InventoryMenuSlot inventoryMenuSlot = menuContext.getSlot(i * 2);
                inventoryMenuSlot.setItemStack(choice.createDisplayItem());
                inventoryMenuSlot.setClickHandler(citizensInventoryClickEvent -> {
                    citizensInventoryClickEvent.setCancelled(true);
                    boolean bl = !choice.isActive();
                    switch (this.type.ordinal()) {
                        case 1: {
                            choice.setActive(bl);
                            inventoryMenuSlot.setItemStack(choice.createDisplayItem());
                            break;
                        }
                        case 0: {
                            for (int i = 0; i < this.choices.length; ++i) {
                                this.choices[i].setActive(false);
                            }
                            choice.setActive(true);
                            menuContext.getMenu().transitionBack();
                        }
                    }
                });
            }
        }

        @Override
        public void onClose(HumanEntity humanEntity) {
            ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)this.choices.length);
            for (Choice<T> choice : this.choices) {
                if (!choice.isActive()) continue;
                arrayList.add(choice);
            }
            this.callback.accept(arrayList);
        }
    }

    public static class Choice<T> {
        private boolean active;
        private String description;
        private Material material;
        private T value;

        public ItemStack createDisplayItem() {
            ItemStack itemStack = new ItemStack(this.getDisplayMaterial(), 1);
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (this.getDescription().contains("\n")) {
                String[] stringArray = this.getDescription().split("\n", 2);
                itemMeta.setDisplayName(stringArray[0]);
                itemMeta.setLore(Arrays.asList(stringArray[1].split("\n")));
            } else if (this.getValue() instanceof Enum) {
                String string = ((Enum)this.getValue()).name();
                itemMeta.setDisplayName(string.charAt(0) + string.substring(1).toLowerCase());
                itemMeta.setLore(Arrays.asList(this.getDescription().split("\n")));
            }
            itemMeta.setDisplayName((this.isActive() ? ChatColor.GREEN : ChatColor.RED) + itemMeta.getDisplayName());
            itemStack.setItemMeta(itemMeta);
            return itemStack;
        }

        public String getDescription() {
            return Messaging.parseComponents(this.description);
        }

        public Material getDisplayMaterial() {
            return this.material;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean bl) {
            this.active = bl;
        }

        public static <T> Choice<T> of(T t, Material material, String string, boolean bl) {
            Choice<T> choice = new Choice<T>();
            choice.active = bl;
            choice.material = material;
            choice.value = t;
            choice.description = string;
            return choice;
        }

        public static enum Type {
            PICKER,
            TOGGLE;

        }
    }
}

