/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.gui.CitizensInventoryClickEvent;
import net.citizensnpcs.api.gui.ClickHandler;
import net.citizensnpcs.api.gui.ForwardingInventory;
import net.citizensnpcs.api.gui.InjectContext;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuPattern;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.InventoryMenuTransition;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.gui.MenuPattern;
import net.citizensnpcs.api.gui.MenuSlot;
import net.citizensnpcs.api.gui.MenuTransition;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class InventoryMenu
implements Listener,
Runnable {
    private final List<Runnable> closeCallbacks = Lists.newArrayList();
    private boolean closingViews;
    private boolean delayViewerChanges;
    private PageContext page;
    private int pickupAmount = -1;
    private final Deque<PageContext> stack = Queues.newArrayDeque();
    private boolean transitioning;
    private Collection<InventoryView> views = Lists.newArrayList();
    private static Map<Class<? extends InventoryMenuPage>, InventoryMenuInfo> CACHED_INFOS = new WeakHashMap<Class<? extends InventoryMenuPage>, InventoryMenuInfo>();

    public InventoryMenu(InventoryMenuInfo inventoryMenuInfo, InventoryMenuPage inventoryMenuPage) {
        this.transition(inventoryMenuInfo, inventoryMenuPage, Maps.newHashMap());
    }

    private InventoryMenu(InventoryMenuInfo inventoryMenuInfo, Map<String, Object> map) {
        this.transition(inventoryMenuInfo, inventoryMenuInfo.createInstance(), map);
    }

    private boolean acceptFilter(InventoryAction inventoryAction, InventoryAction[] inventoryActionArray) {
        for (InventoryAction inventoryAction2 : inventoryActionArray) {
            if (inventoryAction != inventoryAction2) continue;
            return true;
        }
        return inventoryActionArray.length == 0;
    }

    private void addCloseCallback(Runnable runnable) {
        this.closeCallbacks.add(runnable);
    }

    public void close() {
        HandlerList.unregisterAll((Listener)this);
        this.closingViews = true;
        this.runViewerModifier(() -> {
            for (InventoryView inventoryView : this.views) {
                if (this.page != null) {
                    this.page.page.onClose(inventoryView.getPlayer());
                }
                inventoryView.close();
            }
            this.views.clear();
            this.closingViews = false;
        });
    }

    public void close(HumanEntity humanEntity) {
        this.closingViews = true;
        this.runViewerModifier(() -> {
            Iterator<InventoryView> iterator = this.views.iterator();
            while (iterator.hasNext()) {
                InventoryView inventoryView = iterator.next();
                if (inventoryView.getPlayer() != humanEntity) continue;
                inventoryView.close();
                iterator.remove();
            }
            this.closingViews = false;
        });
    }

    private InventoryMenuSlot createSlot(int n, MenuSlot menuSlot) {
        InventoryMenuSlot inventoryMenuSlot = this.page.ctx.getSlot(n);
        inventoryMenuSlot.initialise(menuSlot);
        return inventoryMenuSlot;
    }

    private InventoryMenuTransition createTransition(int n, MenuTransition menuTransition) {
        InventoryMenuSlot inventoryMenuSlot = this.page.ctx.getSlot(n);
        InventoryMenuTransition inventoryMenuTransition = new InventoryMenuTransition(inventoryMenuSlot, menuTransition.value());
        return inventoryMenuTransition;
    }

    private int getInventorySize(InventoryType inventoryType, int[] nArray) {
        switch (inventoryType) {
            case CHEST: {
                int n = nArray[0] * nArray[1];
                if (n % 9 != 0) {
                    n += 9 - n % 9;
                }
                nArray[0] = Math.min(54, n) / 9;
                nArray[1] = 9;
                return Math.max(9, Math.min(54, n));
            }
            case ANVIL: 
            case BLAST_FURNACE: 
            case CARTOGRAPHY: 
            case FURNACE: 
            case GRINDSTONE: 
            case SMITHING: 
            case SMOKER: {
                nArray[0] = 0;
                nArray[1] = 3;
                return 3;
            }
            case BARREL: 
            case ENDER_CHEST: 
            case SHULKER_BOX: {
                nArray[0] = 3;
                nArray[1] = 9;
                return 27;
            }
            case BEACON: 
            case LECTERN: {
                nArray[0] = 0;
                nArray[1] = 1;
                return 1;
            }
            case BREWING: 
            case HOPPER: {
                nArray[0] = 0;
                nArray[1] = 5;
                return 5;
            }
            case DISPENSER: 
            case DROPPER: {
                nArray[0] = 0;
                nArray[1] = 9;
                return 9;
            }
            case ENCHANTING: 
            case STONECUTTER: {
                nArray[0] = 0;
                nArray[1] = 2;
                return 2;
            }
            case LOOM: {
                nArray[0] = 0;
                nArray[1] = 4;
                return 4;
            }
            case PLAYER: {
                nArray[0] = 4;
                nArray[1] = 9;
                return 41;
            }
            case WORKBENCH: {
                nArray[0] = 0;
                nArray[1] = 10;
                return 10;
            }
        }
        throw new UnsupportedOperationException();
    }

    private void handleClick(InventoryClickEvent inventoryClickEvent) {
        Inventory inventory;
        Inventory inventory2 = inventory = inventoryClickEvent.getClickedInventory() != null ? inventoryClickEvent.getClickedInventory() : inventoryClickEvent.getInventory();
        if (inventoryClickEvent.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            if (!this.views.stream().anyMatch(inventoryView -> inventoryClickEvent.getWhoClicked().equals((Object)inventoryView.getPlayer()))) {
                return;
            }
            inventoryClickEvent.setCancelled(true);
            PlayerInventory playerInventory = inventoryClickEvent.getInventory() == inventoryClickEvent.getClickedInventory() ? inventoryClickEvent.getWhoClicked().getInventory() : this.page.ctx.getInventory();
            boolean bl = playerInventory == this.page.ctx.getInventory();
            this.handleShiftClick(inventoryClickEvent, (Inventory)playerInventory, bl);
            return;
        }
        if (!this.isOurInventory(inventory)) {
            return;
        }
        switch (inventoryClickEvent.getAction()) {
            case COLLECT_TO_CURSOR: {
                inventoryClickEvent.setCancelled(true);
            }
            case UNKNOWN: 
            case DROP_ONE_CURSOR: 
            case DROP_ALL_CURSOR: {
                return;
            }
        }
        if (inventoryClickEvent.getSlot() < 0) {
            return;
        }
        InventoryMenuSlot inventoryMenuSlot = this.page.ctx.getSlot(inventoryClickEvent.getSlot());
        CitizensInventoryClickEvent citizensInventoryClickEvent = new CitizensInventoryClickEvent(inventoryClickEvent, this.pickupAmount);
        PageContext pageContext = this.page;
        inventoryMenuSlot.onClick(citizensInventoryClickEvent);
        this.pickupAmount = -1;
        pageContext.page.onClick(inventoryMenuSlot, inventoryClickEvent);
        if (pageContext != this.page) {
            inventoryClickEvent.setCancelled(true);
        }
        if (inventoryClickEvent.isCancelled()) {
            return;
        }
        for (InventoryMenuTransition inventoryMenuTransition : this.page.transitions) {
            Class<? extends InventoryMenuPage> clazz = inventoryMenuTransition.accept(inventoryMenuSlot);
            if (clazz == null) continue;
            inventoryClickEvent.setCancelled(true);
            this.transition(clazz);
            break;
        }
    }

    private void handleShiftClick(InventoryClickEvent inventoryClickEvent, Inventory inventory, boolean bl) {
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        int n = inventoryClickEvent.getCurrentItem().getAmount();
        ItemStack itemStack = new ItemStack(inventoryClickEvent.getCurrentItem().clone());
        ItemStack[] itemStackArray = inventory.getContents();
        PageContext pageContext = this.page;
        for (int i = 0; i < itemStackArray.length && pageContext == this.page; ++i) {
            InventoryAction inventoryAction;
            ItemStack itemStack2;
            if (itemStackArray[i] == null || itemStackArray[i].getType() == Material.AIR) {
                itemStack.setAmount(n);
                if (bl) {
                    inventoryClickEvent.getView().setCursor(itemStack);
                }
                itemStack2 = new InventoryClickEvent(inventoryClickEvent.getView(), inventoryClickEvent.getSlotType(), bl ? i : inventoryClickEvent.getRawSlot(), inventoryClickEvent.getClick(), bl ? InventoryAction.PLACE_ALL : InventoryAction.PICKUP_ALL);
                this.onInventoryClick((InventoryClickEvent)itemStack2);
                if (bl) {
                    inventoryClickEvent.getView().setCursor(null);
                }
                if (!itemStack2.isCancelled()) {
                    inventory.setItem(i, itemStack);
                    inventoryClickEvent.setCurrentItem(null);
                    break;
                }
                if (inventory.getItem(i) == null || !inventory.getItem(i).isSimilar(itemStack)) continue;
                break;
            }
            if (!itemStackArray[i].isSimilar(inventoryClickEvent.getCurrentItem())) continue;
            itemStack2 = itemStackArray[i].clone();
            itemStack.setAmount(Math.min(n, itemStack2.getType().getMaxStackSize() - itemStack2.getAmount()));
            if (bl) {
                inventoryClickEvent.getView().setCursor(itemStack);
                inventoryAction = n - itemStack.getAmount() <= 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_SOME;
            } else {
                inventoryAction = n - itemStack.getAmount() <= 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_SOME;
                this.pickupAmount = itemStack.getAmount();
            }
            InventoryClickEvent inventoryClickEvent2 = new InventoryClickEvent(inventoryClickEvent.getView(), inventoryClickEvent.getSlotType(), bl ? i : inventoryClickEvent.getRawSlot(), inventoryClickEvent.getClick(), inventoryAction);
            this.onInventoryClick(inventoryClickEvent2);
            if (bl) {
                inventoryClickEvent.getView().setCursor(null);
            }
            if (inventoryClickEvent2.isCancelled()) continue;
            itemStack2.setAmount(itemStack2.getAmount() + itemStack.getAmount());
            inventory.setItem(i, itemStack2);
            inventoryClickEvent.getCurrentItem().setAmount(n -= itemStack.getAmount());
            if (n <= 0) break;
        }
    }

    private boolean isOurInventory(Inventory inventory) {
        if (inventory instanceof ForwardingInventory && ((ForwardingInventory)inventory).getWrapped().equals((Object)this.page.ctx.getInventory())) {
            return true;
        }
        return inventory.equals((Object)this.page.ctx.getInventory());
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        if (this.page == null || this.transitioning || this.closingViews) {
            if (this.transitioning && this.isOurInventory(inventoryClickEvent.getClickedInventory() != null ? inventoryClickEvent.getClickedInventory() : inventoryClickEvent.getInventory())) {
                inventoryClickEvent.setCancelled(true);
            }
            return;
        }
        this.delayViewerChanges = true;
        try {
            this.handleClick(inventoryClickEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            inventoryClickEvent.getWhoClicked().closeInventory();
        }
        this.delayViewerChanges = false;
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent inventoryCloseEvent) {
        if (this.page == null || !this.isOurInventory(inventoryCloseEvent.getInventory()) || this.closingViews) {
            return;
        }
        this.delayViewerChanges = true;
        this.transitionBack();
        this.delayViewerChanges = false;
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent inventoryDragEvent) {
        if (this.page != null && this.isOurInventory(inventoryDragEvent.getInventory())) {
            inventoryDragEvent.setCancelled(true);
        }
    }

    private InventoryView openInventory(HumanEntity humanEntity, Inventory inventory, String string) {
        InventoryView inventoryView = inventory.getType() == InventoryType.ANVIL ? CitizensAPI.getNMSHelper().openAnvilInventory((Player)humanEntity, inventory, string) : humanEntity.openInventory(inventory);
        if (inventoryView == null) {
            throw new RuntimeException("null inventory opened " + humanEntity + " " + inventory + " " + string);
        }
        return inventoryView;
    }

    private InventoryMenuPattern parsePattern(int[] nArray, List<InventoryMenuTransition> list, Bindable<MenuPattern> bindable) {
        String string = ((MenuPattern)bindable.data).value();
        HashMap hashMap = Maps.newHashMap();
        for (MenuSlot menuSlot : ((MenuPattern)bindable.data).slots()) {
            hashMap.put(Character.valueOf(menuSlot.pat()), menuSlot);
        }
        HashMap hashMap2 = Maps.newHashMap();
        for (MenuTransition menuTransition : ((MenuPattern)bindable.data).transitions()) {
            hashMap2.put(Character.valueOf(menuTransition.pat()), menuTransition);
        }
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            MenuTransition menuTransition;
            char c = string.charAt(i);
            if (c == '\n' || c == '\\' && i + 1 < string.length() && string.charAt(i + 1) == 'n') {
                if (c != '\n') {
                    ++i;
                }
                ++n;
                n2 = 0;
                continue;
            }
            int[] nArray2 = ((MenuPattern)bindable.data).offset();
            nArray2[0] = nArray2[0] + n;
            nArray2[1] = nArray2[1] + n2;
            MenuSlot menuSlot = (MenuSlot)hashMap.get(Character.valueOf(c));
            if (menuSlot != null) {
                arrayList.add(this.createSlot(this.posToIndex(nArray, nArray2), menuSlot));
            }
            if ((menuTransition = (MenuTransition)hashMap2.get(Character.valueOf(c))) != null) {
                InventoryMenuTransition inventoryMenuTransition = this.createTransition(this.posToIndex(nArray, nArray2), menuTransition);
                arrayList2.add(inventoryMenuTransition);
                list.add(inventoryMenuTransition);
            }
            ++n2;
        }
        return new InventoryMenuPattern((MenuPattern)bindable.data, arrayList, arrayList2);
    }

    private int posToIndex(int[] nArray, int[] nArray2) {
        return nArray2[0] * nArray[1] + nArray2[1];
    }

    public void present(HumanEntity humanEntity) {
        this.views.add(this.openInventory(humanEntity, this.page.ctx.getInventory(), this.page.ctx.getTitle()));
    }

    @Override
    public void run() {
        if (this.page == null || this.transitioning) {
            return;
        }
        this.page.page.run();
    }

    private void runViewerModifier(Runnable runnable) {
        if (this.delayViewerChanges) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), runnable);
        } else {
            runnable.run();
        }
    }

    public void transition(Class<? extends InventoryMenuPage> clazz) {
        this.transition(clazz, (Map<String, Object>)Maps.newHashMap());
    }

    public void transition(Class<? extends InventoryMenuPage> clazz, Map<String, Object> map) {
        if (!CACHED_INFOS.containsKey(clazz)) {
            InventoryMenu.cacheInfo(clazz);
        }
        InventoryMenuInfo inventoryMenuInfo = CACHED_INFOS.get(clazz);
        this.transition(inventoryMenuInfo, inventoryMenuInfo.createInstance(), map);
    }

    private void transition(InventoryMenuInfo inventoryMenuInfo, InventoryMenuPage inventoryMenuPage, Map<String, Object> map) {
        Invokable<ClickHandler> invokable2;
        int n;
        Bindable<Annotation> bindable;
        int n2;
        int n3;
        InventoryType inventoryType;
        if (this.page != null) {
            for (Map.Entry<String, Object> entry : this.page.ctx.data().entrySet()) {
                map.putIfAbsent(entry.getKey(), entry.getValue());
            }
            this.page.ctx.data().clear();
            this.stack.addLast(this.page);
        }
        this.page = new PageContext();
        this.page.page = inventoryMenuPage;
        Object object = inventoryMenuInfo.menuAnnotation.dimensions();
        String string = Messaging.parseComponents(Messaging.tryTranslate(map.containsKey("title") ? (String)map.get("title") : inventoryMenuInfo.menuAnnotation.title()));
        Inventory inventory = inventoryMenuPage.createInventory(string);
        if (inventory == null) {
            inventoryType = inventoryMenuInfo.menuAnnotation.type();
            n3 = this.getInventorySize(inventoryType, (int[])object);
            inventory = inventoryType == InventoryType.CHEST || inventoryType == null ? Bukkit.createInventory(null, (int)n3, (String)string) : Bukkit.createInventory(null, (InventoryType)inventoryType, (String)string);
        } else {
            inventoryType = inventory.getType();
            n3 = this.getInventorySize(inventoryType, (int[])object);
        }
        ArrayList arrayList = Lists.newArrayList();
        InventoryMenuSlot[] inventoryMenuSlotArray = new InventoryMenuSlot[inventory.getSize()];
        PageContext.access$402(this.page, new InventoryMenuPattern[inventoryMenuInfo.patterns.length]);
        this.page.ctx = new MenuContext(this, inventoryMenuSlotArray, inventory, string, map);
        for (n2 = 0; n2 < inventoryMenuInfo.slots.length; ++n2) {
            bindable = inventoryMenuInfo.slots[n2];
            n = this.posToIndex((int[])object, ((MenuSlot)bindable.data).slot());
            invokable2 = this.createSlot(n, (MenuSlot)bindable.data);
            bindable.bind(this.page.page, invokable2);
        }
        for (n2 = 0; n2 < inventoryMenuInfo.transitions.length; ++n2) {
            bindable = inventoryMenuInfo.transitions[n2];
            n = this.posToIndex((int[])object, ((MenuTransition)bindable.data).pos());
            invokable2 = this.createTransition(n, (MenuTransition)bindable.data);
            bindable.bind(this.page.page, invokable2);
            arrayList.add(invokable2);
        }
        for (n2 = 0; n2 < inventoryMenuInfo.patterns.length; ++n2) {
            bindable = inventoryMenuInfo.patterns[n2];
            InventoryMenuPattern inventoryMenuPattern = this.parsePattern((int[])object, arrayList, bindable);
            bindable.bind(this.page.page, inventoryMenuPattern);
            ((PageContext)this.page).patterns[n2] = inventoryMenuPattern;
        }
        PageContext.access$202(this.page, arrayList.toArray(new InventoryMenuTransition[arrayList.size()]));
        inventoryMenuInfo.inject(this.page.page, this.page.ctx.data());
        this.page.page.initialise(this.page.ctx);
        for (Invokable<ClickHandler> invokable2 : inventoryMenuInfo.clickHandlers) {
            int n4 = this.posToIndex((int[])object, ((ClickHandler)((Invokable)invokable2).data).slot());
            InventoryMenuSlot inventoryMenuSlot = this.page.ctx.getSlot(n4);
            inventoryMenuSlot.addClickHandler(citizensInventoryClickEvent -> {
                if (citizensInventoryClickEvent.getSlot() != n4) {
                    return;
                }
                if (this.acceptFilter(citizensInventoryClickEvent.getAction(), ((ClickHandler)((Invokable)invokable2).data).filter())) {
                    try {
                        ((Invokable)invokable2).method.invoke(this.page.page, inventoryMenuSlot, (CitizensInventoryClickEvent)((Object)citizensInventoryClickEvent));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                } else {
                    citizensInventoryClickEvent.setCancelled(true);
                    citizensInventoryClickEvent.setResult(Event.Result.DENY);
                    return;
                }
            });
        }
        this.transitionViewersToInventory(inventory);
    }

    public void transition(InventoryMenuPage inventoryMenuPage) {
        this.transition(inventoryMenuPage, (Map<String, Object>)Maps.newHashMap());
    }

    public void transition(InventoryMenuPage inventoryMenuPage, Map<String, Object> map) {
        Class<?> clazz = inventoryMenuPage.getClass();
        if (!CACHED_INFOS.containsKey(clazz)) {
            InventoryMenu.cacheInfo(clazz);
        }
        InventoryMenuInfo inventoryMenuInfo = CACHED_INFOS.get(clazz);
        this.transition(inventoryMenuInfo, inventoryMenuPage, map);
    }

    public void transitionBack() {
        if (this.page == null) {
            return;
        }
        for (InventoryView object : this.views) {
            this.page.page.onClose(object.getPlayer());
        }
        Map<String, Object> map = this.page.ctx.data();
        this.page = this.stack.pollLast();
        if (this.page != null) {
            this.page.ctx.data().putAll(map);
            this.page.page.initialise(this.page.ctx);
        }
        map.clear();
        this.transitionViewersToInventory(this.page == null ? null : this.page.ctx.getInventory());
        if (this.page == null) {
            for (Runnable runnable : this.closeCallbacks) {
                runnable.run();
            }
        }
    }

    private void transitionViewersToInventory(Inventory inventory) {
        if (this.views.size() == 0) {
            return;
        }
        this.transitioning = true;
        this.runViewerModifier(() -> {
            Collection<InventoryView> collection = this.views;
            this.views = Lists.newArrayListWithExpectedSize((int)collection.size());
            for (InventoryView inventoryView : collection) {
                inventoryView.close();
                if (!inventoryView.getPlayer().isValid() || inventory == null) continue;
                this.views.add(this.openInventory(inventoryView.getPlayer(), inventory, this.page.ctx.getTitle()));
            }
            this.transitioning = false;
        });
    }

    void updateTitle(String string) {
        for (InventoryView inventoryView : this.views) {
            CitizensAPI.getNMSHelper().updateInventoryTitle((Player)inventoryView.getPlayer(), inventoryView, string);
        }
    }

    private static void cacheInfo(Class<? extends InventoryMenuPage> clazz) {
        InventoryMenuInfo inventoryMenuInfo = new InventoryMenuInfo(clazz);
        inventoryMenuInfo.menuAnnotation = clazz.getAnnotation(Menu.class);
        if (inventoryMenuInfo.menuAnnotation == null) {
            throw new IllegalArgumentException("Missing menu annotation");
        }
        try {
            Constructor<? extends InventoryMenuPage> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            inventoryMenuInfo.constructor = constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        CACHED_INFOS.put(clazz, inventoryMenuInfo);
    }

    public static InventoryMenu create(Class<? extends InventoryMenuPage> clazz) {
        return InventoryMenu.createWithContext(clazz, Maps.newHashMap());
    }

    public static InventoryMenu create(InventoryMenuPage inventoryMenuPage) {
        Class<?> clazz = inventoryMenuPage.getClass();
        if (!CACHED_INFOS.containsKey(clazz)) {
            InventoryMenu.cacheInfo(clazz);
        }
        return new InventoryMenu(CACHED_INFOS.get(clazz), inventoryMenuPage);
    }

    public static InventoryMenu createSelfRegistered(Class<? extends InventoryMenuPage> clazz) {
        InventoryMenu inventoryMenu = InventoryMenu.create(clazz);
        Bukkit.getPluginManager().registerEvents((Listener)inventoryMenu, CitizensAPI.getPlugin());
        inventoryMenu.addCloseCallback(() -> HandlerList.unregisterAll((Listener)inventoryMenu));
        return inventoryMenu;
    }

    public static InventoryMenu createSelfRegistered(InventoryMenuPage inventoryMenuPage) {
        InventoryMenu inventoryMenu = InventoryMenu.create(inventoryMenuPage);
        Bukkit.getPluginManager().registerEvents((Listener)inventoryMenu, CitizensAPI.getPlugin());
        inventoryMenu.addCloseCallback(() -> HandlerList.unregisterAll((Listener)inventoryMenu));
        return inventoryMenu;
    }

    public static InventoryMenu createWithContext(Class<? extends InventoryMenuPage> clazz, Map<String, Object> map) {
        if (!CACHED_INFOS.containsKey(clazz)) {
            InventoryMenu.cacheInfo(clazz);
        }
        return new InventoryMenu(CACHED_INFOS.get(clazz), map);
    }

    private static class InventoryMenuInfo {
        final Invokable<ClickHandler>[] clickHandlers;
        Constructor<? extends InventoryMenuPage> constructor;
        final Map<String, MethodHandle> injectables;
        Menu menuAnnotation;
        final Bindable<MenuPattern>[] patterns;
        final Bindable<MenuSlot>[] slots;
        final Bindable<MenuTransition>[] transitions;
        private static MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

        public InventoryMenuInfo(Class<?> clazz) {
            this.patterns = this.getBindables(clazz, MenuPattern.class, InventoryMenuPattern.class);
            this.slots = this.getBindables(clazz, MenuSlot.class, InventoryMenuSlot.class);
            this.transitions = this.getBindables(clazz, MenuTransition.class, InventoryMenuTransition.class);
            this.clickHandlers = this.getClickHandlers(clazz);
            this.injectables = this.getInjectables(clazz);
        }

        public InventoryMenuPage createInstance() {
            if (this.constructor == null) {
                throw new RuntimeException("no constructor provided");
            }
            try {
                return this.constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        /*
         * WARNING - void declaration
         */
        private <T extends Annotation> Bindable<T>[] getBindables(Class<?> clazz, Class<T> clazz2, Class<?> clazz3) {
            void var8_14;
            ArrayList arrayList = Lists.newArrayList();
            for (Field annotationArray : clazz.getDeclaredFields()) {
                annotationArray.setAccessible(true);
                Annotation[] annotationArray2 = annotationArray.getAnnotationsByType(clazz2);
                MethodHandle methodHandle = null;
                if (annotationArray.getType() == clazz3) {
                    try {
                        methodHandle = LOOKUP.unreflectSetter(annotationArray);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                }
                for (Annotation annotation : annotationArray2) {
                    arrayList.add(new Bindable<Annotation>(methodHandle, annotation));
                }
            }
            ArrayList arrayList2 = Lists.newArrayList();
            arrayList2.addAll(Arrays.asList(clazz.getDeclaredConstructors()));
            arrayList2.addAll(Arrays.asList(clazz.getDeclaredMethods()));
            Annotation[] annotationArray = arrayList2.iterator();
            while (annotationArray.hasNext()) {
                AccessibleObject accessibleObject = (AccessibleObject)annotationArray.next();
                accessibleObject.setAccessible(true);
                for (Annotation annotation : accessibleObject.getAnnotationsByType(clazz2)) {
                    arrayList.add(new Bindable<Annotation>(null, annotation));
                }
            }
            annotationArray = clazz.getAnnotationsByType(clazz2);
            int n = annotationArray.length;
            boolean bl = false;
            while (var8_14 < n) {
                Annotation annotation = annotationArray[var8_14];
                arrayList.add(new Bindable<Annotation>(null, annotation));
                ++var8_14;
            }
            return arrayList.toArray(new Bindable[arrayList.size()]);
        }

        private Invokable<ClickHandler>[] getClickHandlers(Class<?> clazz) {
            ArrayList arrayList = Lists.newArrayList();
            for (Method method : clazz.getDeclaredMethods()) {
                method.setAccessible(true);
                for (ClickHandler clickHandler : (ClickHandler[])method.getAnnotationsByType(ClickHandler.class)) {
                    try {
                        arrayList.add(new Invokable<ClickHandler>(clickHandler, LOOKUP.unreflect(method)));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                }
                for (Annotation annotation : (MenuSlot[])method.getAnnotationsByType(MenuSlot.class)) {
                    try {
                        arrayList.add(new Invokable<1>(new ClickHandler(){
                            final /* synthetic */ MenuSlot val$slot;
                            {
                                this.val$slot = menuSlot;
                            }

                            @Override
                            public Class<? extends Annotation> annotationType() {
                                return ClickHandler.class;
                            }

                            @Override
                            public InventoryAction[] filter() {
                                return new InventoryAction[0];
                            }

                            @Override
                            public int[] slot() {
                                return this.val$slot.slot();
                            }
                        }, LOOKUP.unreflect(method)));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                }
            }
            return arrayList.toArray(new Invokable[arrayList.size()]);
        }

        private Map<String, MethodHandle> getInjectables(Class<?> clazz) {
            HashMap hashMap = Maps.newHashMap();
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                if (!field.isAnnotationPresent(InjectContext.class)) continue;
                try {
                    hashMap.put(field.getName(), LOOKUP.unreflectSetter(field));
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
            return hashMap;
        }

        public void inject(Object object, Map<String, Object> map) {
            for (Map.Entry<String, MethodHandle> entry : this.injectables.entrySet()) {
                Object object2 = map.get(entry.getKey());
                if (object2 == null) continue;
                try {
                    entry.getValue().invoke(object, object2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private static class PageContext {
        private MenuContext ctx;
        private InventoryMenuPage page;
        private InventoryMenuPattern[] patterns;
        private InventoryMenuTransition[] transitions;

        private PageContext() {
        }

        static /* synthetic */ InventoryMenuPattern[] access$402(PageContext pageContext, InventoryMenuPattern[] inventoryMenuPatternArray) {
            pageContext.patterns = inventoryMenuPatternArray;
            return inventoryMenuPatternArray;
        }

        static /* synthetic */ InventoryMenuTransition[] access$202(PageContext pageContext, InventoryMenuTransition[] inventoryMenuTransitionArray) {
            pageContext.transitions = inventoryMenuTransitionArray;
            return inventoryMenuTransitionArray;
        }
    }

    private static class Bindable<T> {
        MethodHandle bind;
        T data;

        public Bindable(MethodHandle methodHandle, T t) {
            this.bind = methodHandle;
            this.data = t;
        }

        public void bind(Object object, Object object2) {
            if (this.bind == null) {
                return;
            }
            try {
                this.bind.invoke(object, object2);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private static class Invokable<T> {
        private final T data;
        private final MethodHandle method;

        public Invokable(T t, MethodHandle methodHandle) {
            this.data = t;
            this.method = methodHandle;
        }
    }
}

