/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.gui;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.citizensnpcs.api.gui.CitizensInventoryClickEvent;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.gui.MenuSlot;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryMenuSlot {
    private Set<InventoryAction> actionFilter;
    private final List<Consumer<CitizensInventoryClickEvent>> handlers = Lists.newArrayList();
    private final int index;
    private final Inventory inventory;
    private static Pattern NEWLINE_MATCHER = Pattern.compile("\n|\\n|<br>");

    InventoryMenuSlot(MenuContext menuContext, int n) {
        this.inventory = menuContext.getInventory();
        this.index = n;
    }

    public void addClickHandler(Consumer<CitizensInventoryClickEvent> consumer) {
        this.handlers.add(consumer);
    }

    public void clear() {
        this.handlers.clear();
        this.actionFilter = null;
        this.setItemStack(null);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        InventoryMenuSlot inventoryMenuSlot = (InventoryMenuSlot)object;
        return this.index == inventoryMenuSlot.index && Objects.equals(this.inventory, inventoryMenuSlot.inventory);
    }

    public List<Consumer<CitizensInventoryClickEvent>> getClickHandlers() {
        return this.handlers;
    }

    public ItemStack getCurrentItem() {
        return this.inventory.getItem(this.index);
    }

    public Collection<InventoryAction> getFilter() {
        return this.actionFilter;
    }

    public int hashCode() {
        int n = 31 + this.index;
        return 31 * n + (this.inventory == null ? 0 : this.inventory.hashCode());
    }

    void initialise(MenuSlot menuSlot) {
        ItemMeta itemMeta;
        ItemStack itemStack = null;
        if (menuSlot.compatMaterial().length > 1) {
            String string;
            itemMeta = null;
            String[] stringArray = menuSlot.compatMaterial();
            int n = stringArray.length;
            for (int i = 0; i < n && (itemMeta = Material.getMaterial((String)(string = stringArray[i]))) == null; ++i) {
            }
            itemStack = new ItemStack((Material)itemMeta, menuSlot.amount());
        } else if (menuSlot.material() != null) {
            itemStack = new ItemStack(menuSlot.material(), menuSlot.amount());
        }
        if (itemStack != null && (itemMeta = itemStack.getItemMeta()) != null) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            if (!menuSlot.lore().equals("EMPTY")) {
                itemMeta.setLore(Arrays.asList(Messaging.parseComponents(Messaging.tryTranslate(menuSlot.lore())).split("\\n|\n|<br>")));
            }
            if (!menuSlot.title().equals("EMPTY")) {
                itemMeta.setDisplayName(Messaging.parseComponents(Messaging.tryTranslate(menuSlot.title())));
            }
            itemStack.setItemMeta(itemMeta);
        }
        this.inventory.setItem(this.index, itemStack);
    }

    void onClick(CitizensInventoryClickEvent citizensInventoryClickEvent) {
        if (this.actionFilter == null && this.handlers.isEmpty() || this.actionFilter != null && !this.actionFilter.contains(citizensInventoryClickEvent.getAction())) {
            citizensInventoryClickEvent.setCancelled(true);
            citizensInventoryClickEvent.setResult(Event.Result.DENY);
        }
        for (Consumer consumer : Lists.newArrayList(this.handlers)) {
            consumer.accept(citizensInventoryClickEvent);
        }
    }

    public void setClickHandler(Consumer<CitizensInventoryClickEvent> consumer) {
        this.handlers.clear();
        this.handlers.add(consumer);
    }

    public void setDescription(String string) {
        ItemStack itemStack = this.inventory.getItem(this.index);
        ItemMeta itemMeta = itemStack.getItemMeta();
        List<String> list = Arrays.asList(Messaging.parseComponents(string).split("\\n|\n|<br>"));
        itemMeta.setDisplayName(ChatColor.RESET + list.get(0));
        itemMeta.setLore(list.subList(1, list.size()));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        itemStack.setItemMeta(itemMeta);
        this.inventory.setItem(this.index, itemStack);
    }

    public void setFilter(Collection<InventoryAction> collection) {
        this.actionFilter = collection == null || collection.isEmpty() ? EnumSet.allOf(InventoryAction.class) : EnumSet.copyOf(collection);
    }

    public void setItemStack(ItemStack itemStack) {
        this.inventory.setItem(this.index, itemStack);
    }

    public void setItemStack(ItemStack itemStack, String string) {
        this.setItemStack(itemStack, string, null);
    }

    public void setItemStack(ItemStack itemStack, String string, String string2) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(ChatColor.RESET + Messaging.parseComponents(string));
        if (string2 != null) {
            itemMeta.setLore(Arrays.asList(NEWLINE_MATCHER.split(Messaging.parseComponents(string2))));
        }
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        itemStack.setItemMeta(itemMeta);
        this.inventory.setItem(this.index, itemStack);
    }
}

