/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.hpastar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Consumer;
import net.citizensnpcs.api.hpastar.AStarSolution;
import net.citizensnpcs.api.hpastar.ClusterNode;
import net.citizensnpcs.api.hpastar.Direction;
import net.citizensnpcs.api.hpastar.HPAEntrance;
import net.citizensnpcs.api.hpastar.HPAGraph;
import net.citizensnpcs.api.hpastar.HPAGraphEdge;
import net.citizensnpcs.api.hpastar.HPAGraphNode;

public class HPACluster {
    private final int clusterSize;
    final int clusterX;
    final int clusterY;
    final int clusterZ;
    private final HPAGraph graph;
    private final int level;
    private final List<HPAGraphNode> nodes = new ArrayList<HPAGraphNode>();

    public HPACluster(HPAGraph hPAGraph, int n, int n2, int n3, int n4, int n5) {
        this.graph = hPAGraph;
        this.level = n;
        this.clusterSize = n2;
        this.clusterX = n3;
        this.clusterY = n4;
        this.clusterZ = n5;
    }

    private HPAGraphNode[] addEntranceNode(HPAEntrance hPAEntrance) {
        assert (hPAEntrance.minX == hPAEntrance.maxX || hPAEntrance.minZ == hPAEntrance.maxZ);
        if (hPAEntrance.maxX - hPAEntrance.minX > 6) {
            return new HPAGraphNode[]{this.getOrAddNode(hPAEntrance.minX, hPAEntrance.minZ), this.getOrAddNode(hPAEntrance.maxX, hPAEntrance.minZ)};
        }
        if (hPAEntrance.maxZ - hPAEntrance.minZ > 6) {
            return new HPAGraphNode[]{this.getOrAddNode(hPAEntrance.minX, hPAEntrance.minZ), this.getOrAddNode(hPAEntrance.minX, hPAEntrance.maxZ)};
        }
        int n = (int)(hPAEntrance.minX == hPAEntrance.maxX ? (double)hPAEntrance.minX : Math.floor((double)(hPAEntrance.minX + hPAEntrance.maxX) / 2.0));
        int n2 = (int)(hPAEntrance.minZ == hPAEntrance.maxZ ? (double)hPAEntrance.minZ : Math.floor((double)(hPAEntrance.minZ + hPAEntrance.maxZ) / 2.0));
        return new HPAGraphNode[]{this.getOrAddNode(n, n2)};
    }

    public void buildFrom(List<HPACluster> list) {
        for (HPACluster object : list) {
            for (HPAGraphNode hPAGraphNode2 : object.nodes) {
                if (hPAGraphNode2.x != this.clusterX && hPAGraphNode2.z != this.clusterZ && hPAGraphNode2.x != this.clusterX + this.clusterSize - 1 && hPAGraphNode2.z != this.clusterZ + this.clusterSize - 1) continue;
                this.nodes.add(hPAGraphNode2);
                for (HPAGraphEdge hPAGraphEdge : hPAGraphNode2.getEdges(this.level - 1)) {
                    if (hPAGraphEdge.type != HPAGraphEdge.EdgeType.INTER) continue;
                    hPAGraphEdge.from.connect(this.level, hPAGraphEdge.to, hPAGraphEdge.type, hPAGraphEdge.weight);
                }
            }
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            HPAGraphNode hPAGraphNode = this.nodes.get(i);
            for (int j = i + 1; j < this.nodes.size(); ++j) {
                HPAGraphNode hPAGraphNode2;
                hPAGraphNode2 = this.nodes.get(j);
                float f = this.graph.pathfind((HPAGraphNode)hPAGraphNode, (HPAGraphNode)hPAGraphNode2, (int)(this.level - 1)).cost;
                if (!Float.isFinite(f)) continue;
                hPAGraphNode.connect(this.level, hPAGraphNode2, HPAGraphEdge.EdgeType.INTRA, f);
            }
        }
    }

    public void connect(HPACluster hPACluster, Direction direction) {
        HPAEntrance hPAEntrance2 = null;
        switch (direction) {
            case EAST: {
                for (int i = 0; i < this.clusterSize; ++i) {
                    if (this.offsetWalkable(this.clusterSize - 1, i) && hPACluster.offsetWalkable(0, i)) {
                        if (hPAEntrance2 == null) {
                            hPAEntrance2 = new HPAEntrance();
                            hPAEntrance2.minX = hPAEntrance2.maxX = this.clusterSize - 1;
                            hPAEntrance2.minZ = i;
                        }
                        hPAEntrance2.maxZ = i;
                        continue;
                    }
                    if (hPAEntrance2 == null) continue;
                    this.connectEntrance(hPACluster, hPAEntrance2, hPAEntrance -> {
                        hPAEntrance.maxX = 0;
                        hPAEntrance.minX = 0;
                    });
                    hPAEntrance2 = null;
                }
                if (hPAEntrance2 == null) break;
                this.connectEntrance(hPACluster, hPAEntrance2, hPAEntrance -> {
                    hPAEntrance.maxX = 0;
                    hPAEntrance.minX = 0;
                });
                break;
            }
            case WEST: {
                for (int i = 0; i < this.clusterSize; ++i) {
                    if (this.offsetWalkable(0, i) && hPACluster.offsetWalkable(this.clusterSize - 1, i)) {
                        if (hPAEntrance2 == null) {
                            hPAEntrance2 = new HPAEntrance();
                            hPAEntrance2.maxX = 0;
                            hPAEntrance2.minX = 0;
                            hPAEntrance2.minZ = i;
                        }
                        hPAEntrance2.maxZ = i;
                        continue;
                    }
                    if (hPAEntrance2 == null) continue;
                    this.connectEntrance(hPACluster, hPAEntrance2, hPAEntrance -> {
                        hPAEntrance.minX = hPAEntrance.maxX = this.clusterSize - 1;
                    });
                    hPAEntrance2 = null;
                }
                if (hPAEntrance2 == null) break;
                this.connectEntrance(hPACluster, hPAEntrance2, hPAEntrance -> {
                    hPAEntrance.minX = hPAEntrance.maxX = this.clusterSize - 1;
                });
                break;
            }
            case NORTH: {
                for (int i = 0; i < this.clusterSize; ++i) {
                    if (this.offsetWalkable(i, this.clusterSize - 1) && hPACluster.offsetWalkable(i, 0)) {
                        if (hPAEntrance2 == null) {
                            hPAEntrance2 = new HPAEntrance();
                            hPAEntrance2.minZ = hPAEntrance2.maxZ = this.clusterSize - 1;
                            hPAEntrance2.minX = i;
                        }
                        hPAEntrance2.maxX = i;
                        continue;
                    }
                    if (hPAEntrance2 == null) continue;
                    this.connectEntrance(hPACluster, hPAEntrance2, hPAEntrance -> {
                        hPAEntrance.maxZ = 0;
                        hPAEntrance.minZ = 0;
                    });
                    hPAEntrance2 = null;
                }
                if (hPAEntrance2 == null) break;
                this.connectEntrance(hPACluster, hPAEntrance2, hPAEntrance -> {
                    hPAEntrance.maxZ = 0;
                    hPAEntrance.minZ = 0;
                });
                break;
            }
            case SOUTH: {
                for (int i = 0; i < this.clusterSize; ++i) {
                    if (this.offsetWalkable(i, 0) && hPACluster.offsetWalkable(i, this.clusterSize - 1)) {
                        if (hPAEntrance2 == null) {
                            hPAEntrance2 = new HPAEntrance();
                            hPAEntrance2.maxZ = 0;
                            hPAEntrance2.minZ = 0;
                            hPAEntrance2.minX = i;
                        }
                        hPAEntrance2.maxX = i;
                        continue;
                    }
                    if (hPAEntrance2 == null) continue;
                    this.connectEntrance(hPACluster, hPAEntrance2, hPAEntrance -> {
                        hPAEntrance.minZ = hPAEntrance.maxZ = this.clusterSize - 1;
                    });
                    hPAEntrance2 = null;
                }
                if (hPAEntrance2 == null) break;
                this.connectEntrance(hPACluster, hPAEntrance2, hPAEntrance -> {
                    hPAEntrance.minZ = hPAEntrance.maxZ = this.clusterSize - 1;
                });
            }
        }
    }

    private void connectEntrance(HPACluster hPACluster, HPAEntrance hPAEntrance, Consumer<HPAEntrance> consumer) {
        HPAGraphNode[] hPAGraphNodeArray = this.addEntranceNode(hPAEntrance);
        consumer.accept(hPAEntrance);
        HPAGraphNode[] hPAGraphNodeArray2 = hPACluster.addEntranceNode(hPAEntrance);
        for (int i = 0; i < hPAGraphNodeArray.length; ++i) {
            hPAGraphNodeArray[i].connect(this.level, hPAGraphNodeArray2[i], HPAGraphEdge.EdgeType.INTER, 1.0f);
        }
    }

    public void connectIntra() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            HPAGraphNode hPAGraphNode = this.nodes.get(i);
            for (int j = i + 1; j < this.nodes.size(); ++j) {
                HPAGraphNode hPAGraphNode2 = this.nodes.get(j);
                float f = this.pathfind((HPAGraphNode)hPAGraphNode, (HPAGraphNode)hPAGraphNode2, (boolean)false).cost;
                hPAGraphNode.connect(this.level, hPAGraphNode2, HPAGraphEdge.EdgeType.INTRA, f);
            }
        }
    }

    public boolean contains(HPACluster hPACluster) {
        return this.clusterY == hPACluster.clusterY && this.clusterX + this.clusterSize > hPACluster.clusterX && this.clusterZ + this.clusterSize > hPACluster.clusterZ && hPACluster.clusterZ >= this.clusterZ && hPACluster.clusterX >= this.clusterX;
    }

    private HPAGraphNode getOrAddNode(int n, int n2) {
        for (HPAGraphNode hPAGraphNode : this.nodes) {
            if (hPAGraphNode.x != this.clusterX + n || hPAGraphNode.z != this.clusterZ + n2) continue;
            return hPAGraphNode;
        }
        HPAGraphNode hPAGraphNode = new HPAGraphNode(this.clusterX + n, this.clusterY, this.clusterZ + n2);
        this.nodes.add(hPAGraphNode);
        return hPAGraphNode;
    }

    public boolean hasWalkableNodes() {
        for (int i = 0; i < this.clusterSize; ++i) {
            for (int j = 0; j < this.clusterSize; ++j) {
                if (!this.offsetWalkable(i, j)) continue;
                return true;
            }
        }
        return false;
    }

    public void insert(HPAGraphNode hPAGraphNode) {
        this.nodes.add(hPAGraphNode);
        for (HPAGraphNode hPAGraphNode2 : this.nodes) {
            float f;
            if (hPAGraphNode2 == hPAGraphNode || !Float.isFinite(f = this.pathfind((HPAGraphNode)hPAGraphNode, (HPAGraphNode)hPAGraphNode2, (boolean)false).cost)) continue;
            hPAGraphNode.connect(this.level, hPAGraphNode2, HPAGraphEdge.EdgeType.INTRA, f);
        }
    }

    private boolean offsetWalkable(int n, int n2) {
        return this.graph.walkable(this.clusterX + n, this.clusterY, this.clusterZ + n2);
    }

    private AStarSolution pathfind(HPAGraphNode hPAGraphNode, HPAGraphNode hPAGraphNode2, boolean bl) {
        ClusterNode clusterNode = new ClusterNode(hPAGraphNode.x, hPAGraphNode.z);
        if (hPAGraphNode.x == hPAGraphNode2.x && hPAGraphNode.y == hPAGraphNode2.y && hPAGraphNode.z == hPAGraphNode2.y) {
            return new AStarSolution(bl ? null : clusterNode.reconstructSolution(), 0.0f);
        }
        HashMap<ClusterNode, Float> hashMap = new HashMap<ClusterNode, Float>();
        HashMap<ClusterNode, Float> hashMap2 = new HashMap<ClusterNode, Float>();
        PriorityQueue<ClusterNode> priorityQueue = new PriorityQueue<ClusterNode>();
        priorityQueue.add(clusterNode);
        hashMap.put(clusterNode, Float.valueOf(clusterNode.g));
        while (!priorityQueue.isEmpty()) {
            ClusterNode clusterNode2 = (ClusterNode)priorityQueue.poll();
            if (clusterNode2.x == hPAGraphNode2.x && clusterNode2.z == hPAGraphNode2.z) {
                return new AStarSolution(bl ? null : clusterNode2.reconstructSolution(), clusterNode2.g);
            }
            hashMap2.put(clusterNode2, Float.valueOf(clusterNode2.g));
            hashMap.remove(clusterNode2);
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    ClusterNode clusterNode3;
                    if (i == 0 && j == 0 || clusterNode2.x + i < 0 || clusterNode2.z + j < 0 || clusterNode2.x + i >= 16 || clusterNode2.z + j >= 16 || !this.offsetWalkable(i, j) || hashMap2.containsKey(clusterNode3 = new ClusterNode(clusterNode2.x + i, clusterNode2.z + j))) continue;
                    clusterNode3.parent = clusterNode2;
                    clusterNode3.g = (float)((double)clusterNode2.g + Math.sqrt(Math.pow(clusterNode2.x - clusterNode3.x, 2.0) + Math.pow(clusterNode2.z - clusterNode3.z, 2.0)));
                    clusterNode3.h = (float)Math.sqrt(Math.pow(clusterNode3.x - hPAGraphNode2.x, 2.0) + Math.pow(clusterNode3.z - hPAGraphNode2.z, 2.0));
                    if (hashMap.containsKey(clusterNode3) && clusterNode3.g > ((Float)hashMap.get(clusterNode3)).floatValue()) continue;
                    hashMap.put(clusterNode3, Float.valueOf(clusterNode3.g));
                    priorityQueue.add(clusterNode3);
                }
            }
        }
        return new AStarSolution(null, Float.POSITIVE_INFINITY);
    }

    public void remove(HPAGraphNode ... hPAGraphNodeArray) {
        for (HPAGraphNode hPAGraphNode : hPAGraphNodeArray) {
            List<List<HPAGraphEdge>> list = hPAGraphNode.edges;
            for (int i = 0; i < list.size(); ++i) {
                List<HPAGraphEdge> list2 = list.get(i);
                for (HPAGraphEdge hPAGraphEdge : list2) {
                    hPAGraphEdge.to.edges.get(i).remove(hPAGraphEdge);
                }
            }
            this.nodes.remove(hPAGraphNode);
        }
    }

    public String toString() {
        return "C[" + this.level + "] (" + this.clusterX + "," + this.clusterY + "," + this.clusterZ + ")->(" + (this.clusterX + this.clusterSize - 1) + "," + this.clusterY + "," + (this.clusterZ + this.clusterSize - 1) + ")";
    }
}

