/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.hpastar;

import ch.ethz.globis.phtree.PhTreeSolid;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.hpastar.AStarSolution;
import net.citizensnpcs.api.hpastar.Direction;
import net.citizensnpcs.api.hpastar.HPACluster;
import net.citizensnpcs.api.hpastar.HPAGraphAStarNode;
import net.citizensnpcs.api.hpastar.HPAGraphEdge;
import net.citizensnpcs.api.hpastar.HPAGraphNode;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.Location;

public class HPAGraph {
    private final BlockSource blockSource;
    public List<List<HPACluster>> clusters = Lists.newArrayList();
    private final int cx;
    private final int cy;
    private final int cz;
    private final List<PhTreeSolid<HPACluster>> phtrees = Lists.newArrayList();
    private static int BASE_CLUSTER_SIZE = (int)(2.0 * Math.pow(2.0, 3.0));
    private static int MAX_CLUSTER_SIZE = (int)(2.0 * Math.pow(2.0, 5.0));
    private static int MAX_DEPTH = 3;

    public HPAGraph(BlockSource blockSource, int n, int n2, int n3) {
        this.blockSource = blockSource;
        this.cx = n;
        this.cy = n2;
        this.cz = n3;
        while (this.clusters.size() <= MAX_DEPTH) {
            this.clusters.add(new ArrayList());
            if (this.clusters.size() == this.phtrees.size()) continue;
            this.phtrees.add((PhTreeSolid<HPACluster>)PhTreeSolid.create((int)3));
        }
    }

    public void addClusters(int n, int n2) {
        HPACluster hPACluster;
        int n3 = MAX_CLUSTER_SIZE * ((n - this.cx) / MAX_CLUSTER_SIZE) + this.cx;
        int n4 = MAX_CLUSTER_SIZE * ((n2 - this.cz) / MAX_CLUSTER_SIZE) + this.cz;
        Messaging.log(n3, n4);
        ArrayList<HPACluster> arrayList = new ArrayList<HPACluster>();
        if (this.phtrees.size() == 0) {
            this.phtrees.add((PhTreeSolid<HPACluster>)PhTreeSolid.create((int)3));
        }
        PhTreeSolid<HPACluster> phTreeSolid = this.phtrees.get(0);
        int n5 = BASE_CLUSTER_SIZE;
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < MAX_CLUSTER_SIZE; j += n5) {
                for (int k = 0; k < MAX_CLUSTER_SIZE; k += n5) {
                    hPACluster = new HPACluster(this, 0, n5, n3 + j, i, n4 + k);
                    if (!hPACluster.hasWalkableNodes()) continue;
                    arrayList.add(hPACluster);
                    phTreeSolid.put(new long[]{hPACluster.clusterX, hPACluster.clusterY, hPACluster.clusterZ}, new long[]{hPACluster.clusterX + n5, hPACluster.clusterY, hPACluster.clusterZ + n5}, (Object)hPACluster);
                    Messaging.log(hPACluster);
                }
            }
        }
        HashMultimap hashMultimap = HashMultimap.create();
        for (HPACluster hPACluster2 : arrayList) {
            hPACluster = phTreeSolid.queryIntersect(new long[]{hPACluster2.clusterX - n5, hPACluster2.clusterY - 1, hPACluster2.clusterZ - n5}, new long[]{hPACluster2.clusterX + n5, hPACluster2.clusterY + 1, hPACluster2.clusterZ + n5});
            while (hPACluster.hasNext()) {
                HPACluster hPACluster3 = (HPACluster)hPACluster.nextValue();
                if (hPACluster3 == hPACluster2 || hashMultimap.get((Object)hPACluster2).contains(hPACluster3) || hPACluster3.clusterX - hPACluster2.clusterX != 0 && hPACluster3.clusterZ - hPACluster2.clusterZ != 0) continue;
                int n6 = hPACluster3.clusterX - hPACluster2.clusterX;
                int n7 = hPACluster3.clusterZ - hPACluster2.clusterZ;
                Direction direction = null;
                if (n6 > 0) {
                    direction = Direction.EAST;
                } else if (n6 < 0) {
                    direction = Direction.WEST;
                } else if (n7 > 0) {
                    direction = Direction.NORTH;
                } else if (n7 < 0) {
                    direction = Direction.SOUTH;
                }
                if (direction == null) continue;
                hPACluster2.connect(hPACluster3, direction);
                hashMultimap.get((Object)hPACluster2).add(hPACluster3);
                hashMultimap.get((Object)hPACluster3).add(hPACluster2);
                Messaging.log("CONNECTED", hPACluster2, hPACluster3);
            }
        }
        for (HPACluster hPACluster4 : arrayList) {
            hPACluster4.connectIntra();
        }
        this.addClustersAtDepth(0, arrayList);
        for (int i = 1; i <= MAX_DEPTH; ++i) {
            arrayList = new ArrayList();
            n5 = (int)((double)BASE_CLUSTER_SIZE * Math.pow(2.0, i));
            for (int j = 0; j < 128; ++j) {
                for (int k = 0; k < MAX_CLUSTER_SIZE; k += n5) {
                    for (int i2 = 0; i2 < MAX_CLUSTER_SIZE; i2 += n5) {
                        HPACluster hPACluster5 = new HPACluster(this, i, n5, n3 + k, j, n4 + i2);
                        ArrayList arrayList2 = Lists.newArrayList((Iterator)this.phtrees.get(i - 1).queryInclude(new long[]{hPACluster5.clusterX, hPACluster5.clusterY, hPACluster5.clusterZ}, new long[]{hPACluster5.clusterX + n5, hPACluster5.clusterY, hPACluster5.clusterZ + n5}));
                        if (arrayList2.size() == 0) continue;
                        hPACluster5.buildFrom(arrayList2);
                        this.phtrees.get(i).put(new long[]{hPACluster5.clusterX, hPACluster5.clusterY, hPACluster5.clusterZ}, new long[]{hPACluster5.clusterX + n5, hPACluster5.clusterY, hPACluster5.clusterZ + n5}, (Object)hPACluster5);
                        Messaging.log(hPACluster5);
                        arrayList.add(hPACluster5);
                    }
                }
            }
            this.addClustersAtDepth(i, arrayList);
        }
    }

    public void addClustersAtDepth(int n, List<HPACluster> list) {
        this.clusters.get(n).addAll(list);
    }

    public Plan findPath(Location location, Location location2) {
        ArrayList<HPACluster> arrayList = new ArrayList<HPACluster>();
        HPAGraphNode hPAGraphNode = new HPAGraphNode(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        HPAGraphNode hPAGraphNode2 = new HPAGraphNode(location2.getBlockX(), location2.getBlockY(), location2.getBlockZ());
        int n = 0;
        for (PhTreeSolid<HPACluster> object : this.phtrees) {
            HPACluster hPACluster = object.queryIntersect(new long[]{location.getBlockX(), location.getBlockY(), location.getBlockZ()}, new long[]{location.getBlockX(), location.getBlockY(), location.getBlockZ()});
            HPACluster hPACluster2 = hPACluster.hasNext() ? (HPACluster)hPACluster.next() : null;
            hPACluster = object.queryIntersect(new long[]{location2.getBlockX(), location2.getBlockY(), location2.getBlockZ()}, new long[]{location2.getBlockX(), location2.getBlockY(), location2.getBlockZ()});
            HPACluster hPACluster3 = hPACluster.hasNext() ? (HPACluster)hPACluster.next() : null;
            Messaging.log(n, hPACluster2, hPACluster3);
            hPACluster2.insert(hPAGraphNode);
            hPACluster3.insert(hPAGraphNode2);
            arrayList.add(hPACluster2);
            arrayList.add(hPACluster3);
        }
        AStarSolution aStarSolution = this.pathfind(hPAGraphNode, hPAGraphNode2, 0);
        System.out.println(":" + location + "->" + location2 + "@" + aStarSolution.cost);
        for (HPACluster hPACluster : arrayList) {
            hPACluster.remove(hPAGraphNode, hPAGraphNode2);
        }
        return new Path(aStarSolution.convertToVectors());
    }

    AStarSolution pathfind(HPAGraphNode hPAGraphNode, HPAGraphNode hPAGraphNode2, int n) {
        HashMap<HPAGraphAStarNode, Float> hashMap = new HashMap<HPAGraphAStarNode, Float>();
        HashMap<HPAGraphAStarNode, Float> hashMap2 = new HashMap<HPAGraphAStarNode, Float>();
        PriorityQueue<HPAGraphAStarNode> priorityQueue = new PriorityQueue<HPAGraphAStarNode>();
        HPAGraphAStarNode hPAGraphAStarNode = new HPAGraphAStarNode(hPAGraphNode, null);
        priorityQueue.add(hPAGraphAStarNode);
        hashMap.put(hPAGraphAStarNode, Float.valueOf(hPAGraphAStarNode.g));
        while (!priorityQueue.isEmpty()) {
            HPAGraphAStarNode hPAGraphAStarNode2 = (HPAGraphAStarNode)priorityQueue.poll();
            List<HPAGraphEdge> list = hPAGraphAStarNode2.node.getEdges(n);
            for (HPAGraphEdge hPAGraphEdge : list) {
                if (!hPAGraphEdge.to.equals(hPAGraphNode2)) continue;
                return new AStarSolution(hPAGraphAStarNode2.reconstructSolution(), hPAGraphAStarNode2.g);
            }
            if (hPAGraphNode != hPAGraphAStarNode2.node) {
                hashMap2.put(hPAGraphAStarNode2, Float.valueOf(hPAGraphAStarNode2.g));
            }
            hashMap.remove(hPAGraphAStarNode2);
            for (HPAGraphEdge hPAGraphEdge : list) {
                HPAGraphAStarNode hPAGraphAStarNode3 = new HPAGraphAStarNode(hPAGraphEdge.to, hPAGraphEdge);
                if (hashMap2.containsKey(hPAGraphAStarNode3)) continue;
                hPAGraphAStarNode3.parent = hPAGraphAStarNode2;
                hPAGraphAStarNode3.g = hPAGraphAStarNode2.g + hPAGraphEdge.weight;
                hPAGraphAStarNode3.h = (float)Math.sqrt(Math.pow(hPAGraphEdge.to.x - hPAGraphNode2.x, 2.0) + Math.pow(hPAGraphEdge.to.z - hPAGraphNode2.z, 2.0));
                if (hashMap.containsKey(hPAGraphAStarNode3)) {
                    if (hPAGraphAStarNode3.g > ((Float)hashMap.get(hPAGraphAStarNode3)).floatValue()) continue;
                    priorityQueue.remove(hPAGraphAStarNode3);
                }
                hashMap.put(hPAGraphAStarNode3, Float.valueOf(hPAGraphAStarNode3.g));
                priorityQueue.add(hPAGraphAStarNode3);
            }
        }
        return new AStarSolution(null, Float.POSITIVE_INFINITY);
    }

    public boolean walkable(int n, int n2, int n3) {
        if (n2 == 0) {
            return false;
        }
        return MinecraftBlockExaminer.canStandOn(this.blockSource.getWorld().getBlockAt(n, n2 - 1, n3));
    }
}

