/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.GoalController;
import net.citizensnpcs.api.ai.SimpleGoalController;
import net.citizensnpcs.api.ai.speech.SpeechController;
import net.citizensnpcs.api.ai.speech.event.NPCSpeechEvent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCAddTraitEvent;
import net.citizensnpcs.api.event.NPCCloneEvent;
import net.citizensnpcs.api.event.NPCRemoveByCommandSenderEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.event.NPCRemoveTraitEvent;
import net.citizensnpcs.api.event.NPCRenameEvent;
import net.citizensnpcs.api.event.NPCTeleportEvent;
import net.citizensnpcs.api.npc.MetadataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.npc.SimpleMetadataStore;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.PlayerFilter;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.ItemStorage;
import net.citizensnpcs.api.util.MemoryDataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.RemoveReason;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractNPC
implements NPC {
    protected Object coloredNameComponentCache;
    protected String coloredNameStringCache;
    private final GoalController goalController = new SimpleGoalController();
    private final int id;
    private Supplier<ItemStack> itemProvider = () -> {
        Material material = Material.STONE;
        int n = this.data().get(NPC.Metadata.ITEM_DATA, this.data().get("falling-block-data", Integer.valueOf(0)));
        if (this.data().has(NPC.Metadata.ITEM_ID)) {
            material = Material.getMaterial((String)((String)this.data().get(NPC.Metadata.ITEM_ID)), (boolean)false);
        }
        if (material == Material.AIR) {
            material = Material.STONE;
            Messaging.severe(this.getId(), "invalid Material: converted to stone");
        }
        return new ItemStack(material, this.data().get(NPC.Metadata.ITEM_AMOUNT, Integer.valueOf(1)).intValue(), (short)n);
    };
    private final MetadataStore metadata = new SimpleMetadataStore();
    private String name;
    private final NPCRegistry registry;
    private final List<String> removedTraits = Lists.newArrayList();
    private final List<Runnable> runnables = Lists.newArrayList();
    private final SpeechController speechController = speechContext -> {
        speechContext.setTalker(this.getEntity());
        NPCSpeechEvent nPCSpeechEvent = new NPCSpeechEvent(speechContext);
        Bukkit.getServer().getPluginManager().callEvent((Event)nPCSpeechEvent);
        if (nPCSpeechEvent.isCancelled()) {
            return;
        }
        CitizensAPI.talk(speechContext);
    };
    protected final Map<Class<? extends Trait>, Trait> traits = Maps.newHashMap();
    private final UUID uuid;

    protected AbstractNPC(UUID uUID, int n, String string, NPCRegistry nPCRegistry) {
        this.uuid = uUID;
        this.id = n;
        this.registry = nPCRegistry;
        this.setNameInternal(string);
        CitizensAPI.getTraitFactory().addDefaultTraits(this);
    }

    @Override
    public void addRunnable(Runnable runnable) {
        this.runnables.add(runnable);
    }

    @Override
    public void addTrait(Class<? extends Trait> clazz) {
        this.addTrait(this.getTraitFor(clazz));
    }

    @Override
    public void addTrait(Trait trait) {
        if (trait == null) {
            Messaging.severe("Cannot register a null trait. Was it registered properly?");
            return;
        }
        if (trait.getNPC() == null) {
            trait.linkToNPC(this);
        }
        Class<?> clazz = trait.getClass();
        Trait trait2 = this.traits.get(clazz);
        Bukkit.getPluginManager().registerEvents((Listener)trait, CitizensAPI.getPlugin());
        this.traits.put(clazz, trait);
        if (this.isSpawned()) {
            trait.onSpawn();
        }
        if (trait.isRunImplemented()) {
            if (trait2 != null) {
                this.runnables.remove(trait2);
            }
            this.runnables.add(trait);
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCAddTraitEvent(this, trait));
    }

    @Override
    public NPC clone() {
        return this.copy();
    }

    @Override
    public NPC copy() {
        NPC nPC = this.registry.createNPC(this.getOrAddTrait(MobType.class).getType(), this.getRawName());
        MemoryDataKey memoryDataKey = new MemoryDataKey();
        this.save(memoryDataKey);
        nPC.load(memoryDataKey);
        for (Trait trait : nPC.getTraits()) {
            trait.onCopy();
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCCloneEvent(this, nPC));
        return nPC;
    }

    @Override
    public MetadataStore data() {
        return this.metadata;
    }

    @Override
    public boolean despawn() {
        return this.despawn(DespawnReason.PLUGIN);
    }

    @Override
    public void destroy() {
        Bukkit.getPluginManager().callEvent((Event)new NPCRemoveEvent(this));
        this.runnables.clear();
        for (Trait trait : this.traits.values()) {
            HandlerList.unregisterAll((Listener)trait);
            trait.onRemove(RemoveReason.DESTROYED);
        }
        this.traits.clear();
        this.goalController.clear();
        this.registry.deregister(this);
    }

    @Override
    public void destroy(CommandSender commandSender) {
        Bukkit.getPluginManager().callEvent((Event)new NPCRemoveByCommandSenderEvent(this, commandSender));
        this.destroy();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AbstractNPC abstractNPC = (AbstractNPC)object;
        return Objects.equals(this.uuid, abstractNPC.uuid);
    }

    @Override
    public GoalController getDefaultGoalController() {
        return this.goalController;
    }

    @Override
    public SpeechController getDefaultSpeechController() {
        return this.speechController;
    }

    protected EntityType getEntityType() {
        return this.isSpawned() ? this.getEntity().getType() : this.getOrAddTrait(MobType.class).getType();
    }

    @Override
    public String getFullName() {
        int n = SpigotUtil.getMaxNameLength(this.getEntityType());
        String string = Placeholders.replaceName(this.coloredNameStringCache != null ? this.coloredNameStringCache : Messaging.parseComponents(this.name), null, this);
        if (Messaging.stripColor(string).length() > n) {
            Messaging.severe("ID", this.id, "created with name length greater than " + n + ", truncating", string, "to", string.substring(0, n));
            string = string.substring(0, n);
        }
        return string;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Supplier<ItemStack> getItemProvider() {
        return this.itemProvider;
    }

    @Override
    public UUID getMinecraftUniqueId() {
        UUID uUID;
        if (this.getEntityType() == EntityType.PLAYER && (uUID = this.getUniqueId()).version() == 4) {
            long l = uUID.getMostSignificantBits();
            l &= 0xFFFFFFFFFFFFBFFFL;
            return new UUID(l |= 0x2000L, uUID.getLeastSignificantBits());
        }
        return this.getUniqueId();
    }

    @Override
    public String getName() {
        return Messaging.stripColor(this.coloredNameStringCache);
    }

    @Override
    public <T extends Trait> T getOrAddTrait(Class<T> clazz) {
        Trait trait = this.traits.get(clazz);
        if (trait == null) {
            trait = this.getTraitFor(clazz);
            this.addTrait(trait);
        }
        return (T)((Trait)clazz.cast(trait));
    }

    @Override
    public NPCRegistry getOwningRegistry() {
        return this.registry;
    }

    @Override
    public String getRawName() {
        return this.name;
    }

    @Override
    public <T extends Trait> T getTrait(Class<T> clazz) {
        return this.getOrAddTrait(clazz);
    }

    protected Trait getTraitFor(Class<? extends Trait> clazz) {
        return CitizensAPI.getTraitFactory().getTrait(clazz);
    }

    @Override
    public <T extends Trait> T getTraitNullable(Class<T> clazz) {
        return (T)((Trait)clazz.cast(this.traits.get(clazz)));
    }

    @Override
    public Iterable<Trait> getTraits() {
        return this.traits.values();
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    public int hashCode() {
        return 31 + this.uuid.hashCode();
    }

    @Override
    public boolean hasTrait(Class<? extends Trait> clazz) {
        return this.traits.containsKey(clazz);
    }

    @Override
    public boolean isFlyable() {
        return this.data().get(NPC.Metadata.FLYABLE, Boolean.valueOf(false));
    }

    @Override
    public boolean isHiddenFrom(Player player) {
        PlayerFilter playerFilter = this.getTraitNullable(PlayerFilter.class);
        return playerFilter != null ? playerFilter.isHidden(player) : false;
    }

    @Override
    public boolean isProtected() {
        return this.data().get(NPC.Metadata.DEFAULT_PROTECTED, Boolean.valueOf(true));
    }

    @Override
    public boolean isPushableByFluids() {
        return this.data().get(NPC.Metadata.FLUID_PUSHABLE, Boolean.valueOf(!this.isProtected()));
    }

    @Override
    public void load(DataKey dataKey) {
        Object object;
        this.setNameInternal(dataKey.getString("name"));
        if (dataKey.keyExists("itemprovider")) {
            object = ItemStorage.loadItemStack(dataKey.getRelative("itemprovider"));
            this.setItemProvider(() -> AbstractNPC.lambda$load$2((ItemStack)object));
        }
        this.metadata.loadFrom(dataKey.getRelative("metadata"));
        object = dataKey.getString("traitnames");
        HashSet hashSet = Sets.newHashSet(dataKey.getRelative("traits").getSubKeys());
        Iterables.addAll((Collection)hashSet, (Iterable)Iterables.transform((Iterable)Splitter.on((char)',').split((CharSequence)object), string -> dataKey.getRelative("traits." + string)));
        DataKey dataKey2 = dataKey.getRelative("traits.location");
        if (dataKey2.keyExists()) {
            this.loadTraitFromKey(dataKey2);
            hashSet.remove(dataKey2);
        }
        for (DataKey dataKey3 : hashSet) {
            this.loadTraitFromKey(dataKey3);
        }
    }

    private void loadTraitFromKey(DataKey dataKey) {
        Trait trait;
        Class<? extends Trait> clazz = CitizensAPI.getTraitFactory().getTraitClass(dataKey.name());
        if (this.hasTrait(clazz)) {
            trait = this.getTraitNullable(clazz);
        } else {
            trait = CitizensAPI.getTraitFactory().getTrait(clazz);
            if (trait == null) {
                Messaging.severeTr("citizens.notifications.trait-load-failed", dataKey.name(), this.getId());
                return;
            }
            this.addTrait(trait);
        }
        try {
            PersistenceLoader.load(trait, dataKey);
            trait.load(dataKey);
        }
        catch (Throwable throwable) {
            if (Messaging.isDebugging()) {
                throwable.printStackTrace();
            }
            Messaging.logTr("citizens.notifications.trait-load-failed", dataKey.name(), this.getId());
        }
    }

    @Override
    public void removeTrait(Class<? extends Trait> clazz) {
        Trait trait = this.traits.remove(clazz);
        if (trait != null) {
            Bukkit.getPluginManager().callEvent((Event)new NPCRemoveTraitEvent(this, trait));
            this.removedTraits.add(trait.getName());
            if (trait.isRunImplemented()) {
                this.runnables.remove(trait);
            }
            HandlerList.unregisterAll((Listener)trait);
            trait.onRemove(RemoveReason.REMOVAL);
        }
    }

    @Override
    public boolean requiresNameHologram() {
        return this.name.length() > 16 && this.getEntityType() == EntityType.PLAYER || this.data().get(NPC.Metadata.ALWAYS_USE_NAME_HOLOGRAM, Boolean.valueOf(false)) != false || this.coloredNameStringCache != null && this.coloredNameStringCache.contains("\u00a7x") || !Placeholders.replaceName(this.name, null, this).equals(this.name);
    }

    @Override
    public void save(DataKey dataKey) {
        Object object;
        if (!this.metadata.get(NPC.Metadata.SHOULD_SAVE, Boolean.valueOf(true)).booleanValue()) {
            return;
        }
        this.metadata.saveTo(dataKey.getRelative("metadata"));
        dataKey.setString("name", this.name);
        dataKey.setString("uuid", this.uuid.toString());
        if (this.data().has(NPC.Metadata.ITEM_ID)) {
            object = this.itemProvider.get();
            ItemStorage.saveItem(dataKey.getRelative("itemprovider"), (ItemStack)object);
        } else {
            dataKey.removeKey("itemprovider");
        }
        object = new StringBuilder();
        for (Trait object2 : this.traits.values()) {
            DataKey dataKey2 = dataKey.getRelative("traits." + object2.getName());
            object2.save(dataKey2);
            try {
                PersistenceLoader.save(object2, dataKey2);
            }
            catch (Throwable throwable) {
                Messaging.log("PersistenceLoader failed for", object2);
                throwable.printStackTrace();
                continue;
            }
            this.removedTraits.remove(object2.getName());
            ((StringBuilder)object).append(object2.getName() + ",");
        }
        if (((StringBuilder)object).length() > 0) {
            dataKey.setString("traitnames", ((StringBuilder)object).substring(0, ((StringBuilder)object).length() - 1));
        } else {
            dataKey.setString("traitnames", "");
        }
        for (String string : this.removedTraits) {
            dataKey.removeKey("traits." + string);
        }
        this.removedTraits.clear();
    }

    @Override
    public void setAlwaysUseNameHologram(boolean bl) {
        this.data().setPersistent(NPC.Metadata.ALWAYS_USE_NAME_HOLOGRAM, (Object)bl);
    }

    @Override
    public void setFlyable(boolean bl) {
        this.data().setPersistent(NPC.Metadata.FLYABLE, (Object)bl);
    }

    @Override
    public void setItemProvider(Supplier<ItemStack> supplier) {
        this.itemProvider = supplier;
        ItemStack itemStack = supplier.get();
        if (itemStack != null) {
            this.data().set(NPC.Metadata.ITEM_ID, (Object)itemStack.getType().name());
            this.data().set(NPC.Metadata.ITEM_DATA, (Object)itemStack.getData().getData());
            this.data().set(NPC.Metadata.ITEM_AMOUNT, (Object)itemStack.getAmount());
        }
    }

    @Override
    public void setName(String string) {
        if (string.equals(this.name)) {
            return;
        }
        NPCRenameEvent nPCRenameEvent = new NPCRenameEvent(this, this.name, string);
        Bukkit.getPluginManager().callEvent((Event)nPCRenameEvent);
        this.setNameInternal(nPCRenameEvent.getNewName());
        if (!this.isSpawned()) {
            return;
        }
        Entity entity = this.getEntity();
        if (entity.getType() == EntityType.PLAYER && !this.requiresNameHologram()) {
            Location location = entity.getLocation();
            this.despawn(DespawnReason.PENDING_RESPAWN);
            this.spawn(location);
        }
    }

    protected void setNameInternal(String string) {
        this.name = string;
        this.coloredNameComponentCache = Messaging.minecraftComponentFromRawMessage(this.name);
        this.coloredNameStringCache = Messaging.parseComponents(this.name);
    }

    @Override
    public void setProtected(boolean bl) {
        this.data().setPersistent(NPC.Metadata.DEFAULT_PROTECTED, (Object)bl);
    }

    @Override
    public void setUseMinecraftAI(boolean bl) {
        this.data().setPersistent(NPC.Metadata.USE_MINECRAFT_AI, (Object)bl);
    }

    private void teleport(Entity entity, Location location, int n, PlayerTeleportEvent.TeleportCause teleportCause) {
        Entity entity2 = entity.getPassenger();
        entity.eject();
        if (!location.getWorld().equals((Object)entity.getWorld())) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> entity.teleport(location, teleportCause), (long)n++);
        } else {
            entity.teleport(location, teleportCause);
        }
        if (entity2 == null) {
            return;
        }
        this.teleport(entity2, location, n++, teleportCause);
        Runnable runnable = () -> entity.setPassenger(entity2);
        if (!location.getWorld().equals((Object)entity.getWorld())) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), runnable, (long)n);
        } else {
            runnable.run();
        }
    }

    @Override
    public void teleport(Location location, PlayerTeleportEvent.TeleportCause teleportCause) {
        if (!this.isSpawned()) {
            return;
        }
        NPCTeleportEvent nPCTeleportEvent = new NPCTeleportEvent(this, location);
        Bukkit.getPluginManager().callEvent((Event)nPCTeleportEvent);
        if (nPCTeleportEvent.isCancelled()) {
            return;
        }
        Entity entity = this.getEntity();
        while (entity.getVehicle() != null) {
            entity = entity.getVehicle();
        }
        location.getBlock().getChunk();
        this.teleport(entity, location, 5, teleportCause);
    }

    protected void unloadEvents() {
        this.runnables.clear();
        for (Trait trait : this.traits.values()) {
            HandlerList.unregisterAll((Listener)trait);
        }
        this.traits.clear();
        this.goalController.clear();
    }

    public void update() {
        for (Runnable runnable : this.runnables) {
            runnable.run();
        }
        if (this.isSpawned()) {
            this.goalController.run();
        }
    }

    @Override
    public boolean useMinecraftAI() {
        return this.data().get(NPC.Metadata.USE_MINECRAFT_AI, Boolean.valueOf(false));
    }

    private static /* synthetic */ ItemStack lambda$load$2(ItemStack itemStack) {
        return itemStack;
    }
}

