/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.persistence;

import clib.net.kyori.adventure.text.Component;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.citizensnpcs.api.persistence.ComponentPersister;
import net.citizensnpcs.api.persistence.DelegatePersistence;
import net.citizensnpcs.api.persistence.EulerAnglePersister;
import net.citizensnpcs.api.persistence.ItemStackPersister;
import net.citizensnpcs.api.persistence.LocationPersister;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.Persistable;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.persistence.PersisterRegistry;
import net.citizensnpcs.api.persistence.QuaternionfPersister;
import net.citizensnpcs.api.persistence.UUIDPersister;
import net.citizensnpcs.api.persistence.VectorPersister;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.joml.Quaternionfc;

public class PersistenceLoader {
    private static final Map<Class<?>, Constructor<?>> constructorCache = new WeakHashMap();
    private static final Map<Class<?>, PersistField[]> fieldCache = new WeakHashMap();
    private static final Map<Class<? extends Persister<?>>, Persister<?>> loadedDelegates = new WeakHashMap();
    private static final Exception loadException = new Exception(){
        private static final long serialVersionUID = -4245839150826112365L;

        public void fillInStackTrace(StackTraceElement[] stackTraceElementArray) {
        }
    };
    private static final Map<Class<?>, Class<? extends Persister<?>>> persistRedirects = new WeakHashMap();
    private static final Map<Class<?>, PersisterRegistry<?>> registries = new WeakHashMap();

    public static <T> PersisterRegistry<T> createRegistry(Class<?> clazz) {
        PersisterRegistry persisterRegistry = new PersisterRegistry();
        registries.put(clazz, persisterRegistry);
        return persisterRegistry;
    }

    private static String createRelativeKey(String string, int n) {
        return PersistenceLoader.createRelativeKey(string, Integer.toString(n));
    }

    private static String createRelativeKey(String string, String string2) {
        if (string2.isEmpty()) {
            return string;
        }
        if (string2.charAt(0) == '.') {
            return string.isEmpty() ? string2.substring(1) : string + string2;
        }
        return string.isEmpty() ? string2 : string + '.' + string2;
    }

    private static void deserialise(PersistField persistField, Object object, Object object2, DataKey dataKey) {
        Object object3;
        Set<Object> set;
        Class clazz = persistField.getType();
        Class<?> clazz2 = persistField.getCollectionType();
        if (!Collection.class.isAssignableFrom(clazz2) && !Map.class.isAssignableFrom(clazz2)) {
            throw loadException;
        }
        if (Collection.class.isAssignableFrom(clazz) && !dataKey.keyExists(persistField.key)) {
            return;
        }
        if (List.class.isAssignableFrom(clazz)) {
            set = !List.class.isAssignableFrom(clazz2) ? Lists.newArrayList() : clazz2.newInstance();
            Object object4 = dataKey.getRaw(persistField.key);
            if (object4 instanceof List && clazz2.isAssignableFrom(object4.getClass())) {
                set = (List)object4;
            } else {
                PersistenceLoader.deserialiseCollection((Collection<Object>)set, dataKey, persistField);
            }
            object3 = set;
        } else if (Set.class.isAssignableFrom(clazz)) {
            set = Set.class.isAssignableFrom(clazz2) ? (Set)clazz2.newInstance() : (persistField.getType().isEnum() ? EnumSet.noneOf(persistField.getType()) : (Set)(object2 != null && Set.class.isAssignableFrom(object2.getClass()) ? object2.getClass().newInstance() : Sets.newHashSet()));
            PersistenceLoader.deserialiseCollection((Collection<Object>)set, dataKey, persistField);
            object3 = set;
        } else if (Map.class.isAssignableFrom(clazz)) {
            if (Map.class.isAssignableFrom(clazz2)) {
                set = (Map)clazz2.newInstance();
            } else {
                boolean bl = object2 != null && Map.class.isAssignableFrom(object2.getClass()) && !object2.getClass().isInterface();
                set = (Map)(bl ? object2 : Maps.newHashMap());
            }
            PersistenceLoader.deserialiseMap((Map<Object, Object>)((Object)set), dataKey, persistField);
            object3 = set;
        } else if (float[].class.isAssignableFrom(clazz)) {
            set = Lists.newArrayList();
            for (DataKey dataKey2 : dataKey.getRelative(persistField.key).getIntegerSubKeys()) {
                set.add(Float.valueOf((float)dataKey2.getDouble("")));
            }
            object3 = new float[set.size()];
            for (int i = 0; i < set.size(); ++i) {
                ((float[])object3)[i] = ((Float)set.get(i)).floatValue();
            }
        } else if (double[].class.isAssignableFrom(clazz)) {
            set = Lists.newArrayList();
            for (DataKey dataKey3 : dataKey.getRelative(persistField.key).getIntegerSubKeys()) {
                set.add(dataKey3.getDouble(""));
            }
            object3 = new double[set.size()];
            for (int i = 0; i < set.size(); ++i) {
                ((double[])object3)[i] = (Double)set.get(i);
            }
        } else if (int[].class.isAssignableFrom(clazz)) {
            set = Lists.newArrayList();
            for (DataKey dataKey4 : dataKey.getRelative(persistField.key).getIntegerSubKeys()) {
                set.add(dataKey4.getInt(""));
            }
            object3 = new int[set.size()];
            for (int i = 0; i < set.size(); ++i) {
                ((int[])object3)[i] = (Integer)set.get(i);
            }
        } else {
            object3 = persistField.key.equals("$key") ? (Integer.TYPE.isAssignableFrom(clazz) ? Integer.valueOf(Integer.parseInt(dataKey.name())) : dataKey.name()) : PersistenceLoader.deserialiseValue(persistField, dataKey.getRelative(persistField.key));
        }
        if (object3 == null && persistField.isRequired()) {
            throw loadException;
        }
        if (clazz.isPrimitive() || Primitives.isWrapperType(clazz)) {
            if (object3 == null) {
                return;
            }
            if (!Primitives.isWrapperType(clazz)) {
                clazz = Primitives.wrap(clazz);
            }
            if ((set = object3.getClass()) == Integer.class && clazz != Integer.class && clazz != Double.class && clazz != Long.class && clazz != Float.class) {
                return;
            }
            if (set == Float.class && clazz != Double.class && clazz != Float.class) {
                return;
            }
            if (set == Double.class && clazz != Double.class) {
                if (clazz == Float.class) {
                    object3 = Float.valueOf(((Double)object3).floatValue());
                } else {
                    return;
                }
            }
            if (set == Byte.class && clazz != Short.class && clazz != Byte.class && clazz != Integer.class && clazz != Double.class && clazz != Long.class && clazz != Float.class) {
                return;
            }
            if (set == Short.class && clazz != Short.class && clazz != Integer.class && clazz != Double.class && clazz != Long.class && clazz != Float.class) {
                return;
            }
            if (set == Character.class && clazz != Character.class && clazz != Short.class && clazz != Integer.class && clazz != Double.class && clazz != Long.class && clazz != Float.class) {
                return;
            }
        } else if (object3 != null && !clazz.isAssignableFrom(object3.getClass())) {
            if (dataKey.getRelative(persistField.key).getSubKeys().iterator().hasNext() && persistField.field.getType() == String.class && persistField.delegate == null) {
                persistField.set(object, dataKey.getRelative(persistField.key).name());
            }
            return;
        }
        persistField.set(object, object3);
    }

    private static void deserialiseCollection(Collection<Object> collection, DataKey dataKey, PersistField persistField) {
        for (DataKey dataKey2 : dataKey.getRelative(persistField.key).getSubKeys()) {
            Object object = PersistenceLoader.deserialiseCollectionValue(persistField, dataKey2, persistField.persistAnnotation.valueType());
            if (object == null) continue;
            collection.add(object);
        }
    }

    private static Object deserialiseCollectionValue(PersistField persistField, DataKey dataKey, Class<?> clazz) {
        Object object = PersistenceLoader.deserialiseValue(persistField, dataKey);
        if (object == null || clazz == Object.class) {
            return object;
        }
        Class clazz2 = object.getClass();
        if (clazz.isPrimitive() || Primitives.isWrapperType(clazz)) {
            if (!Primitives.isWrapperType(clazz2)) {
                clazz2 = Primitives.wrap(clazz2);
            }
            if (clazz != clazz2) {
                if (clazz == Long.class) {
                    return ((Number)object).longValue();
                }
                if (clazz == Byte.class) {
                    return ((Number)object).byteValue();
                }
                if (clazz == Short.class) {
                    return ((Number)object).shortValue();
                }
                if (clazz == Float.class) {
                    return Float.valueOf(((Number)object).floatValue());
                }
                if (clazz == Double.class) {
                    return ((Number)object).doubleValue();
                }
                if (clazz == Integer.class) {
                    return ((Number)object).intValue();
                }
            }
        }
        return object;
    }

    private static void deserialiseMap(Map<Object, Object> map, DataKey dataKey, PersistField persistField) {
        for (DataKey dataKey2 : dataKey.getRelative(persistField.key).getSubKeys()) {
            Object object = PersistenceLoader.deserialiseCollectionValue(persistField, dataKey2, persistField.persistAnnotation.valueType());
            if (object == null) continue;
            Object object2 = dataKey2.name();
            Class<?> clazz = persistField.persistAnnotation.keyType();
            if (clazz != String.class) {
                if (clazz.isPrimitive() || Primitives.isWrapperType(clazz)) {
                    if (clazz == Long.class) {
                        object2 = Long.parseLong(String.valueOf(object2));
                    }
                    if (clazz == Byte.class) {
                        object2 = Byte.parseByte(String.valueOf(object2));
                    }
                    if (clazz == Short.class) {
                        object2 = Short.parseShort(String.valueOf(object2));
                    }
                    if (clazz == Float.class) {
                        object2 = Float.valueOf(Float.parseFloat(String.valueOf(object2)));
                    }
                    if (clazz == Double.class) {
                        object2 = Double.parseDouble(String.valueOf(object2));
                    }
                    if (clazz == Integer.class) {
                        object2 = Integer.parseInt(String.valueOf(object2));
                    }
                } else if (clazz == UUID.class) {
                    object2 = UUID.fromString(String.valueOf(object2));
                } else if (clazz.isEnum()) {
                    object2 = Enum.valueOf(clazz, String.valueOf(object2));
                } else {
                    throw new UnsupportedOperationException();
                }
            }
            map.put(object2, object);
        }
    }

    private static Object deserialiseValue(PersistField persistField, DataKey dataKey) {
        Object object;
        Class<?> clazz;
        Class<?> clazz2 = clazz = persistField.field.getType().isEnum() ? persistField.field.getType() : PersistenceLoader.getGenericType(persistField.field);
        if (persistField.delegate == null && clazz.isEnum()) {
            object = clazz;
            Object object2 = dataKey.getRaw("");
            if (object2 instanceof String) {
                try {
                    return Enum.valueOf(object, object2.toString());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        object = persistField.delegate == null ? dataKey.getRaw("") : persistField.delegate.create(dataKey);
        return object;
    }

    private static void ensureDelegateLoaded(Class<? extends Persister<?>> clazz) {
        if (loadedDelegates.containsKey(clazz)) {
            return;
        }
        try {
            Constructor<Persister<?>> constructor = clazz.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            loadedDelegates.put(clazz, constructor.newInstance(new Object[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            loadedDelegates.put(clazz, null);
        }
    }

    private static Persister<?> getDelegate(Class<?> clazz) {
        if (registries.containsKey(clazz)) {
            return registries.get(clazz);
        }
        if (Component.class.isAssignableFrom(clazz)) {
            return registries.get(Component.class);
        }
        return loadedDelegates.get(persistRedirects.get(clazz));
    }

    private static Persister<?> getDelegate(Field field, Class<?> clazz) {
        DelegatePersistence delegatePersistence = field.getAnnotation(DelegatePersistence.class);
        if (delegatePersistence == null) {
            return PersistenceLoader.getDelegate(clazz);
        }
        Persister<?> persister = loadedDelegates.get(delegatePersistence.value());
        return persister == null ? loadedDelegates.get(persistRedirects.get(clazz)) : persister;
    }

    private static PersistField[] getFields(Class<?> clazz) {
        PersistField[] persistFieldArray = fieldCache.get(clazz);
        if (persistFieldArray == null) {
            persistFieldArray = PersistenceLoader.getFieldsFromClass(clazz);
            fieldCache.put(clazz, persistFieldArray);
        }
        return persistFieldArray;
    }

    private static PersistField[] getFieldsFromClass(Class<?> clazz) {
        ArrayList arrayList = Lists.newArrayList((Object[])clazz.getDeclaredFields());
        for (Class<?> clazz2 = clazz.getSuperclass(); clazz2 != Object.class && clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            arrayList.addAll(Arrays.asList(clazz2.getDeclaredFields()));
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Field field2 = (Field)iterator.next();
            field2.setAccessible(true);
            Persist persist = field2.getAnnotation(Persist.class);
            if (persist == null) {
                iterator.remove();
                continue;
            }
            DelegatePersistence delegatePersistence = field2.getAnnotation(DelegatePersistence.class);
            if (delegatePersistence == null) continue;
            Class<? extends Persister<?>> clazz3 = delegatePersistence.value();
            PersistenceLoader.ensureDelegateLoaded(clazz3);
            Persister<?> persister = loadedDelegates.get(clazz3);
            if (persister != null) continue;
            iterator.remove();
        }
        return Collections2.transform((Collection)arrayList, field -> new PersistField((Field)field)).toArray(new PersistField[arrayList.size()]);
    }

    private static Class<?> getGenericType(Field field) {
        if (field.getGenericType() == null || !(field.getGenericType() instanceof ParameterizedType)) {
            return field.getType();
        }
        Type[] typeArray = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
        return typeArray.length > 0 && typeArray[0] instanceof Class ? (Class)typeArray[0] : field.getType();
    }

    public static <T> T load(Class<? extends T> clazz, DataKey dataKey) {
        T t = null;
        if (persistRedirects.containsKey(clazz)) {
            return (T)PersistenceLoader.getDelegate(clazz).create(dataKey);
        }
        try {
            Constructor<?> constructor = constructorCache.get(clazz);
            if (constructor == null) {
                for (Constructor<?> constructor2 : clazz.getDeclaredConstructors()) {
                    DelegatePersistence delegatePersistence = constructor2.getAnnotation(DelegatePersistence.class);
                    if (delegatePersistence != null) {
                        PersistenceLoader.registerPersistDelegate(clazz, delegatePersistence.value());
                        return (T)PersistenceLoader.getDelegate(clazz).create(dataKey);
                    }
                    if (constructor2.getParameterCount() != 0) continue;
                    constructor2.setAccessible(true);
                    constructor = constructor2;
                    constructorCache.put(clazz, constructor);
                    break;
                }
            }
            t = (T)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            Messaging.severe("Error creating instance for " + clazz + " using " + dataKey);
            exception.printStackTrace();
        }
        if (t == null) {
            return null;
        }
        return PersistenceLoader.load(t, dataKey);
    }

    public static <T> T load(T t, DataKey dataKey) {
        PersistField[] persistFieldArray;
        Class<?> clazz = t.getClass();
        for (PersistField persistField : persistFieldArray = PersistenceLoader.getFields(clazz)) {
            try {
                persistField.populateDefault(t);
                PersistenceLoader.deserialise(persistField, t, persistField.get(t), persistField.getDataKey(dataKey));
            }
            catch (Exception exception) {
                if (exception != loadException) {
                    exception.printStackTrace();
                }
                return null;
            }
        }
        if (t instanceof Persistable) {
            ((Persistable)t).load(dataKey);
        }
        return t;
    }

    public static void registerPersistDelegate(Class<?> clazz, Class<? extends Persister<?>> clazz2) {
        persistRedirects.put(clazz, clazz2);
        PersistenceLoader.ensureDelegateLoaded(clazz2);
    }

    public static void save(Object object, DataKey dataKey) {
        PersistField[] persistFieldArray;
        Class<?> clazz = object.getClass();
        for (PersistField persistField : persistFieldArray = PersistenceLoader.getFields(clazz)) {
            PersistenceLoader.serialise(persistField, persistField.get(object), persistField.getDataKey(dataKey));
        }
        if (object instanceof Persistable) {
            ((Persistable)object).save(dataKey);
        }
    }

    private static void serialise(PersistField persistField, Object object, DataKey dataKey) {
        if (object == null) {
            dataKey.removeKey(persistField.key);
            return;
        }
        if (Collection.class.isAssignableFrom(persistField.getType())) {
            Collection collection = (Collection)object;
            dataKey.removeKey(persistField.key);
            int n = 0;
            for (Object e : collection) {
                String string = PersistenceLoader.createRelativeKey(persistField.key, n);
                PersistenceLoader.serialiseValue(persistField, dataKey.getRelative(string), e);
                ++n;
            }
        } else if (Map.class.isAssignableFrom(persistField.getType())) {
            Map map = (Map)object;
            dataKey.removeKey(persistField.key);
            for (Map.Entry entry : map.entrySet()) {
                String string = PersistenceLoader.createRelativeKey(persistField.key, String.valueOf(entry.getKey()));
                PersistenceLoader.serialiseValue(persistField, dataKey.getRelative(string), entry.getValue());
            }
        } else if (float[].class.isAssignableFrom(persistField.getType())) {
            float[] fArray = (float[])object;
            dataKey.removeKey(persistField.key);
            for (int i = 0; i < fArray.length; ++i) {
                String string = PersistenceLoader.createRelativeKey(persistField.key, i);
                PersistenceLoader.serialiseValue(persistField, dataKey.getRelative(string), Float.valueOf(fArray[i]));
            }
        } else if (double[].class.isAssignableFrom(persistField.getType())) {
            double[] dArray = (double[])object;
            dataKey.removeKey(persistField.key);
            for (int i = 0; i < dArray.length; ++i) {
                String string = PersistenceLoader.createRelativeKey(persistField.key, i);
                PersistenceLoader.serialiseValue(persistField, dataKey.getRelative(string), dArray[i]);
            }
        } else if (int[].class.isAssignableFrom(persistField.getType())) {
            int[] nArray = (int[])object;
            dataKey.removeKey(persistField.key);
            for (int i = 0; i < nArray.length; ++i) {
                String string = PersistenceLoader.createRelativeKey(persistField.key, i);
                PersistenceLoader.serialiseValue(persistField, dataKey.getRelative(string), nArray[i]);
            }
        } else {
            if (persistField.key.equals("$key")) {
                return;
            }
            PersistenceLoader.serialiseValue(persistField, dataKey.getRelative(persistField.key), object);
        }
    }

    private static void serialiseValue(PersistField persistField, DataKey dataKey, Object object) {
        if (persistField.isDefault(object)) {
            dataKey.removeKey("");
            return;
        }
        if (persistField.delegate != null) {
            persistField.delegate.save(object, dataKey);
        } else if (object instanceof Enum) {
            dataKey.setRaw("", ((Enum)object).name());
        } else {
            if (dataKey.getSubKeys().iterator().hasNext() && !(object instanceof Collection)) {
                return;
            }
            dataKey.setRaw("", object);
        }
    }

    static {
        PersistenceLoader.registerPersistDelegate(Quaternionfc.class, QuaternionfPersister.class);
        PersistenceLoader.registerPersistDelegate(Vector.class, VectorPersister.class);
        PersistenceLoader.registerPersistDelegate(Component.class, ComponentPersister.class);
        PersistenceLoader.registerPersistDelegate(Location.class, LocationPersister.class);
        PersistenceLoader.registerPersistDelegate(ItemStack.class, ItemStackPersister.class);
        PersistenceLoader.registerPersistDelegate(EulerAngle.class, EulerAnglePersister.class);
        PersistenceLoader.registerPersistDelegate(UUID.class, UUIDPersister.class);
    }

    private static class PersistField {
        private boolean checkedForDefault;
        private Object defaultValue;
        private final Persister<?> delegate;
        private final Field field;
        private final String key;
        private final Persist persistAnnotation;
        private static final Object NULL = new Object();

        private PersistField(Field field) {
            this.field = field;
            this.persistAnnotation = field.getAnnotation(Persist.class);
            this.key = this.persistAnnotation.value().equals("UNINITIALISED") ? field.getName() : this.persistAnnotation.value();
            Class clazz = field.getType();
            if (field.getGenericType() instanceof ParameterizedType) {
                int n = Map.class.isAssignableFrom(field.getType()) ? 1 : 0;
                clazz = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[n];
            }
            if (this.persistAnnotation.valueType() != Object.class) {
                clazz = this.persistAnnotation.valueType();
            }
            this.delegate = this.persistAnnotation.reify() ? new PersistenceLoaderPersister(clazz) : PersistenceLoader.getDelegate(field, clazz);
        }

        public <T> T get(Object object) {
            try {
                return (T)this.field.get(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return (T)NULL;
            }
        }

        public Class<?> getCollectionType() {
            return this.persistAnnotation.collectionType();
        }

        public DataKey getDataKey(DataKey dataKey) {
            if (!this.persistAnnotation.namespace().isEmpty()) {
                return dataKey.getFromRoot("global." + this.persistAnnotation.namespace());
            }
            return dataKey;
        }

        public Class<?> getType() {
            return this.field.getType();
        }

        public boolean isDefault(Object object) {
            return false;
        }

        public boolean isRequired() {
            return this.persistAnnotation.required();
        }

        public void populateDefault(Object object) {
            if (this.checkedForDefault) {
                return;
            }
            try {
                this.defaultValue = this.field.get(object);
                this.checkedForDefault = true;
                if (!(this.defaultValue == null || this.defaultValue.getClass().isPrimitive() || this.defaultValue instanceof Number || this.defaultValue instanceof Enum || this.defaultValue instanceof Boolean || this.defaultValue instanceof String)) {
                    this.defaultValue = null;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void set(Object object, Object object2) {
            try {
                this.field.set(object, object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static class PersistenceLoaderPersister
    implements Persister<Object> {
        private final Class<?> clazz;

        private PersistenceLoaderPersister(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Object create(DataKey dataKey) {
            return PersistenceLoader.load(this.clazz, dataKey);
        }

        @Override
        public void save(Object object, DataKey dataKey) {
            PersistenceLoader.save(object, dataKey);
        }
    }
}

