/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait;

import java.util.Objects;
import java.util.function.Supplier;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;

public final class TraitInfo {
    private boolean defaultTrait;
    private String name;
    private Supplier<? extends Trait> supplier;
    private boolean trackStats;
    private final Class<? extends Trait> trait;
    private boolean triedAnnotation;

    private TraitInfo(Class<? extends Trait> clazz) {
        this.trait = clazz;
    }

    public TraitInfo asDefaultTrait() {
        this.defaultTrait = true;
        return this;
    }

    public void checkValid() {
        if (this.supplier == null) {
            try {
                this.trait.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException("Trait class must have a no-arguments constructor");
            }
        }
    }

    public Class<? extends Trait> getTraitClass() {
        return this.trait;
    }

    public String getTraitName() {
        if (this.name == null && !this.triedAnnotation) {
            TraitName traitName = this.trait.getAnnotation(TraitName.class);
            if (traitName != null) {
                this.name = traitName.value().toLowerCase();
            }
            this.triedAnnotation = true;
        }
        return this.name;
    }

    public boolean isDefaultTrait() {
        return this.defaultTrait;
    }

    public TraitInfo optInToStats() {
        this.trackStats = true;
        return this;
    }

    public boolean trackStats() {
        return this.trackStats;
    }

    public <T extends Trait> T tryCreateInstance() {
        if (this.supplier != null) {
            return (T)this.supplier.get();
        }
        try {
            return (T)this.trait.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public TraitInfo withName(String string) {
        Objects.requireNonNull(string);
        this.name = string.toLowerCase();
        return this;
    }

    public TraitInfo withSupplier(Supplier<? extends Trait> supplier) {
        this.supplier = supplier;
        return this;
    }

    public static TraitInfo create(Class<? extends Trait> clazz) {
        Objects.requireNonNull(clazz);
        return new TraitInfo(clazz);
    }
}

