/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.ItemStorage;
import org.bukkit.Bukkit;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

@TraitName(value="inventory")
public class Inventory
extends Trait {
    private ItemStack[] contents;
    private boolean registeredListener;
    private org.bukkit.inventory.Inventory view;
    private final Set<InventoryView> viewers = new HashSet<InventoryView>();
    private static boolean SUPPORT_ABSTRACT_HORSE = false;
    private static boolean SUPPORT_GET_STORAGE_CONTENTS = false;

    public Inventory() {
        super("inventory");
        this.contents = new ItemStack[72];
    }

    public ItemStack[] getContents() {
        if (this.view != null && !this.viewers.isEmpty()) {
            return this.view.getContents();
        }
        this.saveContents(this.npc.getEntity());
        return this.contents;
    }

    public org.bukkit.inventory.Inventory getInventoryView() {
        return this.view;
    }

    @Override
    public void load(DataKey dataKey) {
        this.contents = this.parseContents(dataKey);
    }

    @Override
    public void onDespawn() {
        this.saveContents(this.npc.getEntity());
    }

    @Override
    public void onSpawn() {
        this.setContents(this.contents);
        int n = this.npc.getEntity() instanceof Player ? 36 : (this.npc.getEntity() instanceof InventoryHolder ? ((InventoryHolder)this.npc.getEntity()).getInventory().getSize() : this.contents.length);
        int n2 = n % 9;
        if (n2 != 0) {
            n += 9 - n2;
        }
        if (n > 54) {
            n = 54;
        }
        if (n < 9) {
            n = 9;
        }
        String string = this.npc.getName().length() >= 19 ? this.npc.getName().substring(0, 19) + "~" : this.npc.getName();
        this.view = Bukkit.createInventory((InventoryHolder)(this.npc.getEntity() instanceof InventoryHolder ? (InventoryHolder)this.npc.getEntity() : null), (int)n, (String)(string + "'s Inventory"));
        for (int i = 0; i < this.view.getSize(); ++i) {
            this.view.setItem(i, this.contents[i]);
        }
    }

    public void openInventory(Player player) {
        this.saveContents(this.npc.getEntity());
        if (!this.registeredListener) {
            this.registeredListener = true;
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler(ignoreCancelled=true)
                public void inventoryCloseEvent(InventoryCloseEvent inventoryCloseEvent) {
                    int n;
                    if (!Inventory.this.viewers.contains(inventoryCloseEvent.getView())) {
                        return;
                    }
                    ItemStack[] itemStackArray = inventoryCloseEvent.getInventory().getContents();
                    for (n = 0; n < Inventory.this.contents.length; ++n) {
                        if (n >= itemStackArray.length) {
                            ((Inventory)Inventory.this).contents[n] = null;
                            continue;
                        }
                        ((Inventory)Inventory.this).contents[n] = itemStackArray[n];
                        if (n != 0 || !(Inventory.this.npc.getEntity() instanceof LivingEntity)) continue;
                        Inventory.this.npc.getOrAddTrait(Equipment.class).set(Equipment.EquipmentSlot.HAND, itemStackArray[n]);
                    }
                    if (Inventory.this.npc.getEntity() instanceof InventoryHolder) {
                        if (SUPPORT_GET_STORAGE_CONTENTS) {
                            n = ((InventoryHolder)Inventory.this.npc.getEntity()).getInventory().getStorageContents().length;
                            ((InventoryHolder)Inventory.this.npc.getEntity()).getInventory().setStorageContents(Arrays.copyOf(itemStackArray, n));
                        } else {
                            n = ((InventoryHolder)Inventory.this.npc.getEntity()).getInventory().getContents().length;
                            ((InventoryHolder)Inventory.this.npc.getEntity()).getInventory().setContents(Arrays.copyOf(itemStackArray, n));
                        }
                    }
                    Inventory.this.viewers.remove(inventoryCloseEvent.getView());
                }
            }, CitizensAPI.getPlugin());
        }
        for (int i = 0; i < this.view.getSize() && i < this.contents.length; ++i) {
            this.view.setItem(i, this.contents[i]);
        }
        this.viewers.add(player.openInventory(this.view));
    }

    private ItemStack[] parseContents(DataKey dataKey) {
        ItemStack[] itemStackArray = new ItemStack[72];
        for (DataKey dataKey2 : dataKey.getIntegerSubKeys()) {
            itemStackArray[Integer.parseInt((String)dataKey2.name())] = ItemStorage.loadItemStack(dataKey2);
        }
        return itemStackArray;
    }

    @Override
    public void run() {
        if (this.viewers.isEmpty()) {
            return;
        }
        Iterator<InventoryView> iterator = this.viewers.iterator();
        while (iterator.hasNext()) {
            InventoryView inventoryView = iterator.next();
            if (inventoryView.getPlayer().isValid()) continue;
            inventoryView.close();
            iterator.remove();
        }
    }

    @Override
    public void save(DataKey dataKey) {
        if (this.npc.isSpawned()) {
            this.saveContents(this.npc.getEntity());
        }
        int n = 0;
        for (ItemStack itemStack : this.contents) {
            dataKey.removeKey(String.valueOf(n));
            if (itemStack != null) {
                ItemStorage.saveItem(dataKey.getRelative(String.valueOf(n)), itemStack);
            }
            ++n;
        }
    }

    private void saveContents(Entity entity) {
        if (entity == null) {
            return;
        }
        if (this.view != null && !this.viewers.isEmpty()) {
            this.contents = this.view.getContents();
        } else if (entity instanceof InventoryHolder) {
            this.contents = SUPPORT_GET_STORAGE_CONTENTS ? ((InventoryHolder)entity).getInventory().getStorageContents() : ((InventoryHolder)entity).getInventory().getContents();
        }
    }

    public void setContents(ItemStack[] itemStackArray) {
        int n;
        this.contents = Arrays.copyOf(itemStackArray, 72);
        PlayerInventory playerInventory = null;
        int n2 = -1;
        if (this.npc.getEntity() instanceof Player) {
            playerInventory = ((Player)this.npc.getEntity()).getInventory();
            n2 = 36;
        } else if (this.npc.getEntity() instanceof StorageMinecart) {
            playerInventory = ((StorageMinecart)this.npc.getEntity()).getInventory();
        }
        if (SUPPORT_ABSTRACT_HORSE && this.npc.getEntity() instanceof AbstractHorse) {
            playerInventory = ((AbstractHorse)this.npc.getEntity()).getInventory();
        } else if (!SUPPORT_ABSTRACT_HORSE && this.npc.getEntity() instanceof Horse) {
            playerInventory = ((Horse)this.npc.getEntity()).getInventory();
        }
        if (playerInventory == null) {
            return;
        }
        if (n2 == -1) {
            n2 = playerInventory.getSize();
        }
        for (n = 0; n < n2; ++n) {
            if (n >= itemStackArray.length) continue;
            playerInventory.setItem(n, itemStackArray[n]);
        }
        if (this.view == null) {
            return;
        }
        for (n = 0; n < n2; ++n) {
            if (n >= itemStackArray.length || n >= this.view.getSize()) continue;
            this.view.setItem(n, itemStackArray[n]);
        }
    }

    public void setItem(int n, ItemStack itemStack) {
        if (itemStack != null) {
            itemStack = itemStack.clone();
        }
        if (this.view != null && this.view.getSize() > n) {
            this.view.setItem(n, itemStack);
        } else if (this.contents.length > n) {
            this.contents[n] = itemStack;
        } else {
            throw new IndexOutOfBoundsException();
        }
        if (this.npc.getEntity() instanceof InventoryHolder) {
            ((InventoryHolder)this.npc.getEntity()).getInventory().setItem(n, itemStack);
        }
        if (n == 0 && this.npc.getEntity() instanceof LivingEntity) {
            this.npc.getOrAddTrait(Equipment.class).set(Equipment.EquipmentSlot.HAND, itemStack);
        }
    }

    void setItemInHand(ItemStack itemStack) {
        if (itemStack != null) {
            itemStack = itemStack.clone();
        }
        if (this.view != null && this.view.getSize() > 0) {
            this.view.setItem(0, itemStack);
        } else if (this.contents.length > 0) {
            this.contents[0] = itemStack;
        }
    }

    public String toString() {
        return "Inventory{" + Arrays.toString(this.contents) + "}";
    }

    static {
        try {
            SUPPORT_ABSTRACT_HORSE = Class.forName("org.bukkit.entity.AbstractHorse") != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            SUPPORT_GET_STORAGE_CONTENTS = org.bukkit.inventory.Inventory.class.getMethod("getStorageContents", new Class[0]) != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

