/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import net.citizensnpcs.api.util.EntityDim;
import org.bukkit.Location;

public class BoundingBox {
    public final double maxX;
    public final double maxY;
    public final double maxZ;
    public final double minX;
    public final double minY;
    public final double minZ;
    public static final BoundingBox EMPTY = new BoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public BoundingBox(double d, double d2, double d3, double d4, double d5, double d6) {
        this.minX = d;
        this.minY = d2;
        this.minZ = d3;
        this.maxX = d4;
        this.maxY = d5;
        this.maxZ = d6;
    }

    public BoundingBox add(int n, int n2, int n3) {
        return new BoundingBox(this.minX + (double)n, this.minY + (double)n2, this.minZ + (double)n3, this.maxX + (double)n, this.maxY + (double)n2, this.maxZ + (double)n3);
    }

    public BoundingBox add(Location location) {
        return new BoundingBox(this.minX + location.getX(), this.minY + location.getY(), this.minZ + location.getZ(), this.maxX + location.getX(), this.maxY + location.getY(), this.maxZ + location.getZ());
    }

    public BoundingBox clone() {
        return new BoundingBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BoundingBox boundingBox = (BoundingBox)object;
        if (Double.doubleToLongBits(this.maxX) != Double.doubleToLongBits(boundingBox.maxX) || Double.doubleToLongBits(this.maxY) != Double.doubleToLongBits(boundingBox.maxY) || Double.doubleToLongBits(this.maxZ) != Double.doubleToLongBits(boundingBox.maxZ) || Double.doubleToLongBits(this.minX) != Double.doubleToLongBits(boundingBox.minX)) {
            return false;
        }
        return Double.doubleToLongBits(this.minY) == Double.doubleToLongBits(boundingBox.minY) && Double.doubleToLongBits(this.minZ) == Double.doubleToLongBits(boundingBox.minZ);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        long l = Double.doubleToLongBits(this.maxX);
        n2 = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.maxY);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.maxZ);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.minX);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.minY);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.minZ);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        return n2;
    }

    public BoundingBox mul(double d) {
        return new BoundingBox(this.minX * d, this.minY * d, this.minZ * d, this.maxX * d, this.maxY * d, this.maxZ * d);
    }

    public BoundingBox mul(double d, double d2, double d3) {
        return new BoundingBox(this.minX * d, this.minY * d2, this.minZ * d3, this.maxX * d, this.maxY * d2, this.maxZ * d3);
    }

    public org.bukkit.util.BoundingBox toBukkit() {
        return new org.bukkit.util.BoundingBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public EntityDim toDimensions() {
        return new EntityDim(Math.abs(this.maxX - this.minX) * 2.0, Math.abs(this.maxY - this.minY));
    }

    public String toString() {
        return "BoundingBox [" + this.minX + ", " + this.minY + ", " + this.minZ + ", " + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }

    public static BoundingBox convert(org.bukkit.util.BoundingBox boundingBox) {
        return new BoundingBox(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
    }
}

