/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class MemoryDataKey
extends DataKey {
    private String name;
    private final ConfigurationSection root;

    public MemoryDataKey() {
        super("");
        this.root = new MemoryConfiguration();
    }

    private MemoryDataKey(ConfigurationSection configurationSection, String string) {
        super(string);
        this.root = configurationSection;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MemoryDataKey memoryDataKey = (MemoryDataKey)object;
        return Objects.equals(this.path, memoryDataKey.path);
    }

    @Override
    public boolean getBoolean(String string) {
        return this.root.getBoolean(this.getKeyFor(string), false);
    }

    @Override
    public double getDouble(String string) {
        return this.root.getDouble(this.getKeyFor(string), 0.0);
    }

    @Override
    public DataKey getFromRoot(String string) {
        return new MemoryDataKey(this.root, string);
    }

    @Override
    public int getInt(String string) {
        return this.root.getInt(this.getKeyFor(string), 0);
    }

    private String getKeyFor(String string) {
        if (string.isEmpty()) {
            return this.path;
        }
        if (string.charAt(0) == '.') {
            return this.path.isEmpty() ? string.substring(1) : this.path + string;
        }
        return this.path.isEmpty() ? string : this.path + "." + string;
    }

    @Override
    public long getLong(String string) {
        return this.root.getLong(this.getKeyFor(string), 0L);
    }

    @Override
    public Object getRaw(String string) {
        return this.root.get(this.getKeyFor(string));
    }

    @Override
    public MemoryDataKey getRelative(String string) {
        String string2 = this.getKeyFor(string);
        return new MemoryDataKey(this.root, string2);
    }

    @Override
    public String getString(String string) {
        return this.root.getString(this.getKeyFor(string), "");
    }

    @Override
    public Iterable<DataKey> getSubKeys() {
        ConfigurationSection configurationSection = this.root.getConfigurationSection(this.path);
        if (configurationSection == null) {
            return Collections.emptyList();
        }
        Set set = configurationSection.getKeys(false);
        return Iterables.transform((Iterable)set, string -> new MemoryDataKey(this.root, this.getKeyFor((String)string)));
    }

    @Override
    public Map<String, Object> getValuesDeep() {
        return this.sectionToValues(this.root);
    }

    @Override
    public int hashCode() {
        return 31 + (this.path == null ? 0 : this.path.hashCode());
    }

    @Override
    public boolean keyExists(String string) {
        return this.root.isSet(this.getKeyFor(string));
    }

    @Override
    public String name() {
        if (this.name == null) {
            int n = this.path.lastIndexOf(46);
            this.name = n == -1 ? this.path : this.path.substring(n + 1);
        }
        return this.name;
    }

    @Override
    public void removeKey(String string) {
        this.set(string, null);
    }

    private void set(String string, Object object) {
        this.root.set(this.getKeyFor(string), object);
    }

    @Override
    public void setBoolean(String string, boolean bl) {
        this.set(string, bl);
    }

    @Override
    public void setDouble(String string, double d) {
        this.set(string, d);
    }

    @Override
    public void setInt(String string, int n) {
        this.set(string, n);
    }

    @Override
    public void setLong(String string, long l) {
        this.set(string, l);
    }

    @Override
    public void setRaw(String string, Object object) {
        this.set(string, object);
    }

    @Override
    public void setString(String string, String string2) {
        this.set(string, string2);
    }

    public String toString() {
        return "MemoryDataKey[" + this.path + "]";
    }
}

