/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import clib.net.kyori.adventure.platform.bukkit.BukkitAudiences;
import clib.net.kyori.adventure.platform.bukkit.BukkitComponentSerializer;
import clib.net.kyori.adventure.platform.bukkit.MinecraftComponentSerializer;
import clib.net.kyori.adventure.text.format.NamedTextColor;
import clib.net.kyori.adventure.text.format.TextDecoration;
import clib.net.kyori.adventure.text.minimessage.MiniMessage;
import clib.net.kyori.adventure.text.minimessage.tag.Tag;
import clib.net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.Translator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class Messaging {
    private static BukkitAudiences AUDIENCES;
    private static final Pattern CHAT_NEWLINE;
    private static final Splitter CHAT_NEWLINE_SPLITTER;
    private static final Map<String, String> COLORCODE_CONVERTER;
    private static boolean DEBUG;
    private static Logger DEBUG_LOGGER;
    private static String ERROR_COLOUR;
    private static final Pattern ERROR_MATCHER;
    private static final Pattern HEX_CODE_MATCHER;
    private static final Pattern HEX_MATCHER;
    private static String HIGHLIGHT_COLOUR;
    private static final Pattern HIGHLIGHT_MATCHER;
    private static final Pattern LEGACY_COLORCODE_MATCHER;
    private static Logger LOGGER;
    private static String MESSAGE_COLOUR;
    private static MiniMessage MINIMESSAGE;
    private static Pattern MINIMESSAGE_COLORCODE_MATCHER;
    private static final Joiner SPACE;
    private static final Pattern TRANSLATION_MATCHER;

    public static void configure(File file, boolean bl, String string, String string2, String string3) {
        DEBUG = bl;
        MESSAGE_COLOUR = string.replace("<a>", "<green>");
        HIGHLIGHT_COLOUR = string2.replace("<e>", "yellow").replace("<yellow>", "yellow");
        ERROR_COLOUR = string3.replace("<c>", "<red>");
        if (Bukkit.getLogger() != null) {
            DEBUG_LOGGER = LOGGER = Bukkit.getLogger();
        }
        if (CitizensAPI.getPlugin() != null) {
            try {
                if (MinecraftComponentSerializer.isSupported()) {
                    AUDIENCES = BukkitAudiences.create((Plugin)CitizensAPI.getPlugin());
                } else {
                    Messaging.log("Unable to load Adventure, chat components will not work");
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (file != null) {
            DEBUG_LOGGER = Logger.getLogger("CitizensDebug");
            try {
                FileHandler fileHandler = new FileHandler(file.getAbsolutePath(), true);
                fileHandler.setFormatter(new DebugFormatter());
                DEBUG_LOGGER.setUseParentHandlers(false);
                DEBUG_LOGGER.addHandler(fileHandler);
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static String convertLegacyCodes(String string) {
        if (string == null) {
            return null;
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        Matcher matcher = HEX_MATCHER.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "<#$1$2$3$4$5$6>");
        }
        matcher.appendTail(stringBuffer);
        matcher = HEX_CODE_MATCHER.matcher(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "<$1>");
        }
        matcher.appendTail(stringBuffer);
        matcher = LEGACY_COLORCODE_MATCHER.matcher(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, COLORCODE_CONVERTER.get(matcher.group(1) == null ? matcher.group(2).toLowerCase() : matcher.group(1).toLowerCase()));
        }
        matcher.appendTail(stringBuffer);
        return MINIMESSAGE_COLORCODE_MATCHER.matcher(stringBuffer.toString()).replaceAll("$0<csr>");
    }

    public static void debug(Object ... objectArray) {
        if (Messaging.isDebugging()) {
            DEBUG_LOGGER.log(Level.INFO, "[Citizens] " + SPACE.join(objectArray));
        }
    }

    public static void idebug(Supplier<String> supplier) {
        if (Messaging.isDebugging()) {
            DEBUG_LOGGER.log(Level.INFO, "[Citizens] " + supplier.get());
        }
    }

    public static boolean isDebugging() {
        return DEBUG;
    }

    private static void log(Level level, Object ... objectArray) {
        LOGGER.log(level, "[Citizens] " + SPACE.join(objectArray));
    }

    public static void log(Object ... objectArray) {
        Messaging.log(Level.INFO, objectArray);
    }

    public static void logTr(String string, Object ... objectArray) {
        Messaging.log(Level.INFO, Translator.translate(string, objectArray));
    }

    public static Object minecraftComponentFromRawMessage(String string) {
        if (AUDIENCES != null && MINIMESSAGE != null) {
            return MinecraftComponentSerializer.get().serialize(MINIMESSAGE.deserialize((Object)Messaging.convertLegacyCodes(string)));
        }
        return null;
    }

    public static String parseComponents(String string) {
        if (AUDIENCES != null && MINIMESSAGE != null) {
            return BukkitComponentSerializer.legacy().serialize(MINIMESSAGE.deserialize((Object)Messaging.convertLegacyCodes(string)));
        }
        return Messaging.convertLegacyCodes(string);
    }

    private static String prettify(String string) {
        String string2 = string.trim();
        String string3 = MESSAGE_COLOUR;
        String string4 = Messaging.convertLegacyCodes(string2);
        if (!string4.isEmpty()) {
            if (string4.charAt(0) == '\u00a7') {
                ChatColor chatColor = ChatColor.getByChar((String)string4.substring(1, 2));
                if (chatColor == null) {
                    string = string3 + string;
                } else {
                    string3 = chatColor.toString();
                }
            } else {
                string = string3 + string;
            }
        }
        string = CHAT_NEWLINE.matcher(string).replaceAll("<reset><br>]]");
        string = HIGHLIGHT_MATCHER.matcher(string).replaceAll("<" + HIGHLIGHT_COLOUR + ">");
        string = ERROR_MATCHER.matcher(string).replaceAll(ERROR_COLOUR);
        return string.replace("]]", MESSAGE_COLOUR);
    }

    public static void send(CommandSender commandSender, Object ... objectArray) {
        Messaging.sendMessageTo(commandSender, SPACE.join(objectArray), true);
    }

    public static void sendColorless(CommandSender commandSender, Object ... objectArray) {
        Messaging.sendMessageTo(commandSender, SPACE.join(objectArray), false);
    }

    public static void sendError(CommandSender commandSender, Object ... objectArray) {
        Messaging.send(commandSender, ERROR_COLOUR + SPACE.join(objectArray));
    }

    public static void sendErrorTr(CommandSender commandSender, String string, Object ... objectArray) {
        Messaging.send(commandSender, ERROR_COLOUR + Translator.translate(string, objectArray));
    }

    private static void sendMessageTo(CommandSender commandSender, String string, boolean bl) {
        for (String string2 : CHAT_NEWLINE_SPLITTER.split((CharSequence)string)) {
            if (bl) {
                string2 = Messaging.prettify(string2);
            }
            if (AUDIENCES != null) {
                AUDIENCES.sender(commandSender).sendMessage(MINIMESSAGE.deserialize((Object)Messaging.convertLegacyCodes(string2)));
                continue;
            }
            commandSender.sendMessage(Messaging.convertLegacyCodes(string));
        }
    }

    public static void sendTr(CommandSender commandSender, String string, Object ... objectArray) {
        Messaging.sendMessageTo(commandSender, Translator.translate(string, objectArray), true);
    }

    public static void sendTrColorless(CommandSender commandSender, String string, Object ... objectArray) {
        Messaging.sendMessageTo(commandSender, Translator.translate(string, objectArray), false);
    }

    public static void sendWithNPC(CommandSender commandSender, Object object, NPC nPC) {
        Messaging.sendMessageTo(commandSender, Placeholders.replace(object.toString(), commandSender, nPC), true);
    }

    public static void sendWithNPCColorless(CommandSender commandSender, Object object, NPC nPC) {
        Messaging.sendMessageTo(commandSender, Placeholders.replace(object.toString(), commandSender, nPC), false);
    }

    public static void severe(Object ... objectArray) {
        Messaging.log(Level.SEVERE, objectArray);
    }

    public static void severeTr(String string, Object ... objectArray) {
        Messaging.log(Level.SEVERE, Translator.translate(string, objectArray));
    }

    public static String stripColor(String string) {
        string = ChatColor.stripColor((String)Messaging.convertLegacyCodes(string));
        if (AUDIENCES != null && MINIMESSAGE != null) {
            return MINIMESSAGE.stripTags(string);
        }
        return string;
    }

    public static String tr(String string, Object ... objectArray) {
        return Messaging.prettify(Translator.translate(string, objectArray));
    }

    public static String tryTranslate(Object object) {
        if (object == null) {
            return "";
        }
        String string = object.toString();
        return TRANSLATION_MATCHER.matcher(string).find() ? Messaging.tr(string, new Object[0]) : string;
    }

    static {
        CHAT_NEWLINE = Pattern.compile("<br>|\\n", 8);
        CHAT_NEWLINE_SPLITTER = Splitter.on((Pattern)CHAT_NEWLINE);
        COLORCODE_CONVERTER = Maps.newHashMap();
        DEBUG = false;
        ERROR_COLOUR = "<red>";
        ERROR_MATCHER = Pattern.compile("{{", 16);
        HEX_CODE_MATCHER = Pattern.compile("&(#[0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f])", 2);
        HEX_MATCHER = Pattern.compile("&x&([0-9a-f])&([0-9a-f])&([0-9a-f])&([0-9a-f])&([0-9a-f])&([0-9a-f])".replace('&', '\u00a7'), 2);
        HIGHLIGHT_COLOUR = "yellow";
        HIGHLIGHT_MATCHER = Pattern.compile("[[", 16);
        LEGACY_COLORCODE_MATCHER = Pattern.compile("\u00a7([0-9a-r])|<([0-9a-f])>", 2);
        LOGGER = Logger.getLogger("Citizens");
        MESSAGE_COLOUR = "<green>";
        SPACE = Joiner.on((String)" ").useForNull("null");
        TRANSLATION_MATCHER = Pattern.compile("^[a-zA-Z0-9]+\\.[a-zA-Z0-9]+\\.[a-zA-Z0-9.]+");
        COLORCODE_CONVERTER.put("0", "<black>");
        COLORCODE_CONVERTER.put("1", "<dark_blue>");
        COLORCODE_CONVERTER.put("2", "<dark_green>");
        COLORCODE_CONVERTER.put("3", "<dark_aqua>");
        COLORCODE_CONVERTER.put("4", "<dark_red>");
        COLORCODE_CONVERTER.put("5", "<dark_purple>");
        COLORCODE_CONVERTER.put("6", "<gold>");
        COLORCODE_CONVERTER.put("7", "<gray>");
        COLORCODE_CONVERTER.put("8", "<dark_gray>");
        COLORCODE_CONVERTER.put("9", "<blue>");
        COLORCODE_CONVERTER.put("a", "<green>");
        COLORCODE_CONVERTER.put("b", "<aqua>");
        COLORCODE_CONVERTER.put("c", "<red>");
        COLORCODE_CONVERTER.put("d", "<light_purple>");
        COLORCODE_CONVERTER.put("e", "<yellow>");
        COLORCODE_CONVERTER.put("f", "<white>");
        COLORCODE_CONVERTER.put("m", "<st>");
        COLORCODE_CONVERTER.put("n", "<u>");
        COLORCODE_CONVERTER.put("k", "<obf>");
        COLORCODE_CONVERTER.put("o", "<i>");
        COLORCODE_CONVERTER.put("l", "<b>");
        COLORCODE_CONVERTER.put("r", "<reset>");
        try {
            MINIMESSAGE_COLORCODE_MATCHER = Pattern.compile(Joiner.on((char)'|').join((Iterable)Collections2.transform((Collection)NamedTextColor.NAMES.values(), namedTextColor -> '<' + namedTextColor.toString() + '>')) + "|<#[a-f\\d]{6}>", 2);
            MINIMESSAGE = MiniMessage.builder().editTags(builder2 -> builder2.resolver((TagResolver)TagResolver.resolver((String)"csr", (Tag)Tag.styling(builder -> Arrays.stream(TextDecoration.values()).forEach(textDecoration -> builder.decoration(textDecoration, false)))))).build();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class DebugFormatter
    extends Formatter {
        private final SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ");

        private DebugFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            Throwable throwable = logRecord.getThrown();
            String string = this.date.format(logRecord.getMillis());
            string = string + "[" + logRecord.getLevel().getName().toUpperCase() + "] ";
            string = string + logRecord.getMessage() + '\n';
            if (throwable != null) {
                StringWriter stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stringWriter));
                return string + stringWriter;
            }
            return string;
        }
    }
}

