/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;

public class Paginator {
    private boolean console;
    private String header;
    private final List<String> lines = new ArrayList<String>();
    private String pageCommand;
    private boolean pageSwitcher;
    private static final int LINES_PER_PAGE = 9;

    public Paginator() {
    }

    public Paginator(Collection<String> collection) {
        this.lines.addAll(collection);
    }

    public Paginator(int n) {
        for (int i = 0; i < n; ++i) {
            this.lines.add("");
        }
    }

    public void addLine(String string) {
        this.lines.add(string);
    }

    public Paginator console(boolean bl) {
        this.console = bl;
        return this;
    }

    public Paginator enablePageSwitcher() {
        this.pageSwitcher = true;
        this.pageCommand = "page $page";
        return this;
    }

    public Paginator enablePageSwitcher(String string) {
        this.pageSwitcher = true;
        this.pageCommand = string;
        return this;
    }

    public String getPageText(int n) {
        String string;
        int n2 = this.console ? 200 : 9;
        int n3 = (int)(Math.ceil((double)this.lines.size() / (double)n2) == 0.0 ? 1.0 : Math.ceil((double)this.lines.size() / (double)n2));
        if (n <= 0 || n > n3) {
            return null;
        }
        int n4 = n2 * n - n2;
        int n5 = n * n2;
        String string2 = n + "/" + n3;
        if (this.pageSwitcher) {
            if (n > 1) {
                string2 = "<click:run_command:" + this.pageCommand.replace("$page", "" + (n - 1)) + "><hover:show_text:Previous page><</hover></click> <white>" + string2;
            }
            if (n3 > 1 && n != n3) {
                string2 = string2 + " <click:run_command:" + this.pageCommand.replace("$page", "" + (n + 1)) + "><hover:show_text:Next page>></hover></click><white>";
            }
        }
        String string3 = string = this.header == null ? "" : Paginator.wrapHeader("[[" + this.header + " <white>" + string2);
        if (this.lines.size() < n5) {
            n5 = this.lines.size();
        }
        for (String string4 : this.lines.subList(n4, n5)) {
            string = string + "\n" + string4;
        }
        return string;
    }

    public boolean hasPage(int n) {
        int n2 = this.console ? 200 : 9;
        int n3 = (int)(Math.ceil((double)this.lines.size() / (double)n2) == 0.0 ? 1.0 : Math.ceil((double)this.lines.size() / (double)n2));
        return n > 0 && n <= n3;
    }

    public Paginator header(String string) {
        this.header = string;
        return this;
    }

    public boolean sendPage(CommandSender commandSender, int n) {
        String string = this.getPageText(n);
        if (string != null) {
            Messaging.send(commandSender, string);
            return true;
        }
        return false;
    }

    public static String wrapHeader(Object object) {
        return "[[=====[ " + object.toString() + " [[]=====";
    }
}

