/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;

public class SpigotUtil {
    private static int[] BUKKIT_VERSION = null;
    private static Pattern DAY_MATCHER = Pattern.compile("(\\d+d)");
    private static String MINECRAFT_PACKAGE;
    private static Pattern NUMBER_MATCHER;
    private static boolean SUPPORT_WORLD_HEIGHT;
    private static Boolean using1_13API;

    public static boolean checkYSafe(double d, World world) {
        if (!SUPPORT_WORLD_HEIGHT || world == null) {
            return d >= 0.0 && d <= 255.0;
        }
        try {
            return d >= (double)world.getMinHeight() && d <= (double)world.getMaxHeight();
        }
        catch (Throwable throwable) {
            SUPPORT_WORLD_HEIGHT = false;
            return d >= 0.0 && d <= 255.0;
        }
    }

    public static int getMaxNameLength(EntityType entityType) {
        return SpigotUtil.isUsing1_13API() ? 256 : 64;
    }

    public static String getMinecraftPackage() {
        if (MINECRAFT_PACKAGE == null) {
            int[] nArray = SpigotUtil.getVersion();
            if (nArray == null) {
                throw new IllegalStateException();
            }
            String string2 = "v" + nArray[0] + "_" + nArray[1] + "_R";
            ThrowingConsumer<String> throwingConsumer = string -> Class.forName("org.bukkit.craftbukkit." + string + ".CraftServer");
            if (Bukkit.getServer().getClass().getName().equals("org.bukkit.craftbukkit.CraftServer")) {
                Messaging.log("Using mojmapped server, avoiding server package checks");
                throwingConsumer = string -> Class.forName("net.citizensnpcs.nms." + string + ".util.NMSImpl");
            }
            String string3 = null;
            for (int i = 1; i <= 4; ++i) {
                try {
                    throwingConsumer.accept(string2 + i);
                    string3 = string2 + i;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
            }
            if (string3 == null) {
                throw new IllegalStateException();
            }
            MINECRAFT_PACKAGE = string3;
        }
        return MINECRAFT_PACKAGE;
    }

    public static int[] getVersion() {
        if (BUKKIT_VERSION == null) {
            String string = Bukkit.getBukkitVersion();
            if (string == null || string.isEmpty()) {
                BUKKIT_VERSION = new int[]{1, 8, 8};
                return BUKKIT_VERSION;
            }
            String[] stringArray = string.split("\\.");
            if (stringArray[1].contains("-")) {
                stringArray[1] = stringArray[1].split("-")[0];
            }
            if (stringArray[2].contains("-")) {
                stringArray[2] = stringArray[2].split("-")[0];
            }
            if (stringArray.length == 3) {
                BUKKIT_VERSION = new int[]{Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2])};
                return BUKKIT_VERSION;
            }
            BUKKIT_VERSION = new int[]{Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1])};
            return BUKKIT_VERSION;
        }
        return BUKKIT_VERSION;
    }

    public static boolean isUsing1_13API() {
        if (using1_13API == null) {
            try {
                Enchantment.getByKey((NamespacedKey)Enchantment.getByName((String)"ARROW_DAMAGE").getKey());
                using1_13API = true;
            }
            catch (Exception exception) {
                using1_13API = false;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                using1_13API = false;
            }
        }
        return using1_13API;
    }

    public static Duration parseDuration(String string, TimeUnit timeUnit) {
        if (timeUnit == null) {
            Integer n = Ints.tryParse((String)string);
            if (n != null) {
                return Duration.ofMillis(n * 50);
            }
        } else if (NUMBER_MATCHER.matcher(string).matches()) {
            return Duration.of(Longs.tryParse((String)string), SpigotUtil.toChronoUnit(timeUnit));
        }
        if (string.endsWith("t")) {
            return Duration.ofMillis(Integer.parseInt(string.substring(0, string.length() - 1)) * 50);
        }
        if ((string = DAY_MATCHER.matcher(string).replaceFirst("P$1T").replace("min", "m").replace("hr", "h")).charAt(0) != 'P') {
            string = "PT" + string;
        }
        return Duration.parse(string);
    }

    private static ChronoUnit toChronoUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new AssertionError();
    }

    static {
        NUMBER_MATCHER = Pattern.compile("(\\d+)");
        SUPPORT_WORLD_HEIGHT = true;
    }

    private static interface ThrowingConsumer<T> {
        public void accept(T var1) throws ClassNotFoundException;
    }
}

