/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.collect.Maps;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Translator {
    private final Map<String, String> baseTranslations = Translator.getBaseTranslations();
    private final Locale defaultLocale;
    private final Map<String, MessageFormat> messageFormatCache = Maps.newHashMap();
    private final Map<String, String> translations;
    private static Translator INSTANCE;
    private static final Pattern JAPANESE_PATTERN;

    private Translator(File file, Locale locale) {
        this.defaultLocale = locale;
        this.translations = Translator.getTranslations(file, locale);
    }

    private String format(String string, Locale locale, Object ... objectArray) {
        String string2 = Translator.translate(string, locale, new Object[0]);
        MessageFormat messageFormat = this.getFormatter(string2);
        return messageFormat.format(objectArray);
    }

    private MessageFormat getFormatter(String string) {
        MessageFormat messageFormat = this.messageFormatCache.get(string);
        if (messageFormat == null) {
            messageFormat = new MessageFormat(string);
            this.messageFormatCache.put(string, messageFormat);
        }
        return messageFormat;
    }

    private String translate(String string) {
        String string3 = this.translations.computeIfAbsent(string, string2 -> this.baseTranslations.get(string));
        return string3 == null ? "?" + string + "?" : string3;
    }

    public static String format(String string, Object ... objectArray) {
        MessageFormat messageFormat = INSTANCE.getFormatter(string);
        return messageFormat.format(objectArray);
    }

    private static Map<String, String> getBaseTranslations() {
        JSONObject jSONObject;
        JSONParser jSONParser = new JSONParser();
        InputStreamReader inputStreamReader = new InputStreamReader(Translator.class.getResourceAsStream("/en.json"), StandardCharsets.UTF_8);
        try {
            jSONObject = (JSONObject)jSONParser.parse((Reader)inputStreamReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)inputStreamReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParseException throwable3) {
                throwable3.printStackTrace();
                return null;
            }
        }
        ((Reader)inputStreamReader).close();
        return jSONObject;
    }

    private static Charset getCharset(String string) {
        Charset charset = JAPANESE_PATTERN.matcher(string).find() && Charset.isSupported("Shift-JIS") ? Charset.forName("Shift-JIS") : StandardCharsets.UTF_8;
        return charset;
    }

    private static Map<String, String> getTranslations(File file, Locale locale) {
        JSONObject jSONObject;
        JSONParser jSONParser = new JSONParser();
        InputStream inputStream = null;
        Charset charset = Translator.getCharset(locale.toString() + ".json");
        if (new File(file, locale.toString() + ".json").exists()) {
            try {
                inputStream = new FileInputStream(new File(file, locale.toString() + ".json"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        } else if (new File(file, locale.getLanguage() + ".json").exists()) {
            try {
                inputStream = new FileInputStream(new File(file, locale.getLanguage() + ".json"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        } else {
            inputStream = Translator.class.getResourceAsStream("/" + locale.getLanguage() + ".json");
            if (inputStream != null) {
                if (!locale.getLanguage().equals("en")) {
                    new Thread(new SaveResource(file, locale.getLanguage() + ".json")).start();
                }
            } else {
                inputStream = Translator.class.getResourceAsStream("/" + locale.toString() + ".json");
                if (inputStream != null && !locale.getLanguage().equals("en")) {
                    new Thread(new SaveResource(file, locale.toString() + ".json")).start();
                }
            }
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
        try {
            jSONObject = (JSONObject)jSONParser.parse((Reader)inputStreamReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)inputStreamReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NullPointerException | ParseException throwable3) {
                return Maps.newHashMap();
            }
        }
        ((Reader)inputStreamReader).close();
        return jSONObject;
    }

    public static void setInstance(File file, Locale locale) {
        INSTANCE = new Translator(file, locale);
    }

    private static String translate(String string, Locale locale, Object ... objectArray) {
        return objectArray.length == 0 ? INSTANCE.translate(string) : INSTANCE.format(string, locale, objectArray);
    }

    public static String translate(String string, Object ... objectArray) {
        return Translator.translate(string, Translator.INSTANCE.defaultLocale, objectArray);
    }

    static {
        JAPANESE_PATTERN = Pattern.compile(".*?ja(_jp)?\\.json", 2);
    }

    private static class SaveResource
    implements Runnable {
        private final String fileName;
        private final File rootFolder;

        private SaveResource(File file, String string) {
            this.rootFolder = file;
            this.fileName = string;
        }

        @Override
        public void run() {
            File file = new File(this.rootFolder, this.fileName);
            if (file.exists()) {
                return;
            }
            try {
                this.rootFolder.mkdirs();
                File file2 = File.createTempFile(this.fileName, null, this.rootFolder);
                file2.deleteOnExit();
                Resources.asByteSource((URL)Resources.getResource(Translator.class, (String)('/' + this.fileName))).copyTo(Files.asByteSink((File)file2, (FileWriteMode[])new FileWriteMode[0]));
                if (!file.exists()) {
                    file2.renameTo(file);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

