/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.FileStorage;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlStorageWithLists
implements FileStorage {
    private final FileConfiguration config = new YamlConfiguration();
    private final File file;
    private static Field LOADER_OPTIONS;
    private static Method SET_CODEPOINT_LIMIT;

    public YamlStorageWithLists(File file) {
        this(file, null);
    }

    public YamlStorageWithLists(File file, String string) {
        this.tryIncreaseMaxCodepoints(this.config);
        this.file = file;
        if (!file.exists()) {
            this.create();
            if (string != null) {
                this.config.options().header(string);
            }
            this.save();
        }
    }

    private void create() {
        try {
            Bukkit.getLogger().log(Level.INFO, "Creating file: " + this.file.getName());
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
        }
        catch (IOException iOException) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not create file: " + this.file.getName());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        YamlStorageWithLists yamlStorageWithLists = (YamlStorageWithLists)object;
        return Objects.equals(this.file, yamlStorageWithLists.file);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public YamlKey getKey(String string) {
        return new YamlKey(string);
    }

    public int hashCode() {
        return 31 + (this.file == null ? 0 : this.file.hashCode());
    }

    @Override
    public boolean load() {
        try {
            this.config.load(this.file);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private boolean pathExists(String string) {
        return this.config.get(string) != null;
    }

    @Override
    public void save() {
        try {
            Files.createParentDirs((File)this.file);
            File file = File.createTempFile(this.file.getName(), null, this.file.getParentFile());
            file.deleteOnExit();
            this.config.save(file);
            this.file.delete();
            file.renameTo(this.file);
            file.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String toString() {
        return "YamlStorage {file=" + this.file + "}";
    }

    private void tryIncreaseMaxCodepoints(FileConfiguration fileConfiguration) {
        if (SET_CODEPOINT_LIMIT == null || LOADER_OPTIONS == null) {
            return;
        }
        try {
            SET_CODEPOINT_LIMIT.invoke(LOADER_OPTIONS.get(fileConfiguration), 0x4000000);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        try {
            LOADER_OPTIONS = YamlConfiguration.class.getDeclaredField("yamlLoaderOptions");
            LOADER_OPTIONS.setAccessible(true);
            SET_CODEPOINT_LIMIT = Class.forName("org.yaml.snakeyaml.LoaderOptions").getMethod("setCodepointLimit", Integer.TYPE);
            SET_CODEPOINT_LIMIT.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class YamlKey
    extends DataKey {
        public YamlKey(String string) {
            super(string);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object) || this.getClass() != object.getClass()) {
                return false;
            }
            YamlKey yamlKey = (YamlKey)object;
            return this.getOuterType().equals(yamlKey.getOuterType());
        }

        private Object get(String string2, Object object) {
            int n;
            int n2 = -1;
            Function<String, Object> function = string -> {
                ConfigurationSection configurationSection = YamlStorageWithLists.this.config.getConfigurationSection(string);
                return configurationSection == null ? YamlStorageWithLists.this.config.getList(string) : configurationSection;
            };
            Object object2 = YamlStorageWithLists.this.config;
            while ((n2 = string2.indexOf(46, n = n2 + 1)) != -1) {
                Object object3;
                String string3 = string2.substring(n, n2);
                object2 = function.apply(string3);
                if (object2 == null) {
                    return object;
                }
                if (object2 instanceof List) {
                    object3 = (List)object2;
                    function = arg_0 -> YamlKey.lambda$get$1((List)object3, object, arg_0);
                    continue;
                }
                if (object2 instanceof ConfigurationSection) {
                    object3 = (ConfigurationSection)object2;
                    function = arg_0 -> YamlKey.lambda$get$2((ConfigurationSection)object3, arg_0);
                    continue;
                }
                if (!(object2 instanceof Map)) continue;
                object3 = (Map)object2;
                function = arg_0 -> YamlKey.lambda$get$3((Map)object3, arg_0);
            }
            if (object2 == null) {
                return object;
            }
            if (object2 instanceof ConfigurationSection) {
                return ((ConfigurationSection)object2).get(string2.substring(n));
            }
            if (object2 instanceof List) {
                return ((List)object2).get(Ints.tryParse((String)string2.substring(n)));
            }
            if (object2 instanceof Map) {
                return ((Map)object2).get(string2.substring(n));
            }
            throw new RuntimeException();
        }

        @Override
        public boolean getBoolean(String string) {
            String string2 = this.createRelativeKey(string);
            Object object = this.get(string2, null);
            if (object != null) {
                return Boolean.parseBoolean(object.toString());
            }
            return false;
        }

        @Override
        public boolean getBoolean(String string, boolean bl) {
            return (Boolean)this.get(this.createRelativeKey(string), bl);
        }

        @Override
        public double getDouble(String string) {
            return this.getDouble(string, 0.0);
        }

        @Override
        public double getDouble(String string, double d) {
            String string2 = this.createRelativeKey(string);
            Object object = this.get(string2, d);
            if (object != null) {
                if (object instanceof Number) {
                    return ((Number)object).doubleValue();
                }
                String string3 = object.toString();
                return string3.isEmpty() ? d : Double.parseDouble(string3);
            }
            return d;
        }

        @Override
        public DataKey getFromRoot(String string) {
            return new YamlKey(string);
        }

        @Override
        public int getInt(String string) {
            return this.getInt(string, 0);
        }

        @Override
        public int getInt(String string, int n) {
            String string2 = this.createRelativeKey(string);
            Object object = this.get(string2, n);
            if (object != null) {
                if (object instanceof Number) {
                    return ((Number)object).intValue();
                }
                String string3 = object.toString();
                return string3.isEmpty() ? n : Integer.parseInt(string3);
            }
            return n;
        }

        @Override
        public Iterable<DataKey> getIntegerSubKeys() {
            return super.getIntegerSubKeys();
        }

        @Override
        public long getLong(String string) {
            return this.getLong(string, 0L);
        }

        @Override
        public long getLong(String string, long l) {
            String string2 = this.createRelativeKey(string);
            Object object = this.get(string2, l);
            if (object != null) {
                if (object instanceof Number) {
                    return ((Number)object).longValue();
                }
                String string3 = object.toString();
                return string3.isEmpty() ? l : Long.parseLong(string3);
            }
            return l;
        }

        private YamlStorageWithLists getOuterType() {
            return YamlStorageWithLists.this;
        }

        @Override
        public Object getRaw(String string) {
            return this.get(this.createRelativeKey(string), null);
        }

        @Override
        public YamlKey getRelative(String string) {
            if (string == null || string.isEmpty()) {
                return this;
            }
            return new YamlKey(this.createRelativeKey(string));
        }

        public YamlStorageWithLists getStorage() {
            return YamlStorageWithLists.this;
        }

        @Override
        public String getString(String string) {
            String string2 = this.createRelativeKey(string);
            Object object = this.get(string2, null);
            if (object != null) {
                return object.toString();
            }
            return "";
        }

        @Override
        public Iterable<DataKey> getSubKeys() {
            Object object = this.get(this.path, null);
            if (object == null) {
                return Collections.emptyList();
            }
            if (object instanceof List) {
                return IntStream.range(0, ((List)object).size()).mapToObj(this::getRelative).collect(Collectors.toList());
            }
            if (object instanceof Map) {
                return ((Map)object).keySet().stream().map(this::getRelative).collect(Collectors.toList());
            }
            ConfigurationSection configurationSection = (ConfigurationSection)object;
            return configurationSection.getKeys(false).stream().map(this::getRelative).collect(Collectors.toList());
        }

        @Override
        public Map<String, Object> getValuesDeep() {
            return this.sectionToValues(YamlStorageWithLists.this.config.getConfigurationSection(this.path));
        }

        @Override
        public int hashCode() {
            int n = 31;
            int n2 = 31 * super.hashCode() + this.getOuterType().hashCode();
            return n2;
        }

        @Override
        public boolean keyExists(String string) {
            return this.get(this.createRelativeKey(string), null) != null;
        }

        @Override
        public String name() {
            int n = this.path.lastIndexOf(46);
            return this.path.substring(n == 0 ? 0 : n + 1);
        }

        @Override
        public void removeKey(String string) {
            YamlStorageWithLists.this.config.set(this.createRelativeKey(string), null);
        }

        private void set(String string, Object object) {
            int n;
            int n2 = -1;
            Object object2 = YamlStorageWithLists.this.config;
            while ((n2 = string.indexOf(46, n = n2 + 1)) != -1) {
                Integer n3;
                String string2 = string.substring(n, n2);
                Cloneable cloneable = null;
                if (object2 instanceof ConfigurationSection) {
                    cloneable = ((ConfigurationSection)object2).get(string2);
                } else if (object2 instanceof Map) {
                    cloneable = ((Map)object2).get(string2);
                } else if (object2 instanceof List && (n3 = Ints.tryParse((String)string2)) != null) {
                    List list = (List)object2;
                    while (list.size() <= n3) {
                        list.add(new HashMap());
                    }
                    cloneable = list.get(n3);
                }
                int n4 = string.indexOf(46, n2 + 1);
                if (n4 != -1 && Ints.tryParse((String)string.substring(n2 + 1, n4)) != null) {
                    if (!(cloneable instanceof List)) {
                        cloneable = new ArrayList();
                        if (object2 instanceof ConfigurationSection) {
                            ((ConfigurationSection)object2).set(string2, cloneable);
                        } else if (object2 instanceof Map) {
                            ((Map)object2).put(string2, cloneable);
                        }
                    }
                } else if (cloneable == null) {
                    if (object2 instanceof ConfigurationSection) {
                        cloneable = ((ConfigurationSection)object2).createSection(string2);
                    } else if (object2 instanceof Map) {
                        cloneable = new HashMap();
                        ((Map)object2).put(string2, cloneable);
                    }
                }
                object2 = cloneable;
            }
            if (object2 == null) {
                throw new RuntimeException();
            }
            if (object2 instanceof ConfigurationSection) {
                ((ConfigurationSection)object2).set(string.substring(n), object);
            } else if (object2 instanceof List) {
                ((List)object2).set(Ints.tryParse((String)string.substring(n)), object);
            } else if (object2 instanceof Map) {
                ((Map)object2).put(string.substring(n), object);
            }
        }

        @Override
        public void setBoolean(String string, boolean bl) {
            this.set(this.createRelativeKey(string), bl);
        }

        @Override
        public void setDouble(String string, double d) {
            this.set(this.createRelativeKey(string), String.valueOf(d));
        }

        @Override
        public void setInt(String string, int n) {
            this.set(this.createRelativeKey(string), n);
        }

        @Override
        public void setLong(String string, long l) {
            this.set(this.createRelativeKey(string), l);
        }

        @Override
        public void setRaw(String string, Object object) {
            this.set(this.createRelativeKey(string), object);
        }

        @Override
        public void setString(String string, String string2) {
            this.set(this.createRelativeKey(string), string2);
        }

        public String toString() {
            return "YamlKey [path=" + this.path + "]";
        }

        private static /* synthetic */ Object lambda$get$3(Map map, String string) {
            return map.get(string);
        }

        private static /* synthetic */ Object lambda$get$2(ConfigurationSection configurationSection, String string) {
            ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string);
            return configurationSection2 == null ? configurationSection.getList(string) : configurationSection2;
        }

        private static /* synthetic */ Object lambda$get$1(List list, Object object, String string) {
            if (Ints.tryParse((String)string) >= list.size()) {
                return object;
            }
            return list.get(Ints.tryParse((String)string));
        }
    }
}

