/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands;

import java.util.Map;
import java.util.WeakHashMap;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.command.CommandSender;

@Requirements
public class AdminCommands {
    private final Citizens plugin;
    private final Map<CommandSender, Long> reloadTimeouts = new WeakHashMap<CommandSender, Long>();

    public AdminCommands(Citizens citizens) {
        this.plugin = citizens;
    }

    @Command(aliases={"citizens"}, desc="", max=0, permission="citizens.admin")
    public void citizens(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        Messaging.send(commandSender, StringHelper.wrapHeader("<green>Citizens v" + this.plugin.getDescription().getVersion()));
        Messaging.send(commandSender, "     <yellow>-- <green>Author: fullwall");
        Messaging.send(commandSender, "     <yellow>-- <green><click:open_url:" + this.plugin.getDescription().getWebsite() + "><hover:show_text:Citizens website including wiki><u>Website</hover></click> <click:open_url:https://discord.gg/Q6pZGSR><hover:show_text:Citizens Support Discord><u>Support</hover></click>");
    }

    @Command(aliases={"citizens"}, usage="reload", desc="", modifiers={"reload", "load"}, min=1, max=1, permission="citizens.admin")
    public void reload(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        Long l;
        if (Settings.Setting.WARN_ON_RELOAD.asBoolean() && ((l = this.reloadTimeouts.get(commandSender)) == null || System.currentTimeMillis() > l)) {
            Messaging.sendErrorTr(commandSender, "citizens.notifications.reload-warning", new Object[0]);
            this.reloadTimeouts.put(commandSender, System.currentTimeMillis() + 5000L);
            return;
        }
        Messaging.sendTr(commandSender, "citizens.notifications.reloading", new Object[0]);
        try {
            this.plugin.reload();
            Messaging.sendTr(commandSender, "citizens.notifications.reloaded", new Object[0]);
        }
        catch (NPCLoadException nPCLoadException) {
            nPCLoadException.printStackTrace();
            throw new CommandException("citizens.notifications.error-reloading");
        }
    }

    @Command(aliases={"citizens"}, usage="save (-a)", desc="", modifiers={"save"}, min=1, max=1, flags="a", permission="citizens.admin")
    public void save(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        Messaging.sendTr(commandSender, "citizens.notifications.saving", new Object[0]);
        this.plugin.storeNPCs(commandContext.hasFlag('a'));
        Messaging.sendTr(commandSender, "citizens.notifications.saved", new Object[0]);
    }
}

