/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands;

import java.util.Iterator;
import java.util.List;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.astar.pathfinder.ChunkBlockSource;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.hpastar.HPAGraph;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.waypoint.LinearWaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoints;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Requirements(ownership=true, selected=true)
public class WaypointCommands {
    @Command(aliases={"waypoints", "waypoint", "wp"}, usage="add [x] [y] [z] (world) (--index idx)", desc="", modifiers={"add"}, min=4, max=5, permission="citizens.waypoints.add")
    public void add(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"index"}) Integer n) {
        World world;
        WaypointProvider waypointProvider = nPC.getOrAddTrait(Waypoints.class).getCurrentProvider();
        if (!(waypointProvider instanceof LinearWaypointProvider)) {
            throw new CommandException();
        }
        List list = (List)((LinearWaypointProvider)waypointProvider).waypoints();
        World world2 = world = commandContext.argsLength() > 4 ? Bukkit.getWorld((String)commandContext.getString(4)) : nPC.getStoredLocation().getWorld();
        if (world == null) {
            throw new CommandException("citizens.commands.errors.missing-world");
        }
        Location location = new Location(world, (double)commandContext.getInteger(1), (double)commandContext.getInteger(2), (double)commandContext.getInteger(3));
        if (n == null) {
            n = list.size();
        }
        if (n > list.size() || n < 0) {
            throw new CommandException("Index out of range. Can't be more than " + list.size());
        }
        list.add(n, new Waypoint(location));
        Messaging.sendTr(commandSender, "citizens.commands.waypoints.add.waypoint-added", Util.prettyPrintLocation(location), n);
    }

    @Command(aliases={"waypoints", "waypoint", "wp"}, usage="disableteleport", desc="", modifiers={"disableteleport", "dt"}, min=1, max=1, permission="citizens.waypoints.disableteleport")
    public void disableTeleporting(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        nPC.data().setPersistent(NPC.Metadata.DISABLE_DEFAULT_STUCK_ACTION, (Object)(nPC.data().get(NPC.Metadata.DISABLE_DEFAULT_STUCK_ACTION, Boolean.valueOf(!Settings.Setting.DEFAULT_STUCK_ACTION.asString().contains("teleport"))) == false ? 1 : 0));
        if (nPC.data().get(NPC.Metadata.DISABLE_DEFAULT_STUCK_ACTION, Boolean.valueOf(!Settings.Setting.DEFAULT_STUCK_ACTION.asString().contains("teleport"))).booleanValue()) {
            nPC.getNavigator().getDefaultParameters().stuckAction(null);
            Messaging.sendTr(commandSender, "citizens.commands.waypoints.disableteleporting.disabled", nPC.getName());
        } else {
            nPC.getNavigator().getDefaultParameters().stuckAction(TeleportStuckAction.INSTANCE);
            Messaging.sendTr(commandSender, "citizens.commands.waypoints.disableteleporting.enabled", nPC.getName());
        }
    }

    @Command(aliases={"waypoints", "waypoint", "wp"}, usage="hpa", desc="", modifiers={"hpa"}, min=1, max=1, permission="citizens.waypoints.hpa")
    public void hpa(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        if (Messaging.isDebugging() && commandSender.isOp()) {
            HPAGraph hPAGraph = new HPAGraph(new ChunkBlockSource(nPC.getStoredLocation(), 16.0f), nPC.getStoredLocation().getBlockX(), nPC.getStoredLocation().getBlockY(), nPC.getStoredLocation().getBlockZ());
            hPAGraph.addClusters(nPC.getStoredLocation().getBlockX(), nPC.getStoredLocation().getBlockZ());
            System.out.println(hPAGraph.findPath(new Location(nPC.getStoredLocation().getWorld(), 8.0, 68.0, -134.0), new Location(nPC.getStoredLocation().getWorld(), 11.0, 68.0, -131.0)));
        }
    }

    @Command(aliases={"waypoints", "waypoint", "wp"}, usage="provider [provider name]", desc="", modifiers={"provider"}, min=1, max=2, permission="citizens.waypoints.provider")
    public void provider(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        boolean bl;
        Waypoints waypoints = nPC.getOrAddTrait(Waypoints.class);
        if (commandContext.argsLength() == 1) {
            Messaging.sendTr(commandSender, "citizens.waypoints.current-provider", waypoints.getCurrentProviderName());
            waypoints.describeProviders(commandSender);
            return;
        }
        if (commandSender instanceof Player && Editor.hasEditor((Player)commandSender)) {
            Editor.leave((Player)commandSender);
        }
        if (!(bl = waypoints.setWaypointProvider(commandContext.getString(1)))) {
            throw new CommandException("Provider not found.");
        }
        Messaging.sendTr(commandSender, "citizens.waypoints.set-provider", commandContext.getString(1));
    }

    @Command(aliases={"waypoints", "waypoint", "wp"}, usage="remove (x y z world) (--index idx)", desc="", modifiers={"remove"}, min=1, max=5, permission="citizens.waypoints.remove")
    public void remove(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"index"}) Integer n) {
        WaypointProvider waypointProvider = nPC.getOrAddTrait(Waypoints.class).getCurrentProvider();
        if (!(waypointProvider instanceof LinearWaypointProvider)) {
            throw new CommandException();
        }
        List list = (List)((LinearWaypointProvider)waypointProvider).waypoints();
        if (n != null && n >= 0 && n < list.size()) {
            list.remove(n);
            Messaging.sendTr(commandSender, "citizens.commands.waypoints.waypoint-removed", n);
        } else {
            World world;
            if (commandContext.argsLength() < 4) {
                throw new CommandUsageException();
            }
            World world2 = world = commandContext.argsLength() > 4 ? Bukkit.getWorld((String)commandContext.getString(4)) : nPC.getStoredLocation().getWorld();
            if (world == null) {
                throw new CommandException("citizens.commands.errors.missing-world");
            }
            Location location = new Location(world, (double)commandContext.getInteger(1), (double)commandContext.getInteger(2), (double)commandContext.getInteger(3));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Waypoint waypoint = (Waypoint)iterator.next();
                if (!waypoint.getLocation().equals((Object)location)) continue;
                iterator.remove();
            }
            Messaging.sendTr(commandSender, "citizens.commands.waypoints.waypoint-removed", Util.prettyPrintLocation(location));
        }
    }
}

