/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.editor;

import java.util.function.Function;
import net.citizensnpcs.api.gui.CitizensInventoryClickEvent;
import net.citizensnpcs.api.gui.ClickHandler;
import net.citizensnpcs.api.gui.InjectContext;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.gui.MenuPattern;
import net.citizensnpcs.api.gui.MenuSlot;
import net.citizensnpcs.api.gui.MenuSlots;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Equipment;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

@Menu(title="NPC Equipment", type=InventoryType.CHEST, dimensions={2, 5})
@MenuSlots(value={@MenuSlot(slot={0, 1}, compatMaterial={"SHIELD", "BARRIER", "FIRE"}, lore="Place offhand item below", amount=1), @MenuSlot(slot={0, 0}, material=Material.DIAMOND_SWORD, lore="Place in hand item below", amount=1), @MenuSlot(slot={0, 2}, material=Material.DIAMOND_HELMET, lore="Place helmet below", amount=1), @MenuSlot(slot={0, 3}, material=Material.DIAMOND_CHESTPLATE, lore="Place chestplate below", amount=1), @MenuSlot(slot={0, 4}, material=Material.DIAMOND_LEGGINGS, lore="Place leggings below", amount=1), @MenuSlot(slot={0, 5}, material=Material.DIAMOND_BOOTS, lore="Place boots below", amount=1)})
@MenuPattern(offset={0, 6}, slots={@MenuSlot(pat=120, compatMaterial={"BARRIER", "FIRE"}, title="<4>Unused")}, value="xxx\nxxx")
public class GenericEquipperGUI
extends InventoryMenuPage {
    @MenuSlot(slot={1, 5})
    private InventoryMenuSlot boots;
    @MenuSlot(slot={1, 3})
    private InventoryMenuSlot chest;
    @MenuSlot(slot={1, 0})
    private InventoryMenuSlot hand;
    @MenuSlot(slot={1, 2})
    private InventoryMenuSlot helmet;
    @MenuSlot(slot={1, 4})
    private InventoryMenuSlot leggings;
    @InjectContext
    private NPC npc;
    @MenuSlot(slot={1, 1})
    private InventoryMenuSlot offhand;

    @Override
    public void initialise(MenuContext menuContext) {
        Equipment equipment = this.npc.getOrAddTrait(Equipment.class);
        this.hand.setItemStack(equipment.get(Equipment.EquipmentSlot.HAND));
        this.helmet.setItemStack(equipment.get(Equipment.EquipmentSlot.HELMET));
        this.chest.setItemStack(equipment.get(Equipment.EquipmentSlot.CHESTPLATE));
        this.leggings.setItemStack(equipment.get(Equipment.EquipmentSlot.LEGGINGS));
        this.boots.setItemStack(equipment.get(Equipment.EquipmentSlot.BOOTS));
        this.offhand.setItemStack(equipment.get(Equipment.EquipmentSlot.OFF_HAND));
    }

    private void set(Equipment.EquipmentSlot equipmentSlot, CitizensInventoryClickEvent citizensInventoryClickEvent, Function<Material, Boolean> function) {
        ItemStack itemStack = citizensInventoryClickEvent.getResultItemNonNull();
        if (citizensInventoryClickEvent.isCancelled() || !function.apply(itemStack.getType()).booleanValue()) {
            citizensInventoryClickEvent.setResult(Event.Result.DENY);
            return;
        }
        this.npc.getOrAddTrait(Equipment.class).set(equipmentSlot, itemStack);
    }

    @ClickHandler(slot={1, 5})
    public void setBoots(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
        this.set(Equipment.EquipmentSlot.BOOTS, citizensInventoryClickEvent, material -> material == Material.AIR || material.name().endsWith("BOOTS"));
    }

    @ClickHandler(slot={1, 3})
    public void setChest(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
        this.set(Equipment.EquipmentSlot.CHESTPLATE, citizensInventoryClickEvent, material -> material == Material.AIR || material.name().endsWith("CHESTPLATE") || material.name().equals("ELYTRA"));
    }

    @ClickHandler(slot={1, 0})
    public void setHand(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
        this.set(Equipment.EquipmentSlot.HAND, citizensInventoryClickEvent, material -> true);
    }

    @ClickHandler(slot={1, 2})
    public void setHelmet(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
        this.set(Equipment.EquipmentSlot.HELMET, citizensInventoryClickEvent, material -> true);
    }

    @ClickHandler(slot={1, 4})
    public void setLeggings(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
        this.set(Equipment.EquipmentSlot.LEGGINGS, citizensInventoryClickEvent, material -> material == Material.AIR || material.name().endsWith("LEGGINGS"));
    }

    @ClickHandler(slot={1, 1})
    public void setOffhand(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
        this.set(Equipment.EquipmentSlot.OFF_HAND, citizensInventoryClickEvent, material -> true);
    }
}

