/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.editor;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.editor.Equipper;
import net.citizensnpcs.trait.SheepTrait;
import net.citizensnpcs.trait.WoolColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Dye;

public class SheepEquipper
implements Equipper {
    @Override
    public void equip(Player player, NPC nPC) {
        ItemStack itemStack = player.getInventory().getItemInHand();
        Sheep sheep = (Sheep)nPC.getEntity();
        if (itemStack.getType() == Material.SHEARS) {
            Messaging.sendTr((CommandSender)player, nPC.getOrAddTrait(SheepTrait.class).toggleSheared() ? "citizens.editors.equipment.sheared-set" : "citizens.editors.equipment.sheared-stopped", nPC.getName());
        } else if (itemStack.getType() != null && itemStack.getType().name().contains("INK_SAC")) {
            Dye dye = (Dye)itemStack.getData();
            if (sheep.getColor() == dye.getColor()) {
                return;
            }
            DyeColor dyeColor = dye.getColor();
            nPC.getOrAddTrait(WoolColor.class).setColor(dyeColor);
            Messaging.sendTr((CommandSender)player, "citizens.editors.equipment.sheep-coloured", nPC.getName(), dyeColor.name().toLowerCase().replace("_", " "));
            itemStack.setAmount(itemStack.getAmount() - 1);
        } else {
            nPC.getOrAddTrait(WoolColor.class).setColor(DyeColor.WHITE);
            Messaging.sendTr((CommandSender)player, "citizens.editors.equipment.sheep-coloured", nPC.getName(), "white");
        }
        player.getInventory().setItemInHand(itemStack);
    }
}

