/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.editor;

import net.citizensnpcs.api.gui.CitizensInventoryClickEvent;
import net.citizensnpcs.api.gui.ClickHandler;
import net.citizensnpcs.api.gui.InjectContext;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.gui.MenuPattern;
import net.citizensnpcs.api.gui.MenuSlot;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.Saddle;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

@Menu(title="NPC Equipment", type=InventoryType.HOPPER, dimensions={0, 5})
@MenuSlot(slot={0, 0}, material=Material.SADDLE, amount=1, lore="Place a saddle here ->")
@MenuPattern(offset={0, 2}, slots={@MenuSlot(pat=120, compatMaterial={"BARRIER", "FIRE"}, title="<4>Unused")}, value="xxx")
public class SteerableEquipperGUI
extends InventoryMenuPage {
    @InjectContext
    private NPC npc;
    @MenuSlot(slot={0, 1})
    private InventoryMenuSlot saddle;

    @Override
    public void initialise(MenuContext menuContext) {
        Saddle saddle = this.npc.getOrAddTrait(Saddle.class);
        if (saddle.useSaddle()) {
            this.saddle.setItemStack(new ItemStack(Material.SADDLE, 1));
        }
    }

    @ClickHandler(slot={0, 1}, filter={InventoryAction.PICKUP_ALL, InventoryAction.PLACE_ALL})
    public void setSaddle(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
        if (citizensInventoryClickEvent.getAction() == InventoryAction.PICKUP_ALL && citizensInventoryClickEvent.getCursor() != null) {
            citizensInventoryClickEvent.setResult(Event.Result.DENY);
            return;
        }
        if (citizensInventoryClickEvent.getAction() == InventoryAction.PLACE_ALL && (citizensInventoryClickEvent.getCurrentItem() != null || citizensInventoryClickEvent.getCursor().getType() != Material.SADDLE)) {
            citizensInventoryClickEvent.setResult(Event.Result.DENY);
            return;
        }
        this.npc.getOrAddTrait(Saddle.class).toggle();
    }
}

