/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.entity;

import java.lang.invoke.MethodHandle;
import java.util.List;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_16_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_16_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_16_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.versioned.EnderDragonTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_16_R3.AxisAlignedBB;
import net.minecraft.server.v1_16_R3.DamageSource;
import net.minecraft.server.v1_16_R3.DragonControllerPhase;
import net.minecraft.server.v1_16_R3.EntityBoat;
import net.minecraft.server.v1_16_R3.EntityEnderDragon;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityMinecartAbstract;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EnumPistonReaction;
import net.minecraft.server.v1_16_R3.FluidType;
import net.minecraft.server.v1_16_R3.IEntitySelector;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.SoundEffect;
import net.minecraft.server.v1_16_R3.Tag;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class EnderDragonController
extends MobEntityController {
    public EnderDragonController() {
        super(EntityEnderDragonNPC.class);
    }

    public EnderDragon getBukkitEntity() {
        return (EnderDragon)super.getBukkitEntity();
    }

    public static class EntityEnderDragonNPC
    extends EntityEnderDragon
    implements NPCHolder {
        private final CitizensNPC npc;
        private static final MethodHandle HURT = NMS.getMethodHandle(EntityEnderDragon.class, "b", true, List.class);
        private static final MethodHandle KNOCKBACK = NMS.getMethodHandle(EntityEnderDragon.class, "a", true, List.class);

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> entityTypes, World world) {
            this(entityTypes, world, null);
        }

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> entityTypes, World world, NPC nPC) {
            super(entityTypes, world);
            this.npc = (CitizensNPC)nPC;
        }

        public void a(AxisAlignedBB axisAlignedBB) {
            super.a(NMSBoundingBox.makeBB(this.npc, axisAlignedBB));
        }

        public void a(float f, double d, double d2) {
            NMS.callKnockbackEvent(this.npc, f, d, d2, nPCKnockbackEvent -> super.a((float)nPCKnockbackEvent.getStrength(), nPCKnockbackEvent.getKnockbackVector().getX(), nPCKnockbackEvent.getKnockbackVector().getZ()));
        }

        public boolean a(Tag<FluidType> tag, double d) {
            if (this.npc == null) {
                return super.a(tag, d);
            }
            Vec3D vec3D = this.getMot().add(0.0, 0.0, 0.0);
            boolean bl = super.a(tag, d);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(vec3D);
            }
            return bl;
        }

        public int bP() {
            return NMS.getFallDistance(this.npc, super.bP());
        }

        public void checkDespawn() {
            if (this.npc == null) {
                super.checkDespawn();
            }
        }

        public void collide(net.minecraft.server.v1_16_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.d(nBTTagCompound) : false;
        }

        protected boolean dealDamage(DamageSource damageSource, float f) {
            if (this.npc == null) {
                return super.dealDamage(damageSource, f);
            }
            Vec3D vec3D = this.getMot();
            boolean bl = super.dealDamage(damageSource, f);
            if (this.getDragonControllerManager().a().getControllerPhase() == DragonControllerPhase.HOVER) {
                this.setMot(vec3D);
            }
            return bl;
        }

        public float dJ() {
            return NMS.getJumpPower(this.npc, super.dJ());
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.server.v1_16_R3.Entity)this, (CraftEntity)new EnderDragonNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction getPushReaction() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.IGNORE : super.getPushReaction();
        }

        protected SoundEffect getSoundAmbient() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundAmbient(), NPC.Metadata.AMBIENT_SOUND);
        }

        protected SoundEffect getSoundDeath() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundDeath(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect getSoundHurt(DamageSource damageSource) {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundHurt(damageSource), NPC.Metadata.HURT_SOUND);
        }

        public void i(double d, double d2, double d3) {
            Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public boolean isLeashed() {
            return NMSImpl.isLeashed(this.npc, () -> super.isLeashed(), (EntityInsentient)this);
        }

        public void movementTick() {
            if (this.npc != null) {
                this.npc.update();
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
            }
            if (this.npc != null && !this.npc.useMinecraftAI()) {
                Vec3D vec3D;
                if (this.dl()) {
                    this.setHealth(0.0f);
                    return;
                }
                if (this.d < 0) {
                    for (int i = 0; i < this.c.length; ++i) {
                        this.c[i][0] = this.yaw;
                        this.c[i][1] = this.locY();
                    }
                }
                if (++this.d == this.c.length) {
                    this.d = 0;
                }
                this.c[this.d][0] = this.yaw;
                this.c[this.d][1] = this.locY();
                float[][] fArray = NMS.calculateDragonPositions(this.yaw, new double[][]{this.a(0, 1.0f), this.a(5, 1.0f), this.a(10, 1.0f), this.a(12, 1.0f), this.a(14, 1.0f), this.a(16, 1.0f)});
                for (int i = 0; i < this.children.length; ++i) {
                    Vec3D vec3D2 = new Vec3D(this.children[i].locX(), this.children[i].locY(), this.children[i].locZ());
                    this.children[i].setPosition(this.locX() + (double)fArray[i][0], this.locY() + (double)fArray[i][1], this.locZ() + (double)fArray[i][2]);
                    this.children[i].lastX = this.children[i].D = vec3D2.x;
                    this.children[i].lastY = this.children[i].E = vec3D2.y;
                    this.children[i].lastZ = this.children[i].F = vec3D2.z;
                }
                if (this.getRidingPassenger() != null) {
                    this.yaw = this.getRidingPassenger().getBukkitYaw() - 180.0f;
                }
                if ((vec3D = this.getMot()).getX() != 0.0 || vec3D.getY() != 0.0 || vec3D.getZ() != 0.0) {
                    vec3D = vec3D.d(0.98, 0.98, 0.98);
                    if (this.getRidingPassenger() == null) {
                        this.yaw = Util.getDragonYaw((Entity)this.getBukkitEntity(), vec3D.x, vec3D.z);
                    }
                    this.setPosition(this.locX() + vec3D.getX(), this.locY() + vec3D.getY(), this.locZ() + vec3D.getZ());
                    this.setMot(vec3D);
                }
                if (this.npc.hasTrait(EnderDragonTrait.class) && this.npc.getOrAddTrait(EnderDragonTrait.class).isDestroyWalls() && NMSImpl.ENDERDRAGON_CHECK_WALLS != null) {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            this.br |= NMSImpl.ENDERDRAGON_CHECK_WALLS.invoke(this, this.children[i].getBoundingBox());
                            continue;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                }
                if (this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(false)).booleanValue()) {
                    try {
                        KNOCKBACK.invoke(this, this.world.getEntities((net.minecraft.server.v1_16_R3.Entity)this, this.children[6].getBoundingBox().grow(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        KNOCKBACK.invoke(this, this.world.getEntities((net.minecraft.server.v1_16_R3.Entity)this, this.children[7].getBoundingBox().grow(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        HURT.invoke(this, this.world.getEntities((net.minecraft.server.v1_16_R3.Entity)this, this.children[0].getBoundingBox().g(1.0), IEntitySelector.e));
                        HURT.invoke(this, this.world.getEntities((net.minecraft.server.v1_16_R3.Entity)this, this.children[1].getBoundingBox().g(1.0), IEntitySelector.e));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            } else {
                super.movementTick();
            }
        }

        protected boolean n(net.minecraft.server.v1_16_R3.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.n(entity);
        }
    }

    public static class EnderDragonNPC
    extends CraftEnderDragon
    implements ForwardingNPCHolder {
        public EnderDragonNPC(EntityEnderDragonNPC entityEnderDragonNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityEnderDragon)entityEnderDragonNPC);
        }
    }
}

