/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.entity;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.WeakHashMap;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.nms.v1_16_R3.util.PitchableLookControl;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_16_R3.ControllerLook;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.entity.Entity;

public abstract class MobEntityController
extends AbstractEntityController {
    private final Class<?> clazz;
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE = new WeakHashMap();
    private static final MethodHandle UUID_FIELD = NMS.getSetter(net.minecraft.server.v1_16_R3.Entity.class, "uniqueID");

    protected MobEntityController(Class<?> clazz) {
        super(clazz);
        this.clazz = clazz;
    }

    @Override
    protected Entity createEntity(Location location, NPC nPC) {
        EntityInsentient entityInsentient;
        EntityTypes entityTypes = NMSImpl.getEntityType(this.clazz);
        net.minecraft.server.v1_16_R3.Entity entity = this.createEntityFromClass(entityTypes, ((CraftWorld)location.getWorld()).getHandle(), nPC);
        if (entity instanceof EntityInsentient) {
            NMSImpl.clearGoals(nPC, ((EntityInsentient)entity).goalSelector, ((EntityInsentient)entity).targetSelector);
            entityInsentient = (EntityInsentient)entity;
            if (entityInsentient.getControllerLook().getClass() == ControllerLook.class) {
                NMSImpl.setLookControl(entityInsentient, new PitchableLookControl(entityInsentient));
            }
        }
        entity.setPositionRotation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        if (nPC != null) {
            entityInsentient = location.getBlock().getRelative(BlockFace.DOWN).getType();
            if (entityInsentient.isSolid()) {
                entity.setOnGround(true);
            }
            try {
                UUID_FIELD.invoke(entity, nPC.getUniqueId());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (Settings.Setting.USE_SCOREBOARD_TEAMS.asBoolean()) {
                nPC.getOrAddTrait(ScoreboardTrait.class).createTeam(nPC.getUniqueId().toString());
            }
        }
        return entity.getBukkitEntity();
    }

    private net.minecraft.server.v1_16_R3.Entity createEntityFromClass(Object ... objectArray) {
        try {
            return (net.minecraft.server.v1_16_R3.Entity)MobEntityController.getConstructor(this.clazz).newInstance(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Constructor<?> getConstructor(Class<?> clazz) {
        Constructor<?> constructor = CONSTRUCTOR_CACHE.get(clazz);
        if (constructor != null) {
            return constructor;
        }
        try {
            constructor = clazz.getConstructor(EntityTypes.class, World.class, NPC.class);
            CONSTRUCTOR_CACHE.put(clazz, constructor);
            return constructor;
        }
        catch (Exception exception) {
            throw new IllegalStateException("unable to find an entity constructor");
        }
    }
}

