/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_16_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_16_R3.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_16_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_16_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.versioned.PufferFishTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_16_R3.AxisAlignedBB;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.ControllerMove;
import net.minecraft.server.v1_16_R3.DamageSource;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityBoat;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EntityMinecartAbstract;
import net.minecraft.server.v1_16_R3.EntityPose;
import net.minecraft.server.v1_16_R3.EntityPufferFish;
import net.minecraft.server.v1_16_R3.EntitySize;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EnumHand;
import net.minecraft.server.v1_16_R3.EnumInteractionResult;
import net.minecraft.server.v1_16_R3.EnumPistonReaction;
import net.minecraft.server.v1_16_R3.FluidType;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.Items;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.SoundEffect;
import net.minecraft.server.v1_16_R3.Tag;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPufferFish;
import org.bukkit.entity.PufferFish;
import org.bukkit.util.Vector;

public class PufferFishController
extends MobEntityController {
    public PufferFishController() {
        super(EntityPufferFishNPC.class);
    }

    public PufferFish getBukkitEntity() {
        return (PufferFish)super.getBukkitEntity();
    }

    public static class EntityPufferFishNPC
    extends EntityPufferFish
    implements NPCHolder {
        private final CitizensNPC npc;
        private ControllerMove oldMoveController;

        public EntityPufferFishNPC(EntityTypes<? extends EntityPufferFish> entityTypes, World world) {
            this(entityTypes, world, null);
        }

        public EntityPufferFishNPC(EntityTypes<? extends EntityPufferFish> entityTypes, World world, NPC nPC) {
            super(entityTypes, world);
            this.npc = (CitizensNPC)nPC;
            if (nPC != null) {
                this.oldMoveController = this.moveController;
                this.moveController = new ControllerMove((EntityInsentient)this);
            }
        }

        public void a(AxisAlignedBB axisAlignedBB) {
            super.a(NMSBoundingBox.makeBB(this.npc, axisAlignedBB));
        }

        protected void a(double d, boolean bl, IBlockData iBlockData, BlockPosition blockPosition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d, bl, iBlockData, blockPosition);
            }
        }

        public EntitySize a(EntityPose entityPose) {
            if (this.npc == null) {
                return super.a(entityPose);
            }
            return super.a(entityPose).a(1.0f / EntityPufferFishNPC.s(this.getPuffState())).a(0.5f);
        }

        public void a(float f, double d, double d2) {
            NMS.callKnockbackEvent(this.npc, f, d, d2, nPCKnockbackEvent -> super.a((float)nPCKnockbackEvent.getStrength(), nPCKnockbackEvent.getKnockbackVector().getX(), nPCKnockbackEvent.getKnockbackVector().getZ()));
        }

        public boolean a(Tag<FluidType> tag, double d) {
            if (this.npc == null) {
                return super.a(tag, d);
            }
            Vec3D vec3D = this.getMot().add(0.0, 0.0, 0.0);
            boolean bl = super.a(tag, d);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(vec3D);
            }
            return bl;
        }

        public EnumInteractionResult b(EntityHuman entityHuman, EnumHand enumHand) {
            if (this.npc == null || !this.npc.isProtected()) {
                return super.b(entityHuman, enumHand);
            }
            ItemStack itemStack = entityHuman.b(enumHand);
            if (itemStack.getItem() == Items.WATER_BUCKET && this.isAlive()) {
                return EnumInteractionResult.FAIL;
            }
            return super.b(entityHuman, enumHand);
        }

        public boolean b(float f, float f2) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.b(f, f2);
            }
            return false;
        }

        public int bP() {
            return NMS.getFallDistance(this.npc, super.bP());
        }

        public void checkDespawn() {
            if (this.npc == null) {
                super.checkDespawn();
            }
        }

        public void collide(Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.d(nBTTagCompound) : false;
        }

        public float dJ() {
            return NMS.getJumpPower(this.npc, super.dJ());
        }

        public void g(Vec3D vec3D) {
            if (this.npc == null || !this.npc.isFlyable()) {
                if (!NMSImpl.moveFish(this.npc, (EntityInsentient)this, vec3D)) {
                    super.g(vec3D);
                }
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, vec3D);
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((Entity)this, (CraftEntity)new PufferFishNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction getPushReaction() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.IGNORE : super.getPushReaction();
        }

        protected SoundEffect getSoundAmbient() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundAmbient(), NPC.Metadata.AMBIENT_SOUND);
        }

        protected SoundEffect getSoundDeath() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundDeath(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect getSoundHurt(DamageSource damageSource) {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundHurt(damageSource), NPC.Metadata.HURT_SOUND);
        }

        public void i(double d, double d2, double d3) {
            Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public boolean isClimbing() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.isClimbing();
            }
            return false;
        }

        public boolean isLeashed() {
            return NMSImpl.isLeashed(this.npc, () -> super.isLeashed(), (EntityInsentient)this);
        }

        public void mobTick() {
            super.mobTick();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                if (this.npc.useMinecraftAI() && this.moveController != this.oldMoveController) {
                    this.moveController = this.oldMoveController;
                }
                if (!this.npc.useMinecraftAI() && this.moveController == this.oldMoveController) {
                    this.moveController = new EntityMoveControl((EntityLiving)this);
                }
                this.npc.update();
            }
        }

        public void movementTick() {
            boolean bl = this.v;
            int n = this.getPuffState();
            if (this.npc != null) {
                this.v = false;
                this.setPuffState(0);
            }
            super.movementTick();
            if (this.npc != null) {
                this.v = bl;
                this.setPuffState(n);
            }
        }

        protected boolean n(Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.n(entity);
        }

        public void tick() {
            if (this.npc != null) {
                NMSImpl.resetPuffTicks(this);
            }
            super.tick();
            PufferFishTrait pufferFishTrait = null;
            if (this.npc != null && (pufferFishTrait = this.npc.getTraitNullable(PufferFishTrait.class)) != null) {
                this.setPuffState(pufferFishTrait.getPuffState());
            }
        }

        private static float s(int n) {
            switch (n) {
                case 0: {
                    return 0.5f;
                }
                case 1: {
                    return 0.7f;
                }
            }
            return 1.0f;
        }
    }

    public static class PufferFishNPC
    extends CraftPufferFish
    implements ForwardingNPCHolder {
        public PufferFishNPC(EntityPufferFishNPC entityPufferFishNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityPufferFish)entityPufferFishNPC);
        }
    }
}

