/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_16_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_16_R3.AxisAlignedBB;
import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.EntityFallingBlock;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EnumMoveType;
import net.minecraft.server.v1_16_R3.EnumPistonReaction;
import net.minecraft.server.v1_16_R3.FluidType;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.Tag;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.util.Vector;

public class FallingBlockController
extends AbstractEntityController {
    public FallingBlockController() {
        super(EntityFallingBlockNPC.class);
    }

    @Override
    protected Entity createEntity(Location location, NPC nPC) {
        WorldServer worldServer = ((CraftWorld)location.getWorld()).getHandle();
        Block block = CraftMagicNumbers.getBlock((Material)nPC.getItemProvider().get().getType());
        EntityFallingBlockNPC entityFallingBlockNPC = new EntityFallingBlockNPC((World)worldServer, nPC, location.getX(), location.getY(), location.getZ(), block.getBlockData());
        return entityFallingBlockNPC.getBukkitEntity();
    }

    public FallingBlock getBukkitEntity() {
        return (FallingBlock)super.getBukkitEntity();
    }

    public static class EntityFallingBlockNPC
    extends EntityFallingBlock
    implements NPCHolder {
        private final CitizensNPC npc;
        private static final double EPSILON = 0.001;

        public EntityFallingBlockNPC(EntityTypes<? extends EntityFallingBlock> entityTypes, World world) {
            this(entityTypes, world, null);
        }

        public EntityFallingBlockNPC(EntityTypes<? extends EntityFallingBlock> entityTypes, World world, NPC nPC) {
            super(entityTypes, world);
            this.npc = (CitizensNPC)nPC;
        }

        public EntityFallingBlockNPC(World world, NPC nPC, double d, double d2, double d3, IBlockData iBlockData) {
            super(world, d, d2, d3, iBlockData);
            this.npc = (CitizensNPC)nPC;
        }

        public void a(AxisAlignedBB axisAlignedBB) {
            super.a(NMSBoundingBox.makeBB(this.npc, axisAlignedBB));
        }

        public boolean a(Tag<FluidType> tag, double d) {
            if (this.npc == null) {
                return super.a(tag, d);
            }
            Vec3D vec3D = this.getMot().add(0.0, 0.0, 0.0);
            boolean bl = super.a(tag, d);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(vec3D);
            }
            return bl;
        }

        public void collide(net.minecraft.server.v1_16_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.d(nBTTagCompound) : false;
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.server.v1_16_R3.Entity)this, (CraftEntity)new FallingBlockNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction getPushReaction() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.IGNORE : super.getPushReaction();
        }

        public void i(double d, double d2, double d3) {
            Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void tick() {
            if (this.npc != null) {
                this.npc.update();
                Vec3D vec3D = this.getMot();
                if (Math.abs(vec3D.getX()) > 0.001 || Math.abs(vec3D.getY()) > 0.001 || Math.abs(vec3D.getZ()) > 0.001) {
                    vec3D = vec3D.d(0.98, 0.98, 0.98);
                    this.setMot(vec3D);
                    this.move(EnumMoveType.SELF, vec3D);
                }
            } else {
                super.tick();
            }
        }

        public void updateSize() {
            if (this.npc == null) {
                super.updateSize();
            } else {
                NMSImpl.setSize((net.minecraft.server.v1_16_R3.Entity)this, this.justCreated);
            }
        }
    }

    public static class FallingBlockNPC
    extends CraftFallingBlock
    implements NPCHolder {
        private final CitizensNPC npc;

        public FallingBlockNPC(EntityFallingBlockNPC entityFallingBlockNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityFallingBlock)entityFallingBlockNPC);
            this.npc = entityFallingBlockNPC.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

