/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.util;

import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.util.AbstractBlockBreaker;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.EnchantmentManager;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EnumItemSlot;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.MobEffects;
import net.minecraft.server.v1_16_R3.Tag;
import net.minecraft.server.v1_16_R3.TagsFluid;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class CitizensBlockBreaker
extends AbstractBlockBreaker {
    public CitizensBlockBreaker(org.bukkit.entity.Entity entity, Block block, BlockBreaker.BlockBreakerConfiguration blockBreakerConfiguration) {
        super(entity, block, blockBreakerConfiguration);
    }

    private net.minecraft.server.v1_16_R3.ItemStack getCurrentItem() {
        return this.configuration.item() != null ? CraftItemStack.asNMSCopy((ItemStack)this.configuration.item()) : (this.getHandle() instanceof EntityLiving ? ((EntityLiving)this.getHandle()).getEquipment(EnumItemSlot.MAINHAND) : null);
    }

    @Override
    protected float getDamage(int n) {
        return this.getStrength(this.getHandle().world.getType(new BlockPosition(this.x, this.y, this.z))) * (float)(n + 1) * this.configuration.blockStrengthModifier();
    }

    private Entity getHandle() {
        return NMSImpl.getHandle(this.entity);
    }

    private float getStrength(IBlockData iBlockData) {
        float f = iBlockData.h(null, new BlockPosition(0, 0, 0));
        return f < 0.0f ? 0.0f : (!this.isDestroyable(iBlockData) ? 1.0f / f / 100.0f : this.strengthMod(iBlockData) / f / 30.0f);
    }

    private boolean isDestroyable(IBlockData iBlockData) {
        if (iBlockData.isRequiresSpecialTool()) {
            return true;
        }
        net.minecraft.server.v1_16_R3.ItemStack itemStack = this.getCurrentItem();
        return itemStack != null ? itemStack.canDestroySpecialBlock(iBlockData) : false;
    }

    @Override
    protected void setBlockDamage(int n) {
        ((WorldServer)this.getHandle().world).a(this.getHandle().getId(), new BlockPosition(this.x, this.y, this.z), n);
    }

    private float strengthMod(IBlockData iBlockData) {
        net.minecraft.server.v1_16_R3.ItemStack itemStack = this.getCurrentItem();
        float f = itemStack.a(iBlockData);
        if (this.getHandle() instanceof EntityLiving) {
            int n;
            EntityLiving entityLiving = (EntityLiving)this.getHandle();
            if (f > 1.0f && (n = EnchantmentManager.getDigSpeedEnchantmentLevel((EntityLiving)entityLiving)) > 0) {
                f += (float)(n * n + 1);
            }
            if (entityLiving.hasEffect(MobEffects.FASTER_DIG)) {
                f *= 1.0f + (float)(entityLiving.getEffect(MobEffects.FASTER_DIG).getAmplifier() + 1) * 0.2f;
            }
            if (entityLiving.hasEffect(MobEffects.SLOWER_DIG)) {
                float f2 = 1.0f;
                switch (entityLiving.getEffect(MobEffects.SLOWER_DIG).getAmplifier()) {
                    case 0: {
                        f2 = 0.3f;
                        break;
                    }
                    case 1: {
                        f2 = 0.09f;
                        break;
                    }
                    case 2: {
                        f2 = 0.0027f;
                        break;
                    }
                    default: {
                        f2 = 8.1E-4f;
                    }
                }
                f *= f2;
            }
            if (entityLiving.a((Tag)TagsFluid.WATER) && !EnchantmentManager.h((EntityLiving)entityLiving)) {
                f /= 5.0f;
            }
        }
        if (!this.getHandle().isOnGround()) {
            f /= 5.0f;
        }
        return f;
    }
}

