/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_16_R3.util.EntityJumpControl;
import net.citizensnpcs.nms.v1_16_R3.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_16_R3.util.EntityNavigation;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.minecraft.server.v1_16_R3.ControllerJump;
import net.minecraft.server.v1_16_R3.ControllerMove;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.GenericAttributes;
import net.minecraft.server.v1_16_R3.NavigationAbstract;
import net.minecraft.server.v1_16_R3.PathType;

public interface MobAI {
    public org.bukkit.entity.Entity getBukkitEntity();

    public ControllerJump getJumpControl();

    public Map<PathType, Float> getMalus();

    public ControllerMove getMoveControl();

    public NavigationAbstract getNavigation();

    default public float getPathfindingMalus(PathType var1) {
        Map<PathType, Float> malus = this.getMalus();
        return malus.containsKey(var1) ? malus.get(var1).floatValue() : var1.a();
    }

    default public void setPathfindingMalus(PathType water, float oldWaterCost) {
        this.getMalus().put(water, Float.valueOf(oldWaterCost));
    }

    default public void tickAI() {
        this.getJumpControl().b();
        this.getMoveControl().a();
        NavigationAbstract navigation = this.getNavigation();
        if (!NMSImpl.isNavigationFinished(navigation)) {
            NMSImpl.updateNavigation(navigation);
        }
    }

    default public void updatePathfindingRange(float range) {
        ((EntityLiving)NMSImpl.getHandle(this.getBukkitEntity())).getAttributeInstance(GenericAttributes.FOLLOW_RANGE).setValue((double)range);
    }

    public static MobAI from(Entity handle) {
        if (handle instanceof EntityInsentient) {
            final EntityInsentient mob = (EntityInsentient)handle;
            return new MobAI(){

                @Override
                public org.bukkit.entity.Entity getBukkitEntity() {
                    return mob.getBukkitEntity();
                }

                @Override
                public ControllerJump getJumpControl() {
                    return mob.getControllerJump();
                }

                @Override
                public Map<PathType, Float> getMalus() {
                    return null;
                }

                @Override
                public ControllerMove getMoveControl() {
                    return mob.getControllerMove();
                }

                @Override
                public NavigationAbstract getNavigation() {
                    return mob.getNavigation();
                }

                @Override
                public float getPathfindingMalus(PathType pathType) {
                    return mob.a(pathType);
                }

                @Override
                public void setPathfindingMalus(PathType pathType, float f) {
                    mob.a(pathType, f);
                }

                @Override
                public void tickAI() {
                    mob.getEntitySenses().a();
                    NMSImpl.updateNavigation(mob.getNavigation());
                    mob.getControllerMove().a();
                    mob.getControllerLook().a();
                    mob.getControllerJump().b();
                }
            };
        }
        if (handle instanceof MobAI) {
            return (MobAI)handle;
        }
        return null;
    }

    public static interface ForwardingMobAI
    extends MobAI {
        public MobAI getAI();

        @Override
        default public org.bukkit.entity.Entity getBukkitEntity() {
            return this.getAI().getBukkitEntity();
        }

        @Override
        default public ControllerJump getJumpControl() {
            return this.getAI().getJumpControl();
        }

        @Override
        default public Map<PathType, Float> getMalus() {
            return this.getAI().getMalus();
        }

        @Override
        default public ControllerMove getMoveControl() {
            return this.getAI().getMoveControl();
        }

        @Override
        default public NavigationAbstract getNavigation() {
            return this.getAI().getNavigation();
        }
    }

    public static class BasicMobAI
    implements MobAI {
        private final EntityJumpControl controllerJump;
        private final EntityMoveControl controllerMove;
        private final EntityLiving entity;
        private final Map<PathType, Float> malus;
        private final EntityNavigation navigation;

        public BasicMobAI(EntityLiving entityLiving) {
            this.entity = entityLiving;
            NMSImpl.setAttribute(entityLiving, GenericAttributes.FOLLOW_RANGE, Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
            entityLiving.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(0.3);
            this.controllerJump = new EntityJumpControl(entityLiving);
            this.controllerMove = new EntityMoveControl(entityLiving);
            this.navigation = new EntityNavigation(entityLiving, entityLiving.world);
            this.malus = Maps.newEnumMap(PathType.class);
        }

        @Override
        public org.bukkit.entity.Entity getBukkitEntity() {
            return this.entity.getBukkitEntity();
        }

        @Override
        public ControllerJump getJumpControl() {
            return this.controllerJump;
        }

        @Override
        public Map<PathType, Float> getMalus() {
            return this.malus;
        }

        @Override
        public ControllerMove getMoveControl() {
            return this.controllerMove;
        }

        @Override
        public NavigationAbstract getNavigation() {
            return this.navigation;
        }
    }
}

