/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.datafixers.util.Pair;
import com.mojang.util.UUIDTypeAdapter;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.astar.pathfinder.DoorExaminer;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.gui.ForwardingInventory;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitInfo;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.api.util.EntityDim;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.nms.v1_16_R3.entity.ArmorStandController;
import net.citizensnpcs.nms.v1_16_R3.entity.BatController;
import net.citizensnpcs.nms.v1_16_R3.entity.BeeController;
import net.citizensnpcs.nms.v1_16_R3.entity.BlazeController;
import net.citizensnpcs.nms.v1_16_R3.entity.CatController;
import net.citizensnpcs.nms.v1_16_R3.entity.CaveSpiderController;
import net.citizensnpcs.nms.v1_16_R3.entity.ChickenController;
import net.citizensnpcs.nms.v1_16_R3.entity.CodController;
import net.citizensnpcs.nms.v1_16_R3.entity.CowController;
import net.citizensnpcs.nms.v1_16_R3.entity.CreeperController;
import net.citizensnpcs.nms.v1_16_R3.entity.DolphinController;
import net.citizensnpcs.nms.v1_16_R3.entity.DrownedController;
import net.citizensnpcs.nms.v1_16_R3.entity.EnderDragonController;
import net.citizensnpcs.nms.v1_16_R3.entity.EndermanController;
import net.citizensnpcs.nms.v1_16_R3.entity.EndermiteController;
import net.citizensnpcs.nms.v1_16_R3.entity.EntityHumanNPC;
import net.citizensnpcs.nms.v1_16_R3.entity.EvokerController;
import net.citizensnpcs.nms.v1_16_R3.entity.FoxController;
import net.citizensnpcs.nms.v1_16_R3.entity.GhastController;
import net.citizensnpcs.nms.v1_16_R3.entity.GiantController;
import net.citizensnpcs.nms.v1_16_R3.entity.GuardianController;
import net.citizensnpcs.nms.v1_16_R3.entity.GuardianElderController;
import net.citizensnpcs.nms.v1_16_R3.entity.HoglinController;
import net.citizensnpcs.nms.v1_16_R3.entity.HorseController;
import net.citizensnpcs.nms.v1_16_R3.entity.HorseDonkeyController;
import net.citizensnpcs.nms.v1_16_R3.entity.HorseMuleController;
import net.citizensnpcs.nms.v1_16_R3.entity.HorseSkeletonController;
import net.citizensnpcs.nms.v1_16_R3.entity.HorseZombieController;
import net.citizensnpcs.nms.v1_16_R3.entity.HumanController;
import net.citizensnpcs.nms.v1_16_R3.entity.IllusionerController;
import net.citizensnpcs.nms.v1_16_R3.entity.IronGolemController;
import net.citizensnpcs.nms.v1_16_R3.entity.LlamaController;
import net.citizensnpcs.nms.v1_16_R3.entity.MagmaCubeController;
import net.citizensnpcs.nms.v1_16_R3.entity.MushroomCowController;
import net.citizensnpcs.nms.v1_16_R3.entity.OcelotController;
import net.citizensnpcs.nms.v1_16_R3.entity.PandaController;
import net.citizensnpcs.nms.v1_16_R3.entity.ParrotController;
import net.citizensnpcs.nms.v1_16_R3.entity.PhantomController;
import net.citizensnpcs.nms.v1_16_R3.entity.PigController;
import net.citizensnpcs.nms.v1_16_R3.entity.PigZombieController;
import net.citizensnpcs.nms.v1_16_R3.entity.PiglinBruteController;
import net.citizensnpcs.nms.v1_16_R3.entity.PiglinController;
import net.citizensnpcs.nms.v1_16_R3.entity.PillagerController;
import net.citizensnpcs.nms.v1_16_R3.entity.PolarBearController;
import net.citizensnpcs.nms.v1_16_R3.entity.PufferFishController;
import net.citizensnpcs.nms.v1_16_R3.entity.RabbitController;
import net.citizensnpcs.nms.v1_16_R3.entity.RavagerController;
import net.citizensnpcs.nms.v1_16_R3.entity.SalmonController;
import net.citizensnpcs.nms.v1_16_R3.entity.SheepController;
import net.citizensnpcs.nms.v1_16_R3.entity.ShulkerController;
import net.citizensnpcs.nms.v1_16_R3.entity.SilverfishController;
import net.citizensnpcs.nms.v1_16_R3.entity.SkeletonController;
import net.citizensnpcs.nms.v1_16_R3.entity.SkeletonStrayController;
import net.citizensnpcs.nms.v1_16_R3.entity.SkeletonWitherController;
import net.citizensnpcs.nms.v1_16_R3.entity.SlimeController;
import net.citizensnpcs.nms.v1_16_R3.entity.SnowmanController;
import net.citizensnpcs.nms.v1_16_R3.entity.SpiderController;
import net.citizensnpcs.nms.v1_16_R3.entity.SquidController;
import net.citizensnpcs.nms.v1_16_R3.entity.StriderController;
import net.citizensnpcs.nms.v1_16_R3.entity.TraderLlamaController;
import net.citizensnpcs.nms.v1_16_R3.entity.TropicalFishController;
import net.citizensnpcs.nms.v1_16_R3.entity.TurtleController;
import net.citizensnpcs.nms.v1_16_R3.entity.VexController;
import net.citizensnpcs.nms.v1_16_R3.entity.VillagerController;
import net.citizensnpcs.nms.v1_16_R3.entity.VindicatorController;
import net.citizensnpcs.nms.v1_16_R3.entity.WanderingTraderController;
import net.citizensnpcs.nms.v1_16_R3.entity.WitchController;
import net.citizensnpcs.nms.v1_16_R3.entity.WitherController;
import net.citizensnpcs.nms.v1_16_R3.entity.WolfController;
import net.citizensnpcs.nms.v1_16_R3.entity.ZoglinController;
import net.citizensnpcs.nms.v1_16_R3.entity.ZombieController;
import net.citizensnpcs.nms.v1_16_R3.entity.ZombieHuskController;
import net.citizensnpcs.nms.v1_16_R3.entity.ZombieVillagerController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.AreaEffectCloudController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.BoatController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.DragonFireballController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.EggController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.EnderCrystalController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.EnderPearlController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.EnderSignalController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.EvokerFangsController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.ExperienceOrbController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.FallingBlockController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.FireworkController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.FishingHookController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.ItemController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.ItemFrameController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.LargeFireballController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.LeashController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.LlamaSpitController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.MinecartChestController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.MinecartCommandController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.MinecartFurnaceController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.MinecartHopperController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.MinecartRideableController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.MinecartTNTController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.PaintingController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.ShulkerBulletController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.SmallFireballController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.SnowballController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.SpectralArrowController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.TNTPrimedController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.ThrownExpBottleController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.ThrownPotionController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.ThrownTridentController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.TippedArrowController;
import net.citizensnpcs.nms.v1_16_R3.entity.nonliving.WitherSkullController;
import net.citizensnpcs.nms.v1_16_R3.util.CitizensBlockBreaker;
import net.citizensnpcs.nms.v1_16_R3.util.CustomEntityRegistry;
import net.citizensnpcs.nms.v1_16_R3.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_16_R3.util.MobAI;
import net.citizensnpcs.nms.v1_16_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_16_R3.util.PlayerAnimationImpl;
import net.citizensnpcs.nms.v1_16_R3.util.PlayerlistTracker;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.trait.versioned.BeeTrait;
import net.citizensnpcs.trait.versioned.BossBarTrait;
import net.citizensnpcs.trait.versioned.CatTrait;
import net.citizensnpcs.trait.versioned.EnderDragonTrait;
import net.citizensnpcs.trait.versioned.FoxTrait;
import net.citizensnpcs.trait.versioned.LlamaTrait;
import net.citizensnpcs.trait.versioned.MushroomCowTrait;
import net.citizensnpcs.trait.versioned.PandaTrait;
import net.citizensnpcs.trait.versioned.ParrotTrait;
import net.citizensnpcs.trait.versioned.PhantomTrait;
import net.citizensnpcs.trait.versioned.PiglinTrait;
import net.citizensnpcs.trait.versioned.PolarBearTrait;
import net.citizensnpcs.trait.versioned.PufferFishTrait;
import net.citizensnpcs.trait.versioned.ShulkerTrait;
import net.citizensnpcs.trait.versioned.SnowmanTrait;
import net.citizensnpcs.trait.versioned.SpellcasterTrait;
import net.citizensnpcs.trait.versioned.TropicalFishTrait;
import net.citizensnpcs.trait.versioned.VillagerTrait;
import net.citizensnpcs.util.EmptyChannel;
import net.citizensnpcs.util.EntityPacketTracker;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.NMSBridge;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_16_R3.AdvancementDataPlayer;
import net.minecraft.server.v1_16_R3.AttributeBase;
import net.minecraft.server.v1_16_R3.AttributeMapBase;
import net.minecraft.server.v1_16_R3.AttributeModifiable;
import net.minecraft.server.v1_16_R3.AttributeProvider;
import net.minecraft.server.v1_16_R3.AxisAlignedBB;
import net.minecraft.server.v1_16_R3.BehaviorController;
import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.BossBattleServer;
import net.minecraft.server.v1_16_R3.ChatComponentText;
import net.minecraft.server.v1_16_R3.ChatMessage;
import net.minecraft.server.v1_16_R3.ChunkProviderServer;
import net.minecraft.server.v1_16_R3.Container;
import net.minecraft.server.v1_16_R3.ContainerAccess;
import net.minecraft.server.v1_16_R3.ContainerAnvil;
import net.minecraft.server.v1_16_R3.Containers;
import net.minecraft.server.v1_16_R3.ControllerJump;
import net.minecraft.server.v1_16_R3.ControllerLook;
import net.minecraft.server.v1_16_R3.ControllerMove;
import net.minecraft.server.v1_16_R3.ControllerMoveFlying;
import net.minecraft.server.v1_16_R3.DamageSource;
import net.minecraft.server.v1_16_R3.DataWatcherObject;
import net.minecraft.server.v1_16_R3.Enchantment;
import net.minecraft.server.v1_16_R3.EnchantmentManager;
import net.minecraft.server.v1_16_R3.Enchantments;
import net.minecraft.server.v1_16_R3.EnderDragonBattle;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityBird;
import net.minecraft.server.v1_16_R3.EntityCat;
import net.minecraft.server.v1_16_R3.EntityEnderDragon;
import net.minecraft.server.v1_16_R3.EntityEnderman;
import net.minecraft.server.v1_16_R3.EntityFish;
import net.minecraft.server.v1_16_R3.EntityFishSchool;
import net.minecraft.server.v1_16_R3.EntityFishingHook;
import net.minecraft.server.v1_16_R3.EntityHorse;
import net.minecraft.server.v1_16_R3.EntityHorseAbstract;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EntityMinecartAbstract;
import net.minecraft.server.v1_16_R3.EntityPanda;
import net.minecraft.server.v1_16_R3.EntityPiglin;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EntityPolarBear;
import net.minecraft.server.v1_16_R3.EntityPose;
import net.minecraft.server.v1_16_R3.EntityPufferFish;
import net.minecraft.server.v1_16_R3.EntityRabbit;
import net.minecraft.server.v1_16_R3.EntityShulker;
import net.minecraft.server.v1_16_R3.EntitySize;
import net.minecraft.server.v1_16_R3.EntityTameableAnimal;
import net.minecraft.server.v1_16_R3.EntityTrackerEntry;
import net.minecraft.server.v1_16_R3.EntityTurtle;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EntityWither;
import net.minecraft.server.v1_16_R3.EnumItemSlot;
import net.minecraft.server.v1_16_R3.EnumMonsterType;
import net.minecraft.server.v1_16_R3.EnumMoveType;
import net.minecraft.server.v1_16_R3.Fluid;
import net.minecraft.server.v1_16_R3.GenericAttributes;
import net.minecraft.server.v1_16_R3.IBlockAccess;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.IInventory;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.MathHelper;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.MinecraftServer;
import net.minecraft.server.v1_16_R3.MobEffects;
import net.minecraft.server.v1_16_R3.Navigation;
import net.minecraft.server.v1_16_R3.NavigationAbstract;
import net.minecraft.server.v1_16_R3.NavigationSpider;
import net.minecraft.server.v1_16_R3.NetworkManager;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntity;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_16_R3.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_16_R3.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_16_R3.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_16_R3.PathEntity;
import net.minecraft.server.v1_16_R3.PathPoint;
import net.minecraft.server.v1_16_R3.PathType;
import net.minecraft.server.v1_16_R3.PathfinderGoalSelector;
import net.minecraft.server.v1_16_R3.PlayerChunkMap;
import net.minecraft.server.v1_16_R3.ScoreboardTeam;
import net.minecraft.server.v1_16_R3.Slot;
import net.minecraft.server.v1_16_R3.SoundEffect;
import net.minecraft.server.v1_16_R3.Tag;
import net.minecraft.server.v1_16_R3.TagsFluid;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.VoxelShape;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftSound;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_16_R3.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftWither;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wither;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public class NMSImpl
implements NMSBridge {
    private static final MethodHandle ADVANCEMENT_PLAYER_FIELD = NMS.getFinalSetter(EntityPlayer.class, "advancementDataPlayer");
    private static final MethodHandle ATTRIBUTE_MAP = NMS.getGetter(AttributeMapBase.class, "d");
    private static final MethodHandle ATTRIBUTE_PROVIDER_MAP = NMS.getGetter(AttributeProvider.class, "a");
    private static final MethodHandle ATTRIBUTE_PROVIDER_MAP_SETTER = NMS.getFinalSetter(AttributeProvider.class, "a");
    private static final Set<EntityType> BAD_CONTROLLER_LOOK = EnumSet.of(EntityType.POLAR_BEAR, new EntityType[]{EntityType.BEE, EntityType.SILVERFISH, EntityType.SHULKER, EntityType.ENDERMITE, EntityType.ENDER_DRAGON, EntityType.BAT, EntityType.SLIME, EntityType.DOLPHIN, EntityType.MAGMA_CUBE, EntityType.HORSE, EntityType.GHAST, EntityType.SHULKER, EntityType.PHANTOM});
    private static final MethodHandle BEHAVIOR_MAP = NMS.getGetter(BehaviorController.class, "e");
    private static final MethodHandle BUKKITENTITY_FIELD_SETTER = NMS.getSetter(Entity.class, "bukkitEntity");
    private static final MethodHandle CHUNKMAP_UPDATE_PLAYER_STATUS = NMS.getMethodHandle(PlayerChunkMap.class, "a", true, EntityPlayer.class, Boolean.TYPE);
    private static final Map<Class<?>, EntityTypes<?>> CITIZENS_ENTITY_TYPES = Maps.newHashMap();
    private static final MethodHandle CRAFT_BOSSBAR_HANDLE_FIELD = NMS.getSetter(CraftBossBar.class, "handle");
    private static MethodHandle CRAFTSOUND_GETSOUND = NMS.getMethodHandle(CraftSound.class, "getSound", false, Sound.class);
    private static final float DEFAULT_SPEED = 1.0f;
    private static final MethodHandle ENDERDRAGON_BATTLE_FIELD = NMS.getGetter(EntityEnderDragon.class, "bF");
    public static MethodHandle ENDERDRAGON_CHECK_WALLS = NMS.getFirstMethodHandleWithReturnType(EntityEnderDragon.class, true, Boolean.TYPE, AxisAlignedBB.class);
    private static DataWatcherObject<Boolean> ENDERMAN_ANGRY = null;
    private static final MethodHandle ENTITY_FISH_NUM_IN_SCHOOL = NMS.getSetter(EntityFishSchool.class, "c", false);
    private static final MethodHandle ENTITY_GET_SOUND_FALL = NMS.getMethodHandle(EntityLiving.class, "getSoundFall", true, Integer.TYPE);
    private static MethodHandle ENTITY_NAVIGATION = NMS.getFirstSetter(EntityInsentient.class, Navigation.class);
    private static CustomEntityRegistry ENTITY_REGISTRY;
    private static final MethodHandle ENTITY_SETPOSE_METHOD;
    private static final MethodHandle ENTITY_TRACKER_ENTRY_GETTER;
    private static final MethodHandle FISHING_HOOK_HOOKED;
    private static final MethodHandle FISHING_HOOK_HOOKED_SETTER;
    private static final MethodHandle FLYING_MOVECONTROL_FLOAT_GETTER;
    private static final MethodHandle FLYING_MOVECONTROL_FLOAT_SETTER;
    private static final Location FROM_LOCATION;
    private static final MethodHandle GOAL_SET_FIELD;
    private static final MethodHandle HEAD_HEIGHT;
    private static final MethodHandle HEAD_HEIGHT_METHOD;
    private static final MethodHandle JUMP_FIELD;
    private static final MethodHandle LOOK_CONTROL_SETTER;
    private static final MethodHandle MAKE_REQUEST;
    private static MethodHandle MOVE_CONTROLLER_MOVING;
    private static final MethodHandle NAVIGATION_A;
    private static final MethodHandle NAVIGATION_S;
    private static final MethodHandle NAVIGATION_WORLD_FIELD;
    public static final Location PACKET_CACHE_LOCATION;
    private static final MethodHandle PLAYER_CHUNK_MAP_VIEW_DISTANCE_GETTER;
    private static final MethodHandle PLAYER_CHUNK_MAP_VIEW_DISTANCE_SETTER;
    private static final MethodHandle PUFFERFISH_C;
    private static final MethodHandle PUFFERFISH_D;
    private static final MethodHandle RABBIT_DATAWATCHER_FIELD;
    private static final Random RANDOM;
    private static MethodHandle SET_PROFILE_METHOD;
    private static final MethodHandle SIZE_FIELD_GETTER;
    private static final MethodHandle SIZE_FIELD_SETTER;
    private static Field SKULL_PROFILE_FIELD;
    private static MethodHandle SOUNDEFFECT_KEY;
    private static MethodHandle TEAM_FIELD;

    public NMSImpl() {
        this.loadEntityTypes();
    }

    @Override
    public void activate(org.bukkit.entity.Entity entity) {
        NMSImpl.getHandle((org.bukkit.entity.Entity)entity).activatedTick = MinecraftServer.currentTick;
    }

    @Override
    public boolean addEntityToWorld(org.bukkit.entity.Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        int n = -1;
        PlayerChunkMap playerChunkMap = null;
        try {
            if (entity instanceof Player) {
                playerChunkMap = ((ChunkProviderServer)NMSImpl.getHandle((org.bukkit.entity.Entity)entity).world.getChunkProvider()).playerChunkMap;
                n = PLAYER_CHUNK_MAP_VIEW_DISTANCE_GETTER.invoke(playerChunkMap);
                PLAYER_CHUNK_MAP_VIEW_DISTANCE_SETTER.invoke(playerChunkMap, -1);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        boolean bl = NMSImpl.getHandle((org.bukkit.entity.Entity)entity).world.addEntity(NMSImpl.getHandle(entity), spawnReason);
        try {
            if (playerChunkMap != null) {
                PLAYER_CHUNK_MAP_VIEW_DISTANCE_SETTER.invoke(playerChunkMap, n);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl;
    }

    @Override
    public void addOrRemoveFromPlayerList(org.bukkit.entity.Entity entity, boolean bl) {
        if (entity == null) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)NMSImpl.getHandle(entity);
        if (entityPlayer.world == null) {
            return;
        }
        List list = entityPlayer.world.getPlayers();
        boolean bl2 = false;
        if (bl && list.contains(entityPlayer)) {
            list.remove(entityPlayer);
            bl2 = true;
        } else if (!bl && !list.contains(entityPlayer)) {
            list.add(entityPlayer);
            bl2 = true;
        }
        if (!bl2) {
            return;
        }
        try {
            CHUNKMAP_UPDATE_PLAYER_STATUS.invoke(((WorldServer)entityPlayer.world).getChunkProvider().playerChunkMap, entityPlayer, !bl);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void attack(LivingEntity livingEntity, LivingEntity livingEntity2) {
        int n;
        boolean bl;
        EntityLiving entityLiving = NMSImpl.getHandle(livingEntity);
        EntityLiving entityLiving2 = NMSImpl.getHandle(livingEntity2);
        if (entityLiving instanceof EntityPlayer) {
            ((EntityPlayer)entityLiving).attack((Entity)entityLiving2);
            PlayerAnimation.ARM_SWING.play((Player)entityLiving.getBukkitEntity());
            return;
        }
        if (entityLiving instanceof EntityInsentient) {
            ((EntityInsentient)entityLiving).attackEntity((Entity)entityLiving2);
            return;
        }
        AttributeModifiable attributeModifiable = entityLiving.getAttributeInstance(GenericAttributes.ATTACK_DAMAGE);
        float f = (float)(attributeModifiable == null ? 1.0 : attributeModifiable.getValue());
        int n2 = 0;
        if (entityLiving2 instanceof EntityLiving) {
            f += EnchantmentManager.a((ItemStack)entityLiving.getItemInMainHand(), (EnumMonsterType)entityLiving2.getMonsterType());
            n2 += EnchantmentManager.a((Enchantment)Enchantments.KNOCKBACK, (EntityLiving)entityLiving);
        }
        if (!(bl = entityLiving2.damageEntity(DamageSource.mobAttack((EntityLiving)entityLiving), f))) {
            return;
        }
        if (n2 > 0) {
            entityLiving2.f(-Math.sin((double)entityLiving.yaw * Math.PI / 180.0) * (double)n2 * 0.5, 0.1, Math.cos((double)entityLiving.yaw * Math.PI / 180.0) * (double)n2 * 0.5);
            entityLiving.setMot(entityLiving.getMot().d(0.6, 1.0, 0.6));
        }
        if ((n = EnchantmentManager.getFireAspectEnchantmentLevel((EntityLiving)entityLiving)) > 0) {
            entityLiving2.setOnFire(n * 4);
        }
    }

    @Override
    public void cancelMoveDestination(org.bukkit.entity.Entity entity) {
        Entity entity2 = NMSImpl.getHandle(entity);
        MobAI mobAI = MobAI.from(entity2);
        if (mobAI.getMoveControl() instanceof EntityMoveControl) {
            ((EntityMoveControl)mobAI.getMoveControl()).f = false;
        } else {
            try {
                MOVE_CONTROLLER_MOVING.invoke(mobAI.getMoveControl(), null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public EntityPacketTracker createPacketTracker(org.bukkit.entity.Entity entity, final EntityPacketTracker.PacketAggregator packetAggregator) {
        final Entity entity2 = NMSImpl.getHandle(entity);
        final Set set = Sets.newIdentityHashSet();
        final EntityTrackerEntry entityTrackerEntry = new EntityTrackerEntry((WorldServer)entity2.world, entity2, entity2.getEntityType().getUpdateInterval(), entity2.getEntityType().isDeltaTracking(), packetAggregator::send, set);
        final EnumMap enumMap = Maps.newEnumMap(EnumItemSlot.class);
        return new EntityPacketTracker(){

            @Override
            public void link(Player player) {
                EntityPlayer entityPlayer = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
                entity2.dead = false;
                entityTrackerEntry.b(entityPlayer);
                set.add(entityPlayer);
                packetAggregator.add(entityPlayer.getUniqueID(), object -> entityPlayer.playerConnection.sendPacket((Packet)object));
                entity2.dead = true;
            }

            @Override
            public void run() {
                if (entity2 instanceof EntityLiving) {
                    boolean bl = false;
                    EntityLiving entityLiving = (EntityLiving)entity2;
                    for (EnumItemSlot enumItemSlot : EnumItemSlot.values()) {
                        ItemStack itemStack = enumMap.getOrDefault(enumItemSlot, ItemStack.b);
                        ItemStack itemStack2 = entityLiving.getEquipment(enumItemSlot);
                        if (!bl && !ItemStack.matches((ItemStack)itemStack, (ItemStack)itemStack2)) {
                            bl = true;
                        }
                        enumMap.put(enumItemSlot, itemStack2);
                    }
                    if (bl) {
                        ArrayList arrayList = Lists.newArrayList();
                        for (EnumItemSlot enumItemSlot : EnumItemSlot.values()) {
                            arrayList.add(Pair.of((Object)enumItemSlot, (Object)((ItemStack)enumMap.get(enumItemSlot))));
                        }
                        packetAggregator.send(new PacketPlayOutEntityEquipment(entity2.getId(), (List)arrayList));
                    }
                }
                entityTrackerEntry.a();
            }

            @Override
            public void unlink(Player player) {
                EntityPlayer entityPlayer = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
                entityTrackerEntry.a(entityPlayer);
                set.remove(entityPlayer);
                packetAggregator.removeConnection(entityPlayer.getUniqueID());
            }

            @Override
            public void unlinkAll(Consumer<Player> consumer) {
                entity2.die();
                for (EntityPlayer entityPlayer : Lists.newArrayList((Iterable)set)) {
                    CraftPlayer craftPlayer = entityPlayer.getBukkitEntity();
                    this.unlink((Player)craftPlayer);
                    if (consumer == null) continue;
                    consumer.accept((Player)craftPlayer);
                }
                set.clear();
            }
        };
    }

    @Override
    public GameProfile fillProfileProperties(GameProfile gameProfile, boolean bl) {
        if (Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("NMS.fillProfileProperties cannot be invoked from the main thread.");
        }
        MinecraftSessionService minecraftSessionService = ((CraftServer)Bukkit.getServer()).getServer().getMinecraftSessionService();
        if (!(minecraftSessionService instanceof YggdrasilMinecraftSessionService)) {
            return minecraftSessionService.fillProfileProperties(gameProfile, bl);
        }
        YggdrasilAuthenticationService yggdrasilAuthenticationService = ((YggdrasilMinecraftSessionService)minecraftSessionService).getAuthenticationService();
        URL uRL = HttpAuthenticationService.constantURL((String)(this.getAuthServerBaseUrl() + UUIDTypeAdapter.fromUUID((UUID)gameProfile.getId())));
        MinecraftProfilePropertiesResponse minecraftProfilePropertiesResponse = MAKE_REQUEST.invoke(yggdrasilAuthenticationService, uRL = HttpAuthenticationService.concatenateURL((URL)uRL, (String)("unsigned=" + !bl)), null, MinecraftProfilePropertiesResponse.class);
        if (minecraftProfilePropertiesResponse == null) {
            return gameProfile;
        }
        GameProfile gameProfile2 = new GameProfile(minecraftProfilePropertiesResponse.getId(), minecraftProfilePropertiesResponse.getName());
        gameProfile2.getProperties().putAll((Multimap)minecraftProfilePropertiesResponse.getProperties());
        gameProfile.getProperties().putAll((Multimap)minecraftProfilePropertiesResponse.getProperties());
        return gameProfile2;
    }

    public String getAuthServerBaseUrl() {
        return Settings.Setting.AUTH_SERVER_URL.asString();
    }

    @Override
    public BlockBreaker getBlockBreaker(org.bukkit.entity.Entity entity, org.bukkit.block.Block block, BlockBreaker.BlockBreakerConfiguration blockBreakerConfiguration) {
        return new CitizensBlockBreaker(entity, block, blockBreakerConfiguration);
    }

    public BossBar getBossBar(org.bukkit.entity.Entity entity) {
        Object object;
        BossBattleServer bossBattleServer = null;
        try {
            if (entity.getType() == EntityType.WITHER) {
                bossBattleServer = ((EntityWither)NMSImpl.getHandle((org.bukkit.entity.Entity)entity)).bossBattle;
            } else if (entity.getType() == EntityType.ENDER_DRAGON) {
                object = ENDERDRAGON_BATTLE_FIELD.invoke(NMSImpl.getHandle(entity));
                if (object == null) {
                    return null;
                }
                bossBattleServer = ((EnderDragonBattle)object).bossBattle;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (bossBattleServer == null) {
            return null;
        }
        object = Bukkit.createBossBar((String)"", (BarColor)BarColor.BLUE, (BarStyle)BarStyle.SEGMENTED_10, (BarFlag[])new BarFlag[0]);
        try {
            CRAFT_BOSSBAR_HANDLE_FIELD.invoke((BossBar)object, bossBattleServer);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return object;
    }

    @Override
    public BoundingBox getBoundingBox(org.bukkit.entity.Entity entity) {
        return NMSBoundingBox.wrap(NMSImpl.getHandle(entity).getBoundingBox());
    }

    @Override
    public BoundingBox getCollisionBox(org.bukkit.block.Block block) {
        WorldServer worldServer = ((CraftWorld)block.getWorld()).getHandle();
        VoxelShape voxelShape = ((CraftBlock)block).getNMS().getCollisionShape((IBlockAccess)worldServer, ((CraftBlock)block).getPosition());
        return voxelShape.isEmpty() ? BoundingBox.EMPTY : NMSBoundingBox.wrap(voxelShape.getBoundingBox());
    }

    @Override
    public Location getDestination(org.bukkit.entity.Entity entity) {
        ControllerMove controllerMove;
        Entity entity2 = NMSImpl.getHandle(entity);
        Object object = entity2 instanceof EntityInsentient ? ((EntityInsentient)entity2).getControllerMove() : (controllerMove = entity2 instanceof MobAI ? ((MobAI)entity2).getMoveControl() : null);
        if (controllerMove == null || !controllerMove.b()) {
            return null;
        }
        return new Location(entity.getWorld(), controllerMove.d(), controllerMove.e(), controllerMove.f());
    }

    @Override
    public GameProfileRepository getGameProfileRepository() {
        return ((CraftServer)Bukkit.getServer()).getServer().getGameProfileRepository();
    }

    @Override
    public float getHeadYaw(org.bukkit.entity.Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return entity.getLocation().getYaw();
        }
        return NMSImpl.getHandle((LivingEntity)entity).getHeadRotation();
    }

    @Override
    public float getHorizontalMovement(org.bukkit.entity.Entity entity) {
        if (!entity.getType().isAlive()) {
            return Float.NaN;
        }
        EntityLiving entityLiving = NMSImpl.getHandle((LivingEntity)entity);
        return entityLiving.aT;
    }

    @Override
    public NPC getNPC(org.bukkit.entity.Entity entity) {
        Entity entity2 = NMSImpl.getHandle(entity);
        return entity2 instanceof NPCHolder ? ((NPCHolder)entity2).getNPC() : null;
    }

    @Override
    public EntityPacketTracker getPacketTracker(org.bukkit.entity.Entity entity) {
        WorldServer worldServer = (WorldServer)NMSImpl.getHandle(entity).getWorld();
        final PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)worldServer.getChunkProvider().playerChunkMap.trackedEntities.get(entity.getEntityId());
        if (entityTracker == null) {
            return null;
        }
        return new EntityPacketTracker(){

            @Override
            public void link(Player player) {
                entityTracker.updatePlayer((EntityPlayer)NMSImpl.getHandle((LivingEntity)player));
            }

            @Override
            public void run() {
            }

            @Override
            public void unlink(Player player) {
                entityTracker.clear((EntityPlayer)NMSImpl.getHandle((LivingEntity)player));
            }

            @Override
            public void unlinkAll(Consumer<Player> consumer) {
                entityTracker.a();
            }
        };
    }

    @Override
    public List<org.bukkit.entity.Entity> getPassengers(org.bukkit.entity.Entity entity) {
        Entity entity2 = NMSImpl.getHandle(entity);
        if (entity2 == null || entity2.passengers == null) {
            return Lists.newArrayList();
        }
        return Lists.transform((List)entity2.passengers, Entity::getBukkitEntity);
    }

    @Override
    public GameProfile getProfile(Player player) {
        return ((EntityHuman)NMSImpl.getHandle((LivingEntity)player)).getProfile();
    }

    @Override
    public GameProfile getProfile(SkullMeta skullMeta) {
        if (SKULL_PROFILE_FIELD == null && (SKULL_PROFILE_FIELD = NMS.getField(skullMeta.getClass(), "profile", false)) == null) {
            return null;
        }
        try {
            return (GameProfile)SKULL_PROFILE_FIELD.get(skullMeta);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getSoundPath(Sound sound) {
        try {
            if (CRAFTSOUND_GETSOUND != null) {
                String string = CRAFTSOUND_GETSOUND.invoke(sound);
                if (string == null) {
                    throw new CommandException("citizens.commands.npc.sound.invalid-sound");
                }
                return string;
            }
            SoundEffect soundEffect = CraftSound.getSoundEffect((Sound)sound);
            if (soundEffect == null) {
                throw new CommandException("citizens.commands.npc.sound.invalid-sound");
            }
            MinecraftKey minecraftKey = SOUNDEFFECT_KEY.invoke(soundEffect);
            return minecraftKey.getKey();
        }
        catch (Throwable throwable) {
            throw new CommandException("citizens.commands.npc.sound.invalid-sound");
        }
    }

    @Override
    public org.bukkit.entity.Entity getSource(BlockCommandSender blockCommandSender) {
        Entity entity = ((CraftBlockCommandSender)blockCommandSender).getWrapper().getEntity();
        return entity != null ? entity.getBukkitEntity() : null;
    }

    @Override
    public float getSpeedFor(NPC nPC) {
        if (!nPC.isSpawned() || !(nPC.getEntity() instanceof LivingEntity)) {
            return 1.0f;
        }
        EntityLiving entityLiving = NMSImpl.getHandle((LivingEntity)nPC.getEntity());
        if (entityLiving == null) {
            // empty if block
        }
        return 1.0f;
    }

    @Override
    public float getStepHeight(org.bukkit.entity.Entity entity) {
        return NMSImpl.getHandle((org.bukkit.entity.Entity)entity).G;
    }

    @Override
    public MCNavigationStrategy.MCNavigator getTargetNavigator(org.bukkit.entity.Entity entity, Iterable<Vector> iterable, NavigatorParameters navigatorParameters) {
        ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.transform(iterable, vector -> new PathPoint(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ())));
        PathPoint pathPoint = arrayList.size() > 0 ? (PathPoint)arrayList.get(arrayList.size() - 1) : null;
        PathEntity pathEntity = new PathEntity((List)arrayList, pathPoint != null ? new BlockPosition(pathPoint.a, pathPoint.b, pathPoint.c) : null, true);
        return this.getTargetNavigator(entity, navigatorParameters, (NavigationAbstract navigationAbstract) -> navigationAbstract.a(pathEntity, (double)navigatorParameters.speed()));
    }

    @Override
    public MCNavigationStrategy.MCNavigator getTargetNavigator(org.bukkit.entity.Entity entity, Location location, NavigatorParameters navigatorParameters) {
        return this.getTargetNavigator(entity, navigatorParameters, (NavigationAbstract navigationAbstract) -> navigationAbstract.a(location.getX(), location.getY(), location.getZ(), (double)navigatorParameters.speed()));
    }

    private MCNavigationStrategy.MCNavigator getTargetNavigator(final org.bukkit.entity.Entity entity, final NavigatorParameters navigatorParameters, final Function<NavigationAbstract, Boolean> function) {
        float f;
        final Entity entity2 = NMSImpl.getHandle(entity);
        entity2.setOnGround(true);
        final NavigationAbstract navigationAbstract = NMSImpl.getNavigation(entity);
        float f2 = f = entity2 instanceof EntityPlayer ? ((MobAI)entity2).getPathfindingMalus(PathType.WATER) : ((EntityInsentient)entity2).a(PathType.WATER);
        if (navigatorParameters.avoidWater() && f >= 0.0f) {
            if (entity2 instanceof MobAI) {
                ((MobAI)entity2).setPathfindingMalus(PathType.WATER, f + 1.0f);
            } else {
                ((EntityInsentient)entity2).a(PathType.WATER, f + 1.0f);
            }
        }
        navigationAbstract.q().b(navigatorParameters.hasExaminer(DoorExaminer.class));
        return new MCNavigationStrategy.MCNavigator(){
            float lastSpeed;
            CancelReason reason;

            private List<org.bukkit.block.Block> getBlocks(org.bukkit.entity.Entity entity3, NavigationAbstract navigationAbstract2) {
                ArrayList arrayList = Lists.newArrayList();
                for (int i = 0; i < navigationAbstract2.k().e(); ++i) {
                    PathPoint pathPoint = navigationAbstract2.k().a(i);
                    arrayList.add(entity3.getWorld().getBlockAt(pathPoint.a, pathPoint.b, pathPoint.c));
                }
                return arrayList;
            }

            @Override
            public CancelReason getCancelReason() {
                return this.reason;
            }

            @Override
            public Iterable<Vector> getPath() {
                return new NavigationIterable(navigationAbstract);
            }

            @Override
            public void stop() {
                if (navigatorParameters.debug() && navigationAbstract.k() != null) {
                    List<org.bukkit.block.Block> list = this.getBlocks(entity, navigationAbstract);
                    Util.sendBlockChanges(list, null);
                }
                if (f >= 0.0f) {
                    if (entity2 instanceof MobAI) {
                        ((MobAI)entity2).setPathfindingMalus(PathType.WATER, f);
                    } else {
                        ((EntityInsentient)entity2).a(PathType.WATER, f);
                    }
                }
                NMSImpl.stopNavigation(navigationAbstract);
            }

            @Override
            public boolean update() {
                if (navigatorParameters.speed() != this.lastSpeed) {
                    Entity entity3 = NMSImpl.getHandle(entity);
                    EntitySize entitySize = null;
                    try {
                        entitySize = SIZE_FIELD_GETTER.invoke(entity3);
                        if (entity3 instanceof EntityHorse) {
                            SIZE_FIELD_SETTER.invoke(entity3, new EntitySize(Math.min(0.99f, entitySize.width), entitySize.height, false));
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    if (!((Boolean)function.apply(navigationAbstract)).booleanValue()) {
                        this.reason = CancelReason.STUCK;
                    }
                    try {
                        SIZE_FIELD_SETTER.invoke(entity3, entitySize);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    this.lastSpeed = navigatorParameters.speed();
                }
                if (navigatorParameters.debug() && !NMSImpl.isNavigationFinished(navigationAbstract)) {
                    Util.sendBlockChanges(this.getBlocks(entity, navigationAbstract), Material.DANDELION);
                }
                navigationAbstract.a((double)navigatorParameters.speed());
                return NMSImpl.isNavigationFinished(navigationAbstract);
            }
        };
    }

    @Override
    public MCTargetStrategy.TargetNavigator getTargetNavigator(org.bukkit.entity.Entity entity, org.bukkit.entity.Entity entity2, NavigatorParameters navigatorParameters) {
        NavigationAbstract navigationAbstract = NMSImpl.getNavigation(entity);
        return navigationAbstract == null ? null : new NavigationFieldWrapper(entity, navigationAbstract, entity2, navigatorParameters);
    }

    @Override
    public org.bukkit.entity.Entity getVehicle(org.bukkit.entity.Entity entity) {
        Entity entity2 = NMSImpl.getHandle(entity);
        if (entity2 == null) {
            return null;
        }
        Entity entity3 = entity2.getVehicle();
        return entity3 == entity2 || entity3 == null ? null : entity3.getBukkitEntity();
    }

    @Override
    public float getVerticalMovement(org.bukkit.entity.Entity entity) {
        if (!entity.getType().isAlive()) {
            return Float.NaN;
        }
        EntityLiving entityLiving = NMSImpl.getHandle((LivingEntity)entity);
        return entityLiving.aR;
    }

    @Override
    public Collection<Player> getViewingPlayers(org.bukkit.entity.Entity entity) {
        WorldServer worldServer = (WorldServer)NMSImpl.getHandle(entity).getWorld();
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)worldServer.getChunkProvider().playerChunkMap.trackedEntities.get(entity.getEntityId());
        return PlayerlistTracker.getSeenBy(entityTracker);
    }

    @Override
    public double getWidth(org.bukkit.entity.Entity entity) {
        return entity.getWidth();
    }

    @Override
    public float getYaw(org.bukkit.entity.Entity entity) {
        return NMSImpl.getHandle((org.bukkit.entity.Entity)entity).yaw;
    }

    @Override
    public boolean isOnGround(org.bukkit.entity.Entity entity) {
        return NMSImpl.getHandle(entity).isOnGround();
    }

    @Override
    public boolean isSneaking(org.bukkit.entity.Entity entity) {
        if (entity instanceof Player) {
            return ((Player)entity).isSneaking();
        }
        return NMSImpl.getHandle(entity).getPose() == EntityPose.CROUCHING;
    }

    @Override
    public boolean isSolid(org.bukkit.block.Block block) {
        IBlockData iBlockData = ((CraftBlock)block).getNMS();
        return iBlockData.o((IBlockAccess)((CraftWorld)block.getWorld()).getHandle(), new BlockPosition(block.getX(), block.getY(), block.getZ()));
    }

    @Override
    public boolean isValid(org.bukkit.entity.Entity entity) {
        Entity entity2 = NMSImpl.getHandle(entity);
        return entity2.valid && entity2.isAlive();
    }

    @Override
    public void load(CommandManager commandManager) {
        this.registerTraitWithCommand(commandManager, EnderDragonTrait.class);
        this.registerTraitWithCommand(commandManager, BeeTrait.class);
        this.registerTraitWithCommand(commandManager, BossBarTrait.class);
        this.registerTraitWithCommand(commandManager, CatTrait.class);
        this.registerTraitWithCommand(commandManager, FoxTrait.class);
        this.registerTraitWithCommand(commandManager, LlamaTrait.class);
        this.registerTraitWithCommand(commandManager, MushroomCowTrait.class);
        this.registerTraitWithCommand(commandManager, ParrotTrait.class);
        this.registerTraitWithCommand(commandManager, PandaTrait.class);
        this.registerTraitWithCommand(commandManager, PiglinTrait.class);
        this.registerTraitWithCommand(commandManager, PhantomTrait.class);
        this.registerTraitWithCommand(commandManager, PolarBearTrait.class);
        this.registerTraitWithCommand(commandManager, PufferFishTrait.class);
        this.registerTraitWithCommand(commandManager, SpellcasterTrait.class);
        this.registerTraitWithCommand(commandManager, ShulkerTrait.class);
        this.registerTraitWithCommand(commandManager, SnowmanTrait.class);
        this.registerTraitWithCommand(commandManager, TropicalFishTrait.class);
        this.registerTraitWithCommand(commandManager, VillagerTrait.class);
    }

    private void loadEntityTypes() {
        EntityControllers.setEntityControllerForType(EntityType.AREA_EFFECT_CLOUD, AreaEffectCloudController.class);
        EntityControllers.setEntityControllerForType(EntityType.ARROW, TippedArrowController.class);
        EntityControllers.setEntityControllerForType(EntityType.ARMOR_STAND, ArmorStandController.class);
        EntityControllers.setEntityControllerForType(EntityType.BAT, BatController.class);
        EntityControllers.setEntityControllerForType(EntityType.BEE, BeeController.class);
        EntityControllers.setEntityControllerForType(EntityType.BLAZE, BlazeController.class);
        EntityControllers.setEntityControllerForType(EntityType.BOAT, BoatController.class);
        EntityControllers.setEntityControllerForType(EntityType.CAT, CatController.class);
        EntityControllers.setEntityControllerForType(EntityType.CAVE_SPIDER, CaveSpiderController.class);
        EntityControllers.setEntityControllerForType(EntityType.CHICKEN, ChickenController.class);
        EntityControllers.setEntityControllerForType(EntityType.COD, CodController.class);
        EntityControllers.setEntityControllerForType(EntityType.COW, CowController.class);
        EntityControllers.setEntityControllerForType(EntityType.CREEPER, CreeperController.class);
        EntityControllers.setEntityControllerForType(EntityType.DOLPHIN, DolphinController.class);
        EntityControllers.setEntityControllerForType(EntityType.DRAGON_FIREBALL, DragonFireballController.class);
        EntityControllers.setEntityControllerForType(EntityType.DROPPED_ITEM, ItemController.class);
        EntityControllers.setEntityControllerForType(EntityType.DROWNED, DrownedController.class);
        EntityControllers.setEntityControllerForType(EntityType.EGG, EggController.class);
        EntityControllers.setEntityControllerForType(EntityType.ELDER_GUARDIAN, GuardianElderController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_CRYSTAL, EnderCrystalController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_DRAGON, EnderDragonController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_PEARL, EnderPearlController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_SIGNAL, EnderSignalController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDERMAN, EndermanController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDERMITE, EndermiteController.class);
        EntityControllers.setEntityControllerForType(EntityType.EVOKER, EvokerController.class);
        EntityControllers.setEntityControllerForType(EntityType.EVOKER_FANGS, EvokerFangsController.class);
        EntityControllers.setEntityControllerForType(EntityType.FALLING_BLOCK, FallingBlockController.class);
        EntityControllers.setEntityControllerForType(EntityType.FIREWORK, FireworkController.class);
        EntityControllers.setEntityControllerForType(EntityType.FIREBALL, LargeFireballController.class);
        EntityControllers.setEntityControllerForType(EntityType.FISHING_HOOK, FishingHookController.class);
        EntityControllers.setEntityControllerForType(EntityType.FOX, FoxController.class);
        EntityControllers.setEntityControllerForType(EntityType.GHAST, GhastController.class);
        EntityControllers.setEntityControllerForType(EntityType.GIANT, GiantController.class);
        EntityControllers.setEntityControllerForType(EntityType.GUARDIAN, GuardianController.class);
        EntityControllers.setEntityControllerForType(EntityType.HORSE, HorseController.class);
        EntityControllers.setEntityControllerForType(EntityType.DONKEY, HorseDonkeyController.class);
        EntityControllers.setEntityControllerForType(EntityType.MULE, HorseMuleController.class);
        EntityControllers.setEntityControllerForType(EntityType.SKELETON_HORSE, HorseSkeletonController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIE_HORSE, HorseZombieController.class);
        EntityControllers.setEntityControllerForType(EntityType.HUSK, ZombieHuskController.class);
        EntityControllers.setEntityControllerForType(EntityType.IRON_GOLEM, IronGolemController.class);
        EntityControllers.setEntityControllerForType(EntityType.ILLUSIONER, IllusionerController.class);
        EntityControllers.setEntityControllerForType(EntityType.ITEM_FRAME, ItemFrameController.class);
        EntityControllers.setEntityControllerForType(EntityType.LEASH_HITCH, LeashController.class);
        EntityControllers.setEntityControllerForType(EntityType.LLAMA, LlamaController.class);
        EntityControllers.setEntityControllerForType(EntityType.TRADER_LLAMA, TraderLlamaController.class);
        EntityControllers.setEntityControllerForType(EntityType.WANDERING_TRADER, WanderingTraderController.class);
        EntityControllers.setEntityControllerForType(EntityType.LLAMA_SPIT, LlamaSpitController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPLASH_POTION, ThrownPotionController.class);
        EntityControllers.setEntityControllerForType(EntityType.MAGMA_CUBE, MagmaCubeController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART, MinecartRideableController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_CHEST, MinecartChestController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_COMMAND, MinecartCommandController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_FURNACE, MinecartFurnaceController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_HOPPER, MinecartHopperController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_TNT, MinecartTNTController.class);
        EntityControllers.setEntityControllerForType(EntityType.MUSHROOM_COW, MushroomCowController.class);
        EntityControllers.setEntityControllerForType(EntityType.OCELOT, OcelotController.class);
        EntityControllers.setEntityControllerForType(EntityType.PANDA, PandaController.class);
        EntityControllers.setEntityControllerForType(EntityType.PAINTING, PaintingController.class);
        EntityControllers.setEntityControllerForType(EntityType.PARROT, ParrotController.class);
        EntityControllers.setEntityControllerForType(EntityType.PHANTOM, PhantomController.class);
        EntityControllers.setEntityControllerForType(EntityType.PILLAGER, PillagerController.class);
        EntityControllers.setEntityControllerForType(EntityType.PIG, PigController.class);
        EntityControllers.setEntityControllerForType(EntityType.PIGLIN, PiglinController.class);
        EntityControllers.setEntityControllerForType(EntityType.PIGLIN_BRUTE, PiglinBruteController.class);
        EntityControllers.setEntityControllerForType(EntityType.HOGLIN, HoglinController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIFIED_PIGLIN, PigZombieController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOGLIN, ZoglinController.class);
        EntityControllers.setEntityControllerForType(EntityType.POLAR_BEAR, PolarBearController.class);
        EntityControllers.setEntityControllerForType(EntityType.PLAYER, HumanController.class);
        EntityControllers.setEntityControllerForType(EntityType.PUFFERFISH, PufferFishController.class);
        EntityControllers.setEntityControllerForType(EntityType.RABBIT, RabbitController.class);
        EntityControllers.setEntityControllerForType(EntityType.RAVAGER, RavagerController.class);
        EntityControllers.setEntityControllerForType(EntityType.SALMON, SalmonController.class);
        EntityControllers.setEntityControllerForType(EntityType.SHEEP, SheepController.class);
        EntityControllers.setEntityControllerForType(EntityType.SHULKER, ShulkerController.class);
        EntityControllers.setEntityControllerForType(EntityType.SHULKER_BULLET, ShulkerBulletController.class);
        EntityControllers.setEntityControllerForType(EntityType.SILVERFISH, SilverfishController.class);
        EntityControllers.setEntityControllerForType(EntityType.SKELETON, SkeletonController.class);
        EntityControllers.setEntityControllerForType(EntityType.STRAY, SkeletonStrayController.class);
        EntityControllers.setEntityControllerForType(EntityType.STRIDER, StriderController.class);
        EntityControllers.setEntityControllerForType(EntityType.SLIME, SlimeController.class);
        EntityControllers.setEntityControllerForType(EntityType.SMALL_FIREBALL, SmallFireballController.class);
        EntityControllers.setEntityControllerForType(EntityType.SNOWBALL, SnowballController.class);
        EntityControllers.setEntityControllerForType(EntityType.SNOWMAN, SnowmanController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPECTRAL_ARROW, SpectralArrowController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPIDER, SpiderController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPLASH_POTION, ThrownPotionController.class);
        EntityControllers.setEntityControllerForType(EntityType.SQUID, SquidController.class);
        EntityControllers.setEntityControllerForType(EntityType.EXPERIENCE_ORB, ExperienceOrbController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPECTRAL_ARROW, TippedArrowController.class);
        EntityControllers.setEntityControllerForType(EntityType.THROWN_EXP_BOTTLE, ThrownExpBottleController.class);
        EntityControllers.setEntityControllerForType(EntityType.TRIDENT, ThrownTridentController.class);
        EntityControllers.setEntityControllerForType(EntityType.TROPICAL_FISH, TropicalFishController.class);
        EntityControllers.setEntityControllerForType(EntityType.TURTLE, TurtleController.class);
        EntityControllers.setEntityControllerForType(EntityType.PRIMED_TNT, TNTPrimedController.class);
        EntityControllers.setEntityControllerForType(EntityType.VEX, VexController.class);
        EntityControllers.setEntityControllerForType(EntityType.VILLAGER, VillagerController.class);
        EntityControllers.setEntityControllerForType(EntityType.VINDICATOR, VindicatorController.class);
        EntityControllers.setEntityControllerForType(EntityType.WOLF, WolfController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITCH, WitchController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITHER, WitherController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITHER_SKULL, WitherSkullController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITHER_SKELETON, SkeletonWitherController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIE, ZombieController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIE_VILLAGER, ZombieVillagerController.class);
    }

    @Override
    public void look(org.bukkit.entity.Entity entity, float f, float f2) {
        Entity entity2 = NMSImpl.getHandle(entity);
        if (entity2 == null) {
            return;
        }
        entity2.yaw = f = Util.clamp(f);
        this.setHeadYaw(entity, f);
        entity2.pitch = f2;
    }

    @Override
    public void look(org.bukkit.entity.Entity entity, Location location, boolean bl, boolean bl2) {
        Entity entity2 = NMSImpl.getHandle(entity);
        if (bl2 || bl || BAD_CONTROLLER_LOOK.contains(entity2.getBukkitEntity().getType()) || !(entity2 instanceof EntityInsentient) && !(entity2 instanceof MobAI)) {
            Location location2 = entity.getLocation(FROM_LOCATION);
            double d = location.getX() - location2.getX();
            double d2 = location.getY() - location2.getY();
            double d3 = location.getZ() - location2.getZ();
            double d4 = Math.sqrt(d * d + d3 * d3);
            double d5 = Math.sqrt(d4 * d4 + d2 * d2);
            double d6 = Math.toDegrees(Math.acos(d / d4));
            double d7 = Math.toDegrees(Math.acos(d2 / d5)) - (double)(entity2.getBukkitEntity().getType() == EntityType.PHANTOM ? 45 : 90);
            if (d3 < 0.0) {
                d6 += Math.abs(180.0 - d6) * 2.0;
            }
            d6 = entity2.getBukkitEntity().getType() == EntityType.ENDER_DRAGON ? (double)Util.getDragonYaw((org.bukkit.entity.Entity)entity2.getBukkitEntity(), d, d3) : (d6 -= 90.0);
            if (bl) {
                this.setHeadYaw(entity, (float)d6);
            } else {
                this.look(entity, (float)d6, (float)d7);
            }
            return;
        }
        if (entity2 instanceof EntityInsentient) {
            ((EntityInsentient)entity2).getControllerLook().a(location.getX(), location.getY(), location.getZ(), (float)((EntityInsentient)entity2).ep(), (float)((EntityInsentient)entity2).O());
            while (((EntityLiving)entity2).aC >= 180.0f) {
                ((EntityLiving)entity2).aC -= 360.0f;
            }
            while (((EntityLiving)entity2).aC < -180.0f) {
                ((EntityLiving)entity2).aC += 360.0f;
            }
        } else if (entity2 instanceof NPCHolder) {
            ((NPCHolder)entity2).getNPC().getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToFace(location);
        }
    }

    @Override
    public void look(org.bukkit.entity.Entity entity, org.bukkit.entity.Entity entity2) {
        Entity entity3 = NMSImpl.getHandle(entity);
        Entity entity4 = NMSImpl.getHandle(entity2);
        if (BAD_CONTROLLER_LOOK.contains(entity3.getBukkitEntity().getType()) || !(entity3 instanceof EntityInsentient) && !(entity3 instanceof MobAI)) {
            if (entity2 instanceof LivingEntity) {
                this.look(entity, ((LivingEntity)entity2).getEyeLocation(), false, true);
            } else {
                this.look(entity, entity2.getLocation(), false, true);
            }
        } else if (entity3 instanceof EntityInsentient) {
            ((EntityInsentient)entity3).getControllerLook().a(entity4, (float)((EntityInsentient)entity3).ep(), (float)((EntityInsentient)entity3).O());
            while (((EntityLiving)entity3).aC >= 180.0f) {
                ((EntityLiving)entity3).aC -= 360.0f;
            }
            while (((EntityLiving)entity3).aC < -180.0f) {
                ((EntityLiving)entity3).aC += 360.0f;
            }
        } else if (entity3 instanceof NPCHolder) {
            ((NPCHolder)entity3).getNPC().getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToFace(entity2);
        }
    }

    @Override
    public void mount(org.bukkit.entity.Entity entity, org.bukkit.entity.Entity entity2) {
        if (NMSImpl.getHandle(entity2) == null) {
            return;
        }
        NMSImpl.getHandle(entity2).a(NMSImpl.getHandle(entity), true);
    }

    @Override
    public InventoryView openAnvilInventory(Player player, final Inventory inventory, String string) {
        EntityPlayer entityPlayer = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        ContainerAnvil containerAnvil = new ContainerAnvil(entityPlayer.nextContainerCounter(), entityPlayer.inventory, ContainerAccess.at((World)entityPlayer.world, (BlockPosition)new BlockPosition(0, 0, 0))){
            private CraftInventoryView bukkitEntity;

            protected void a(EntityHuman entityHuman, World world, IInventory iInventory) {
            }

            public void e() {
                super.e();
                this.levelCost.set(0);
                this.getBukkitView().getTopInventory().setItem(2, (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror((ItemStack)((Slot)this.slots.get(2)).getItem()));
            }

            public CraftInventoryView getBukkitView() {
                if (this.bukkitEntity == null) {
                    this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player.getBukkitEntity(), (Inventory)new CitizensInventoryAnvil(this.containerAccess.getLocation(), this.repairInventory, (IInventory)this.resultInventory, this, inventory), (Container)this);
                }
                return this.bukkitEntity;
            }
        };
        containerAnvil.getBukkitView().setItem(0, inventory.getItem(0));
        containerAnvil.getBukkitView().setItem(1, inventory.getItem(1));
        containerAnvil.checkReachable = false;
        entityPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(containerAnvil.windowId, containerAnvil.getType(), (IChatBaseComponent)new ChatMessage(string)));
        entityPlayer.activeContainer = containerAnvil;
        entityPlayer.syncInventory();
        return containerAnvil.getBukkitView();
    }

    @Override
    public void openHorseInventory(Tameable tameable, Player player) {
        EntityLiving entityLiving = NMSImpl.getHandle(tameable);
        EntityHuman entityHuman = (EntityHuman)NMSImpl.getHandle((LivingEntity)player);
        if (entityLiving == null || entityHuman == null) {
            return;
        }
        boolean bl = tameable.isTamed();
        tameable.setTamed(true);
        ((EntityHorseAbstract)entityLiving).f(entityHuman);
        tameable.setTamed(bl);
    }

    @Override
    public void playAnimation(PlayerAnimation playerAnimation, Player player, Iterable<Player> iterable) {
        PlayerAnimationImpl.play(playerAnimation, player, iterable);
    }

    @Override
    public Runnable playerTicker(NPC nPC, Player player) {
        EntityPlayer entityPlayer = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        return () -> {
            if (!player.isValid()) {
                return;
            }
            entityPlayer.playerTick();
        };
    }

    @Override
    public void registerEntityClass(Class<?> clazz) {
        if (ENTITY_REGISTRY == null) {
            return;
        }
        Class<?> clazz2 = clazz;
        while ((clazz2 = clazz2.getSuperclass()) != null && Entity.class.isAssignableFrom(clazz2)) {
            EntityTypes entityTypes = ENTITY_REGISTRY.findType(clazz2);
            MinecraftKey minecraftKey = ENTITY_REGISTRY.getKey(entityTypes);
            if (minecraftKey == null || entityTypes == null) continue;
            CITIZENS_ENTITY_TYPES.put(clazz, entityTypes);
            int n = ENTITY_REGISTRY.a(entityTypes);
            ENTITY_REGISTRY.put(n, minecraftKey, entityTypes);
            return;
        }
        throw new IllegalArgumentException("unable to find valid entity superclass for class " + clazz.toString());
    }

    private void registerTraitWithCommand(CommandManager commandManager, Class<? extends Trait> clazz) {
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(clazz));
        commandManager.register(clazz);
    }

    @Override
    public void remove(org.bukkit.entity.Entity entity) {
        NMSImpl.getHandle(entity).die();
    }

    @Override
    public void removeFromServerPlayerList(Player player) {
        EntityPlayer entityPlayer = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        ((CraftServer)Bukkit.getServer()).getHandle().players.remove(entityPlayer);
    }

    @Override
    public void removeFromWorld(org.bukkit.entity.Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        Entity entity2 = ((CraftEntity)entity).getHandle();
        ((WorldServer)entity2.world).removeEntity(entity2);
    }

    @Override
    public void removeHookIfNecessary(FishHook fishHook) {
        if (FISHING_HOOK_HOOKED == null) {
            return;
        }
        EntityFishingHook entityFishingHook = (EntityFishingHook)NMSImpl.getHandle((org.bukkit.entity.Entity)fishHook);
        Entity entity = null;
        try {
            entity = FISHING_HOOK_HOOKED.invoke(entityFishingHook);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (entity == null) {
            return;
        }
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC((org.bukkit.entity.Entity)entity.getBukkitEntity());
        if (nPC == null) {
            return;
        }
        if (nPC.isProtected()) {
            try {
                FISHING_HOOK_HOOKED_SETTER.invoke(entityFishingHook, null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            entityFishingHook.getBukkitEntity().remove();
        }
    }

    @Override
    public void replaceTrackerEntry(org.bukkit.entity.Entity entity) {
        WorldServer worldServer = (WorldServer)NMSImpl.getHandle(entity).getWorld();
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)worldServer.getChunkProvider().playerChunkMap.trackedEntities.get(entity.getEntityId());
        if (entityTracker == null) {
            return;
        }
        entityTracker.a();
        PlayerlistTracker playerlistTracker = new PlayerlistTracker(worldServer.getChunkProvider().playerChunkMap, entityTracker);
        worldServer.getChunkProvider().playerChunkMap.trackedEntities.put(entity.getEntityId(), (Object)playerlistTracker);
        if (NMSImpl.getHandle(entity) instanceof EntityHumanNPC) {
            ((EntityHumanNPC)NMSImpl.getHandle(entity)).setTracked(playerlistTracker);
        }
    }

    @Override
    public void sendPositionUpdate(org.bukkit.entity.Entity entity, Collection<Player> collection, boolean bl, Float f, Float f2, Float f3) {
        Entity entity2 = NMSImpl.getHandle(entity);
        if (f == null) {
            f = Float.valueOf(entity2.yaw);
        }
        if (f2 == null) {
            f2 = Float.valueOf(entity2.pitch);
        }
        ArrayList arrayList = Lists.newArrayList();
        if (bl) {
            EntityTrackerEntry entityTrackerEntry;
            PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)((WorldServer)entity2.world).getChunkProvider().playerChunkMap.trackedEntities.get(entity2.getId());
            Object entityTrackerEntry2 = null;
            try {
                entityTrackerEntry = ENTITY_TRACKER_ENTRY_GETTER.invoke(entityTracker);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
            Vec3D vec3D = entity2.getPositionVector().d(entityTrackerEntry.b());
            arrayList.add(new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(entity2.getId(), (short)vec3D.x, (short)vec3D.y, (short)vec3D.z, (byte)(f.floatValue() * 256.0f / 360.0f), (byte)(f2.floatValue() * 256.0f / 360.0f), entity2.isOnGround()));
        } else {
            arrayList.add(new PacketPlayOutEntity.PacketPlayOutEntityLook(entity2.getId(), (byte)(f.floatValue() * 256.0f / 360.0f), (byte)(f2.floatValue() * 256.0f / 360.0f), entity2.isOnGround()));
        }
        if (f3 != null) {
            arrayList.add(new PacketPlayOutEntityHeadRotation(entity2, (byte)(f3.floatValue() * 256.0f / 360.0f)));
        }
        for (Player player : collection) {
            NMSImpl.sendPackets(player, arrayList);
        }
    }

    @Override
    public boolean sendTabListAdd(Player player, Player player2) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)player2);
        EntityPlayer entityPlayer = ((CraftPlayer)player2).getHandle();
        NMSImpl.sendPacket(player, new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{entityPlayer}));
        return true;
    }

    @Override
    public void sendTabListRemove(Player player, Collection<Player> collection) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull(collection);
        EntityPlayer[] entityPlayerArray = new EntityPlayer[collection.size()];
        int n = 0;
        for (Player player2 : collection) {
            entityPlayerArray[n] = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player2);
            ++n;
        }
        NMSImpl.sendPacket(player, new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, entityPlayerArray));
    }

    @Override
    public void sendTeamPacket(Player player, Team team, int n) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)team);
        if (TEAM_FIELD == null) {
            TEAM_FIELD = NMS.getGetter(team.getClass(), "team");
        }
        try {
            ScoreboardTeam scoreboardTeam = TEAM_FIELD.invoke(team);
            NMSImpl.sendPacket(player, new PacketPlayOutScoreboardTeam(scoreboardTeam, n));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void setAggressive(org.bukkit.entity.Entity entity, boolean bl) {
        Entity entity2 = NMSImpl.getHandle(entity);
        if (!(entity2 instanceof EntityInsentient)) {
            return;
        }
        ((EntityInsentient)entity2).setAggressive(bl);
    }

    @Override
    public void setBodyYaw(org.bukkit.entity.Entity entity, float f) {
        Entity entity2 = NMSImpl.getHandle(entity);
        entity2.yaw = f;
        if (entity2 instanceof EntityLiving) {
            ((EntityLiving)entity2).aB = f;
            ((EntityLiving)entity2).aA = f;
        }
    }

    @Override
    public void setBoundingBox(org.bukkit.entity.Entity entity, BoundingBox boundingBox) {
        NMSImpl.getHandle(entity).a(new AxisAlignedBB(boundingBox.minX, boundingBox.minY, boundingBox.minZ, boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ));
    }

    @Override
    public void setCustomName(org.bukkit.entity.Entity entity, Object object, String string) {
        NMSImpl.getHandle(entity).setCustomName((IChatBaseComponent)object);
    }

    @Override
    public void setDestination(org.bukkit.entity.Entity entity, double d, double d2, double d3, float f) {
        Entity entity2 = NMSImpl.getHandle(entity);
        if (entity2 == null) {
            return;
        }
        if (entity2 instanceof EntityInsentient) {
            ((EntityInsentient)entity2).getControllerMove().a(d, d2, d3, (double)f);
        } else if (entity2 instanceof MobAI) {
            ((MobAI)entity2).getMoveControl().a(d, d2, d3, (double)f);
        }
    }

    @Override
    public void setDimensions(org.bukkit.entity.Entity entity, EntityDim entityDim) {
        NMSImpl.setSize(NMSImpl.getHandle(entity), new EntitySize(entityDim.width, entityDim.height, true));
    }

    @Override
    public void setEndermanAngry(Enderman enderman, boolean bl) {
        if (ENDERMAN_ANGRY == null) {
            return;
        }
        NMSImpl.getHandle((LivingEntity)enderman).getDataWatcher().set(ENDERMAN_ANGRY, (Object)bl);
    }

    @Override
    public void setHeadAndBodyYaw(org.bukkit.entity.Entity entity, float f) {
        f = Util.clamp(f);
        this.setBodyYaw(entity, f);
        this.setHeadYaw(entity, f);
    }

    @Override
    public void setHeadYaw(org.bukkit.entity.Entity entity, float f) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        ((EntityLiving)NMSImpl.getHandle(entity)).setHeadRotation(Util.clamp(f));
    }

    @Override
    public void setKnockbackResistance(LivingEntity livingEntity, double d) {
        EntityLiving entityLiving = NMSImpl.getHandle(livingEntity);
        entityLiving.getAttributeInstance(GenericAttributes.KNOCKBACK_RESISTANCE).setValue(d);
    }

    @Override
    public void setLocationDirectly(org.bukkit.entity.Entity entity, Location location) {
        NMSImpl.getHandle(entity).setPositionRotation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    @Override
    public void setLyingDown(org.bukkit.entity.Entity entity, boolean bl) {
        ((EntityCat)NMSImpl.getHandle(entity)).x(bl);
    }

    @Override
    public void setNavigationTarget(org.bukkit.entity.Entity entity, org.bukkit.entity.Entity entity2, float f) {
        NMSImpl.getNavigation(entity).a(NMSImpl.getHandle(entity2), (double)f);
    }

    @Override
    public void setNavigationType(org.bukkit.entity.Entity entity, NMS.MinecraftNavigationType minecraftNavigationType) {
        Entity entity2 = NMSImpl.getHandle(entity);
        if (!(entity2 instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient entityInsentient = (EntityInsentient)entity2;
        switch (minecraftNavigationType) {
            case GROUND: {
                try {
                    ENTITY_NAVIGATION.invoke(entityInsentient, new Navigation(entityInsentient, entityInsentient.world));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                break;
            }
            case WALL_CLIMB: {
                try {
                    ENTITY_NAVIGATION.invoke(entityInsentient, new NavigationSpider(entityInsentient, entityInsentient.world));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void setNoGravity(org.bukkit.entity.Entity entity, boolean bl) {
        Entity entity2 = NMSImpl.getHandle(entity);
        entity2.setNoGravity(bl);
        if (!(entity2 instanceof EntityInsentient) || !(entity instanceof NPCHolder)) {
            return;
        }
        EntityInsentient entityInsentient = (EntityInsentient)entity2;
        NPC nPC = ((NPCHolder)entity).getNPC();
        if (!(entityInsentient.getControllerMove() instanceof ControllerMoveFlying) || nPC.data().has("flying-nogravity-float")) {
            return;
        }
        try {
            if (bl) {
                boolean bl2 = FLYING_MOVECONTROL_FLOAT_GETTER.invoke(entityInsentient.getControllerMove());
                FLYING_MOVECONTROL_FLOAT_SETTER.invoke(entityInsentient.getControllerMove(), true);
                nPC.data().set("flying-nogravity-float", (Object)bl2);
            } else if (nPC.data().has("flying-nogravity-float")) {
                FLYING_MOVECONTROL_FLOAT_SETTER.invoke(entityInsentient.getControllerMove(), nPC.data().get("flying-nogravity-float"));
                nPC.data().remove("flying-nogravity-float");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void setPandaSitting(org.bukkit.entity.Entity entity, boolean bl) {
        ((EntityPanda)NMSImpl.getHandle(entity)).t(bl);
    }

    @Override
    public void setPeekShulker(org.bukkit.entity.Entity entity, int n) {
        ((EntityShulker)NMSImpl.getHandle(entity)).a(n);
    }

    @Override
    public void setPiglinDancing(org.bukkit.entity.Entity entity, boolean bl) {
        if (!(NMSImpl.getHandle(entity) instanceof Piglin)) {
            return;
        }
        ((EntityPiglin)NMSImpl.getHandle(entity)).u(bl);
    }

    @Override
    public void setPitch(org.bukkit.entity.Entity entity, float f) {
        NMSImpl.getHandle((org.bukkit.entity.Entity)entity).pitch = f;
    }

    @Override
    public void setPolarBearRearing(org.bukkit.entity.Entity entity, boolean bl) {
        ((EntityPolarBear)NMSImpl.getHandle(entity)).t(bl);
    }

    public void setPose(org.bukkit.entity.Entity entity, EntityPose entityPose) {
        NMSImpl.getHandle(entity).setPose(EntityPose.valueOf((String)entityPose.name()));
    }

    @Override
    public void setProfile(SkullMeta skullMeta, GameProfile gameProfile) {
        if (SET_PROFILE_METHOD == null && (SET_PROFILE_METHOD = NMS.getMethodHandle(skullMeta.getClass(), "setProfile", true, GameProfile.class)) == null) {
            return;
        }
        try {
            SET_PROFILE_METHOD.invoke(skullMeta, gameProfile);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void setShouldJump(org.bukkit.entity.Entity entity) {
        Entity entity2 = NMSImpl.getHandle(entity);
        if (entity2 == null) {
            return;
        }
        if (entity2 instanceof EntityInsentient) {
            ControllerJump controllerJump = ((EntityInsentient)entity2).getControllerJump();
            controllerJump.jump();
        } else if (entity2 instanceof MobAI) {
            ((MobAI)entity2).getJumpControl().jump();
        }
    }

    @Override
    public void setSitting(Ocelot ocelot, boolean bl) {
        this.setSneaking((org.bukkit.entity.Entity)ocelot, bl);
    }

    @Override
    public void setSitting(Tameable tameable, boolean bl) {
        ((EntityTameableAnimal)NMSImpl.getHandle(tameable)).setSitting(bl);
    }

    @Override
    public void setSneaking(org.bukkit.entity.Entity entity, boolean bl) {
        if (entity instanceof Player) {
            ((Player)entity).setSneaking(bl);
        }
        EntityPose entityPose = bl ? EntityPose.CROUCHING : EntityPose.STANDING;
        NMSImpl.getHandle(entity).setPose(entityPose);
    }

    @Override
    public void setStepHeight(org.bukkit.entity.Entity entity, float f) {
        NMSImpl.getHandle((org.bukkit.entity.Entity)entity).G = f;
    }

    @Override
    public void setVerticalMovement(org.bukkit.entity.Entity entity, double d) {
        if (!entity.getType().isAlive()) {
            return;
        }
        EntityLiving entityLiving = NMSImpl.getHandle((LivingEntity)entity);
        entityLiving.aR = (float)d;
    }

    @Override
    public void setWitherInvulnerableTicks(Wither wither, int n) {
        EntityWither entityWither = ((CraftWither)wither).getHandle();
        entityWither.setInvul(n);
    }

    @Override
    public boolean shouldJump(org.bukkit.entity.Entity entity) {
        if (JUMP_FIELD == null || !(entity instanceof LivingEntity)) {
            return false;
        }
        try {
            return JUMP_FIELD.invoke(NMSImpl.getHandle(entity));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    @Override
    public void shutdown() {
        if (ENTITY_REGISTRY == null) {
            return;
        }
        MethodHandle methodHandle = NMS.getFinalSetter(IRegistry.class, "ENTITY_TYPE");
        try {
            methodHandle.invoke(null, ENTITY_REGISTRY.get());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void sleep(Player player, boolean bl) {
        EntityPose entityPose = bl ? EntityPose.SLEEPING : EntityPose.STANDING;
        try {
            ENTITY_SETPOSE_METHOD.invoke(NMSImpl.getHandle((LivingEntity)player), entityPose);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void trySwim(org.bukkit.entity.Entity entity) {
        this.trySwim(entity, 0.04f);
    }

    @Override
    public void trySwim(org.bukkit.entity.Entity entity, float f) {
        Entity entity2 = NMSImpl.getHandle(entity);
        if (entity2 == null) {
            return;
        }
        if (RANDOM.nextFloat() <= 0.85f && entity2.isInWater()) {
            entity2.setMot(entity2.getMot().getX(), entity2.getMot().getY() + (double)f, entity2.getMot().getZ());
        }
    }

    @Override
    public void updateInventoryTitle(Player player, InventoryView inventoryView, String string) {
        EntityPlayer entityPlayer = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        Containers containers = null;
        switch (inventoryView.getTopInventory().getType()) {
            case ANVIL: {
                containers = Containers.ANVIL;
                break;
            }
            case BARREL: {
                containers = Containers.GENERIC_9X3;
                break;
            }
            case BEACON: {
                containers = Containers.BEACON;
                break;
            }
            case BLAST_FURNACE: {
                containers = Containers.BLAST_FURNACE;
                break;
            }
            case BREWING: {
                containers = Containers.BREWING_STAND;
                break;
            }
            case CARTOGRAPHY: {
                containers = Containers.CARTOGRAPHY_TABLE;
                break;
            }
            case CHEST: {
                int n = inventoryView.getTopInventory().getSize();
                if (n > 45) {
                    containers = Containers.GENERIC_9X6;
                    break;
                }
                if (n > 36) {
                    containers = Containers.GENERIC_9X5;
                    break;
                }
                if (n > 27) {
                    containers = Containers.GENERIC_9X4;
                    break;
                }
                if (n > 18) {
                    containers = Containers.GENERIC_9X3;
                    break;
                }
                if (n > 9) {
                    containers = Containers.GENERIC_9X2;
                    break;
                }
                containers = Containers.GENERIC_9X1;
                break;
            }
            case PLAYER: 
            case CRAFTING: 
            case CREATIVE: {
                return;
            }
            case DISPENSER: 
            case DROPPER: {
                containers = Containers.GENERIC_3X3;
                break;
            }
            case ENCHANTING: {
                containers = Containers.ENCHANTMENT;
                break;
            }
            case ENDER_CHEST: {
                containers = Containers.GENERIC_9X3;
                break;
            }
            case FURNACE: {
                containers = Containers.FURNACE;
                break;
            }
            case GRINDSTONE: {
                containers = Containers.GRINDSTONE;
                break;
            }
            case HOPPER: {
                containers = Containers.HOPPER;
                break;
            }
            case LECTERN: {
                containers = Containers.LECTERN;
                break;
            }
            case LOOM: {
                containers = Containers.LOOM;
                break;
            }
            case MERCHANT: {
                containers = Containers.MERCHANT;
                break;
            }
            case SHULKER_BOX: {
                containers = Containers.SHULKER_BOX;
                break;
            }
            case SMITHING: {
                containers = Containers.SMITHING;
                break;
            }
            case SMOKER: {
                containers = Containers.SMOKER;
                break;
            }
            case STONECUTTER: {
                containers = Containers.STONECUTTER;
                break;
            }
            case WORKBENCH: {
                containers = Containers.CRAFTING;
            }
        }
        Container container = entityPlayer.activeContainer;
        entityPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(container.windowId, containers, (IChatBaseComponent)new ChatComponentText(string)));
        player.updateInventory();
    }

    @Override
    public void updateNavigationWorld(org.bukkit.entity.Entity entity, org.bukkit.World world) {
        if (NAVIGATION_WORLD_FIELD == null) {
            return;
        }
        Entity entity2 = NMSImpl.getHandle(entity);
        if (entity2 == null || !(entity2 instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient entityInsentient = (EntityInsentient)entity2;
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        try {
            NAVIGATION_WORLD_FIELD.invoke(entityInsentient.getNavigation(), worldServer);
        }
        catch (Exception exception) {
            Messaging.logTr("citizens.nms-errors.updating-navigation-world", exception.getMessage());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void updatePathfindingRange(NPC nPC, float f) {
        if (!nPC.isSpawned() || !nPC.getEntity().getType().isAlive()) {
            return;
        }
        EntityLiving entityLiving = NMSImpl.getHandle((LivingEntity)nPC.getEntity());
        if (entityLiving instanceof MobAI) {
            ((MobAI)entityLiving).updatePathfindingRange(f);
            return;
        }
        if (NAVIGATION_S == null) {
            return;
        }
        NavigationAbstract navigationAbstract = ((EntityInsentient)entityLiving).getNavigation();
        AttributeModifiable attributeModifiable = entityLiving.getAttributeInstance(GenericAttributes.FOLLOW_RANGE);
        attributeModifiable.setValue((double)f);
        int n = MathHelper.floor((double)(entityLiving.b(GenericAttributes.FOLLOW_RANGE) * 16.0));
        try {
            NAVIGATION_S.invoke(navigationAbstract, NAVIGATION_A.invoke(navigationAbstract, n));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void checkAndUpdateHeight(EntityLiving entityLiving, DataWatcherObject<?> dataWatcherObject, Consumer<DataWatcherObject<?>> consumer) {
        EntitySize entitySize;
        try {
            entitySize = SIZE_FIELD_GETTER.invoke(entityLiving);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
        float f = entitySize.width;
        float f2 = entitySize.height;
        consumer.accept(dataWatcherObject);
        if (f != entitySize.width || entitySize.height != f2) {
            entityLiving.setPosition(entityLiving.locX() - 0.01, entityLiving.locY(), entityLiving.locZ() - 0.01);
            entityLiving.setPosition(entityLiving.locX() + 0.01, entityLiving.locY(), entityLiving.locZ() + 0.01);
        }
    }

    public static void clearGoals(NPC nPC, PathfinderGoalSelector ... pathfinderGoalSelectorArray) {
        if (GOAL_SET_FIELD == null || pathfinderGoalSelectorArray == null) {
            return;
        }
        int n = 0;
        for (PathfinderGoalSelector pathfinderGoalSelector : pathfinderGoalSelectorArray) {
            try {
                Collection collection = GOAL_SET_FIELD.invoke(pathfinderGoalSelector);
                if (!collection.isEmpty()) {
                    nPC.data().set("selector" + n, (Object)Lists.newArrayList((Iterable)collection));
                }
                collection.clear();
            }
            catch (Exception exception) {
                Messaging.logTr("citizens.nms-errors.clearing-goals", exception.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                Messaging.logTr("citizens.nms-errors.clearing-goals", throwable.getLocalizedMessage());
            }
            ++n;
        }
    }

    public static void flyingMoveLogic(EntityLiving entityLiving, Vec3D vec3D) {
        if (entityLiving.doAITick() || entityLiving.cs()) {
            boolean bl;
            double d = 0.08;
            boolean bl2 = bl = entityLiving.getMot().y <= 0.0;
            if (bl && entityLiving.hasEffect(MobEffects.SLOW_FALLING)) {
                d = 0.01;
                entityLiving.fallDistance = 0.0f;
            }
            Fluid fluid = entityLiving.world.getFluid(entityLiving.getChunkCoordinates());
            if (entityLiving.isInWater() && !entityLiving.a(fluid.getType())) {
                double d2 = entityLiving.locY();
                float f = entityLiving.isSprinting() ? 0.9f : 0.8f;
                float f2 = 0.02f;
                float f3 = EnchantmentManager.e((EntityLiving)entityLiving);
                if (f3 > 3.0f) {
                    f3 = 3.0f;
                }
                if (!entityLiving.isOnGround()) {
                    f3 *= 0.5f;
                }
                if (f3 > 0.0f) {
                    f += (0.54600006f - f) * f3 / 3.0f;
                    f2 += (entityLiving.dN() - f2) * f3 / 3.0f;
                }
                if (entityLiving.hasEffect(MobEffects.DOLPHINS_GRACE)) {
                    f = 0.96f;
                }
                entityLiving.a(f2, vec3D);
                entityLiving.move(EnumMoveType.SELF, entityLiving.getMot());
                Vec3D vec3D2 = entityLiving.getMot();
                if (entityLiving.positionChanged && entityLiving.isClimbing()) {
                    vec3D2 = new Vec3D(vec3D2.x, 0.2, vec3D2.z);
                }
                entityLiving.setMot(vec3D2.d((double)f, (double)0.8f, (double)f));
                Vec3D vec3D3 = entityLiving.a(d, bl, entityLiving.getMot());
                entityLiving.setMot(vec3D3);
                if (entityLiving.positionChanged && entityLiving.e(vec3D3.x, vec3D3.y + 0.6 - entityLiving.locY() + d2, vec3D3.z)) {
                    entityLiving.setMot(vec3D3.x, (double)0.3f, vec3D3.z);
                }
            } else if (entityLiving.aQ() && !entityLiving.a(fluid.getType())) {
                Vec3D vec3D4;
                double d3 = entityLiving.locY();
                entityLiving.a(0.02f, vec3D);
                entityLiving.move(EnumMoveType.SELF, entityLiving.getMot());
                if (entityLiving.b((Tag)TagsFluid.LAVA) <= entityLiving.cx()) {
                    entityLiving.setMot(entityLiving.getMot().d(0.5, 0.8, 0.5));
                    vec3D4 = entityLiving.a(d, bl, entityLiving.getMot());
                    entityLiving.setMot(vec3D4);
                } else {
                    entityLiving.setMot(entityLiving.getMot().a(0.5));
                }
                if (!entityLiving.isNoGravity()) {
                    entityLiving.setMot(entityLiving.getMot().add(0.0, -d / 4.0, 0.0));
                }
                vec3D4 = entityLiving.getMot();
                if (entityLiving.positionChanged && entityLiving.e(vec3D4.x, vec3D4.y + 0.6 - entityLiving.locY() + d3, vec3D4.z)) {
                    entityLiving.setMot(vec3D4.x, 0.3, vec3D4.z);
                }
            } else if (entityLiving.isGliding()) {
                double d4;
                float f;
                double d5;
                Vec3D vec3D5 = entityLiving.getMot();
                if (vec3D5.y > -0.5) {
                    entityLiving.fallDistance = 1.0f;
                }
                Vec3D vec3D6 = entityLiving.getLookDirection();
                float f4 = entityLiving.pitch * ((float)Math.PI / 180);
                double d6 = Math.sqrt(vec3D6.x * vec3D6.x + vec3D6.z * vec3D6.z);
                double d7 = Math.sqrt(Entity.c((Vec3D)vec3D5));
                double d8 = vec3D6.f();
                float f5 = MathHelper.cos((float)f4);
                f5 = (float)((double)(f5 * f5) * Math.min(1.0, d8 / 0.4));
                vec3D5 = entityLiving.getMot().add(0.0, d * (-1.0 + (double)f5 * 0.75), 0.0);
                if (vec3D5.y < 0.0 && d6 > 0.0) {
                    d5 = vec3D5.y * -0.1 * (double)f5;
                    vec3D5 = vec3D5.add(vec3D6.x * d5 / d6, d5, vec3D6.z * d5 / d6);
                }
                if (f4 < 0.0f && d6 > 0.0) {
                    d5 = d7 * (double)(-MathHelper.sin((float)f4)) * 0.04;
                    vec3D5 = vec3D5.add(-vec3D6.x * d5 / d6, d5 * 3.2, -vec3D6.z * d5 / d6);
                }
                if (d6 > 0.0) {
                    vec3D5 = vec3D5.add((vec3D6.x / d6 * d7 - vec3D5.x) * 0.1, 0.0, (vec3D6.z / d6 * d7 - vec3D5.z) * 0.1);
                }
                entityLiving.setMot(vec3D5.d((double)0.99f, (double)0.98f, (double)0.99f));
                entityLiving.move(EnumMoveType.SELF, entityLiving.getMot());
                if (entityLiving.positionChanged && !entityLiving.world.isClientSide && (f = (float)((d4 = d7 - (d5 = Math.sqrt(Entity.c((Vec3D)entityLiving.getMot())))) * 10.0 - 3.0)) > 0.0f) {
                    try {
                        entityLiving.playSound(ENTITY_GET_SOUND_FALL.invoke(entityLiving, (int)f), 1.0f, 1.0f);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    entityLiving.damageEntity(DamageSource.FLY_INTO_WALL, f);
                }
                if (entityLiving.isOnGround() && !entityLiving.world.isClientSide && entityLiving.getFlag(7) && !CraftEventFactory.callToggleGlideEvent((EntityLiving)entityLiving, (boolean)false).isCancelled()) {
                    entityLiving.setFlag(7, false);
                }
            } else {
                BlockPosition blockPosition = new BlockPosition(entityLiving.locX(), entityLiving.getBoundingBox().minY - 0.5000001, entityLiving.locZ());
                float f = entityLiving.world.getType(blockPosition).getBlock().getFrictionFactor();
                float f6 = entityLiving.isOnGround() ? f * 0.91f : 0.91f;
                Vec3D vec3D7 = entityLiving.a(vec3D, f);
                double d9 = vec3D7.y;
                if (entityLiving.hasEffect(MobEffects.LEVITATION)) {
                    d9 += (0.05 * (double)(entityLiving.getEffect(MobEffects.LEVITATION).getAmplifier() + 1) - vec3D7.y) * 0.2;
                    entityLiving.fallDistance = 0.0f;
                } else if (entityLiving.world.isClientSide && !entityLiving.world.isLoaded(blockPosition)) {
                    d9 = entityLiving.locY() > 0.0 ? -0.1 : 0.0;
                } else if (!entityLiving.isNoGravity()) {
                    d9 -= d;
                }
                entityLiving.setMot(vec3D7.x * (double)f6, d9 * (double)0.98f, vec3D7.z * (double)f6);
            }
        }
        entityLiving.a(entityLiving, entityLiving instanceof EntityBird);
    }

    public static TreeMap<?, ?> getBehaviorMap(EntityLiving entityLiving) {
        try {
            return BEHAVIOR_MAP.invoke(entityLiving.getBehaviorController());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static <T extends Entity> EntityTypes<T> getEntityType(Class<?> clazz) {
        return CITIZENS_ENTITY_TYPES.get(clazz);
    }

    private static EntityLiving getHandle(LivingEntity livingEntity) {
        return (EntityLiving)NMSImpl.getHandle((org.bukkit.entity.Entity)livingEntity);
    }

    public static Entity getHandle(org.bukkit.entity.Entity entity) {
        if (!(entity instanceof CraftEntity)) {
            return null;
        }
        return ((CraftEntity)entity).getHandle();
    }

    private static EntityLiving getHandle(Tameable tameable) {
        return (EntityLiving)NMSImpl.getHandle((org.bukkit.entity.Entity)tameable);
    }

    public static NavigationAbstract getNavigation(org.bukkit.entity.Entity entity) {
        Entity entity2 = NMSImpl.getHandle(entity);
        return entity2 instanceof EntityInsentient ? ((EntityInsentient)entity2).getNavigation() : (entity2 instanceof MobAI ? ((MobAI)entity2).getNavigation() : null);
    }

    public static DataWatcherObject<Integer> getRabbitTypeField() {
        if (RABBIT_DATAWATCHER_FIELD == null) {
            return null;
        }
        try {
            return RABBIT_DATAWATCHER_FIELD.invoke();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static EntitySize getSize(Entity entity) {
        try {
            return SIZE_FIELD_GETTER.invoke(entity);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static SoundEffect getSoundEffect(NPC nPC, SoundEffect soundEffect, NPC.Metadata metadata) {
        return nPC == null || !nPC.data().has(metadata) ? soundEffect : (SoundEffect)IRegistry.SOUND_EVENT.get(new MinecraftKey(nPC.data().get(metadata, soundEffect == null ? "" : soundEffect.toString())));
    }

    public static void initNetworkManager(NetworkManager networkManager) {
        SocketAddress socketAddress;
        networkManager.channel = new EmptyChannel(null);
        networkManager.socketAddress = socketAddress = new SocketAddress(){
            private static final long serialVersionUID = 8207338859896320185L;
        };
    }

    public static boolean isLeashed(NPC nPC, Supplier<Boolean> supplier, EntityInsentient entityInsentient) {
        return NMS.isLeashed(nPC, supplier, () -> entityInsentient.unleash(true, false));
    }

    public static boolean isNavigationFinished(NavigationAbstract navigationAbstract) {
        return navigationAbstract.m();
    }

    public static void minecartItemLogic(EntityMinecartAbstract entityMinecartAbstract) {
        NPC nPC = ((NPCHolder)entityMinecartAbstract).getNPC();
        if (nPC == null) {
            return;
        }
        Material material = Material.getMaterial((String)nPC.data().get(NPC.Metadata.MINECART_ITEM, ""));
        int n = nPC.data().get(NPC.Metadata.MINECART_ITEM_DATA, Integer.valueOf(0));
        int n2 = nPC.data().get(NPC.Metadata.MINECART_OFFSET, Integer.valueOf(0));
        entityMinecartAbstract.a(material != null);
        if (material != null) {
            entityMinecartAbstract.setDisplayBlock(Block.getByCombinedId((int)material.getId()).getBlock().getBlockData());
        }
        entityMinecartAbstract.setDisplayBlockOffset(n2);
    }

    public static boolean moveFish(NPC nPC, EntityInsentient entityInsentient, Vec3D vec3D) {
        return NMSImpl.moveFish(nPC, entityInsentient, vec3D, -1.0f);
    }

    public static boolean moveFish(NPC nPC, EntityInsentient entityInsentient, Vec3D vec3D, float f) {
        if (nPC == null) {
            return false;
        }
        if (!nPC.useMinecraftAI() && entityInsentient.isInWater() && !nPC.getNavigator().isNavigating()) {
            entityInsentient.a(f > 0.0f ? f : (entityInsentient instanceof EntityTurtle ? 0.1f : 0.01f), vec3D);
            entityInsentient.move(EnumMoveType.SELF, entityInsentient.getMot());
            entityInsentient.setMot(entityInsentient.getMot().a(0.9));
            return true;
        }
        return false;
    }

    public static void resetPuffTicks(EntityPufferFish entityPufferFish) {
        try {
            PUFFERFISH_C.invoke(entityPufferFish, 0);
            PUFFERFISH_D.invoke(entityPufferFish, 0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void restoreGoals(NPC nPC, PathfinderGoalSelector ... pathfinderGoalSelectorArray) {
        if (GOAL_SET_FIELD == null || pathfinderGoalSelectorArray == null) {
            return;
        }
        int n = 0;
        for (PathfinderGoalSelector pathfinderGoalSelector : pathfinderGoalSelectorArray) {
            try {
                Collection collection = GOAL_SET_FIELD.invoke(pathfinderGoalSelector);
                collection.clear();
                Collection collection2 = (Collection)nPC.data().get("selector" + n);
                if (collection2 != null) {
                    collection.addAll(collection2);
                }
            }
            catch (Exception exception) {
                Messaging.logTr("citizens.nms-errors.restoring-goals", exception.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                Messaging.logTr("citizens.nms-errors.restoring-goals", throwable.getLocalizedMessage());
            }
            ++n;
        }
    }

    public static void sendPacket(Player player, Packet<?> packet) {
        if (packet == null) {
            return;
        }
        ((EntityPlayer)NMSImpl.getHandle((LivingEntity)player)).playerConnection.sendPacket(packet);
    }

    public static void sendPackets(Player player, Iterable<Packet<?>> iterable) {
        if (iterable == null) {
            return;
        }
        for (Packet<?> packet : iterable) {
            ((EntityPlayer)NMSImpl.getHandle((LivingEntity)player)).playerConnection.sendPacket(packet);
        }
    }

    public static void sendPacketsNearby(Player player, Location location, Collection<Packet<?>> collection, double d) {
        d *= d;
        for (Player player2 : CitizensAPI.getLocationLookup().getNearbyVisiblePlayers((org.bukkit.entity.Entity)player, location, d)) {
            for (Packet<?> packet : collection) {
                NMSImpl.sendPacket(player2, packet);
            }
        }
    }

    public static void sendPacketsNearby(Player player, Location location, Packet<?> ... packetArray) {
        NMSImpl.sendPacketsNearby(player, location, Arrays.asList(packetArray), 64.0);
    }

    public static void setAdvancement(Player player, AdvancementDataPlayer advancementDataPlayer) {
        try {
            ADVANCEMENT_PLAYER_FIELD.invoke(NMSImpl.getHandle((LivingEntity)player), advancementDataPlayer);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void setAttribute(EntityLiving entityLiving, AttributeBase attributeBase, double d) {
        AttributeModifiable attributeModifiable2 = entityLiving.getAttributeInstance(attributeBase);
        if (attributeModifiable2 == null) {
            try {
                AttributeProvider attributeProvider = ATTRIBUTE_MAP.invoke(entityLiving.getAttributeMap());
                HashMap hashMap = Maps.newHashMap((Map)ATTRIBUTE_PROVIDER_MAP.invoke(attributeProvider));
                hashMap.put(GenericAttributes.FOLLOW_RANGE, new AttributeModifiable(GenericAttributes.FOLLOW_RANGE, attributeModifiable -> {
                    throw new UnsupportedOperationException("Tried to change value for default attribute instance FOLLOW_RANGE");
                }));
                ATTRIBUTE_PROVIDER_MAP_SETTER.invoke(attributeProvider, ImmutableMap.copyOf((Map)hashMap));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            attributeModifiable2 = entityLiving.getAttributeMap().a(attributeBase);
        }
        attributeModifiable2.setValue(d);
    }

    public static void setBukkitEntity(Entity entity, CraftEntity craftEntity) {
        try {
            BUKKITENTITY_FIELD_SETTER.invoke(entity, craftEntity);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void setLookControl(EntityInsentient entityInsentient, ControllerLook controllerLook) {
        try {
            LOOK_CONTROL_SETTER.invoke(entityInsentient, controllerLook);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void setNotInSchool(EntityFish entityFish) {
        try {
            if (ENTITY_FISH_NUM_IN_SCHOOL != null) {
                ENTITY_FISH_NUM_IN_SCHOOL.invoke(entityFish, 2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void setSize(Entity entity, boolean bl) {
        try {
            EntitySize entitySize = SIZE_FIELD_GETTER.invoke(entity);
            EntityPose entityPose = entity.getPose();
            EntitySize entitySize2 = entity.a(entityPose);
            SIZE_FIELD_SETTER.invoke(entity, entitySize2);
            HEAD_HEIGHT.invoke(entity, HEAD_HEIGHT_METHOD.invoke(entity, entityPose, entitySize2));
            if (entitySize2.width < entitySize.width) {
                // empty if block
            }
            AxisAlignedBB axisAlignedBB = entity.getBoundingBox();
            entity.a(new AxisAlignedBB(axisAlignedBB.minX, axisAlignedBB.minY, axisAlignedBB.minZ, axisAlignedBB.minX + (double)entitySize2.width, axisAlignedBB.minY + (double)entitySize2.height, axisAlignedBB.minZ + (double)entitySize2.width));
            if (entitySize2.width > entitySize.width && !bl && !entity.world.isClientSide) {
                float f = entitySize.width - entitySize2.width;
                entity.move(EnumMoveType.SELF, new Vec3D((double)f, 0.0, (double)f));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void setSize(Entity entity, EntitySize entitySize) {
        try {
            SIZE_FIELD_SETTER.invoke(entity, entitySize);
            HEAD_HEIGHT.invoke(entity, HEAD_HEIGHT_METHOD.invoke(entity, entity.getPose(), entity.a(entity.getPose())));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void stopNavigation(NavigationAbstract navigationAbstract) {
        navigationAbstract.o();
    }

    public static void updateAI(EntityLiving entityLiving) {
        if (entityLiving instanceof EntityInsentient) {
            EntityInsentient entityInsentient = (EntityInsentient)entityLiving;
            entityInsentient.getEntitySenses().a();
            NMSImpl.updateNavigation(entityInsentient.getNavigation());
            entityInsentient.getControllerMove().a();
            entityInsentient.getControllerLook().a();
            entityInsentient.getControllerJump().b();
        } else if (entityLiving instanceof MobAI) {
            ((MobAI)entityLiving).tickAI();
        }
    }

    public static void updateMinecraftAIState(NPC nPC, EntityInsentient entityInsentient) {
        if (nPC == null) {
            return;
        }
        if (nPC.useMinecraftAI()) {
            NMSImpl.restoreGoals(nPC, entityInsentient.goalSelector, entityInsentient.targetSelector);
            if (nPC.data().has("behavior-map")) {
                TreeMap treeMap = (TreeMap)nPC.data().get("behavior-map");
                NMSImpl.getBehaviorMap((EntityLiving)entityInsentient).putAll(treeMap);
                nPC.data().remove("behavior-map");
            }
        } else {
            NMSImpl.clearGoals(nPC, entityInsentient.goalSelector, entityInsentient.targetSelector);
            TreeMap<?, ?> treeMap = NMSImpl.getBehaviorMap((EntityLiving)entityInsentient);
            if (treeMap.size() > 0) {
                nPC.data().set("behavior-map", new TreeMap((SortedMap<?, ?>)treeMap));
                treeMap.clear();
            }
        }
    }

    public static void updateNavigation(NavigationAbstract navigationAbstract) {
        navigationAbstract.c();
    }

    static {
        ENTITY_SETPOSE_METHOD = NMS.getMethodHandle(Entity.class, "setPose", true, EntityPose.class);
        ENTITY_TRACKER_ENTRY_GETTER = NMS.getFirstGetter(PlayerChunkMap.EntityTracker.class, EntityTrackerEntry.class);
        FISHING_HOOK_HOOKED = NMS.getGetter(EntityFishingHook.class, "hooked");
        FISHING_HOOK_HOOKED_SETTER = NMS.getSetter(EntityFishingHook.class, "hooked");
        FLYING_MOVECONTROL_FLOAT_GETTER = NMS.getFirstGetter(ControllerMoveFlying.class, Boolean.TYPE);
        FLYING_MOVECONTROL_FLOAT_SETTER = NMS.getFirstSetter(ControllerMoveFlying.class, Boolean.TYPE);
        FROM_LOCATION = new Location(null, 0.0, 0.0, 0.0);
        GOAL_SET_FIELD = NMS.getGetter(PathfinderGoalSelector.class, "d");
        HEAD_HEIGHT = NMS.getSetter(Entity.class, "headHeight");
        HEAD_HEIGHT_METHOD = NMS.getMethodHandle(Entity.class, "getHeadHeight", true, EntityPose.class, EntitySize.class);
        JUMP_FIELD = NMS.getGetter(EntityLiving.class, "jumping");
        LOOK_CONTROL_SETTER = NMS.getFirstSetter(EntityInsentient.class, ControllerLook.class);
        MAKE_REQUEST = NMS.getMethodHandle(YggdrasilAuthenticationService.class, "makeRequest", true, URL.class, Object.class, Class.class);
        MOVE_CONTROLLER_MOVING = NMS.getSetter(ControllerMove.class, "h");
        NAVIGATION_A = NMS.getMethodHandle(NavigationAbstract.class, "a", true, Integer.TYPE);
        NAVIGATION_S = NMS.getFinalSetter(NavigationAbstract.class, "s");
        NAVIGATION_WORLD_FIELD = NMS.getSetter(NavigationAbstract.class, "b");
        PACKET_CACHE_LOCATION = new Location(null, 0.0, 0.0, 0.0);
        PLAYER_CHUNK_MAP_VIEW_DISTANCE_GETTER = NMS.getGetter(PlayerChunkMap.class, "viewDistance");
        PLAYER_CHUNK_MAP_VIEW_DISTANCE_SETTER = NMS.getSetter(PlayerChunkMap.class, "viewDistance");
        PUFFERFISH_C = NMS.getSetter(EntityPufferFish.class, "c");
        PUFFERFISH_D = NMS.getSetter(EntityPufferFish.class, "d");
        RABBIT_DATAWATCHER_FIELD = NMS.getGetter(EntityRabbit.class, "bo");
        RANDOM = Util.getFastRandom();
        SIZE_FIELD_GETTER = NMS.getGetter(Entity.class, "size");
        SIZE_FIELD_SETTER = NMS.getSetter(Entity.class, "size");
        SOUNDEFFECT_KEY = NMS.getGetter(SoundEffect.class, "b");
        try {
            ENTITY_REGISTRY = new CustomEntityRegistry(NMS.getGetter(IRegistry.class, "ENTITY_TYPE").invoke());
            NMS.getFinalSetter(IRegistry.class, "ENTITY_TYPE").invoke(ENTITY_REGISTRY);
        }
        catch (Throwable throwable) {
            Messaging.logTr("citizens.nms-errors.getting-id-mapping", throwable.getMessage());
        }
        try {
            ENDERMAN_ANGRY = (DataWatcherObject)NMS.getField(EntityEnderman.class, "bo").get(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    private static class NavigationFieldWrapper
    implements MCTargetStrategy.TargetNavigator {
        private final org.bukkit.entity.Entity entity;
        private final NavigationAbstract navigation;
        private final NavigatorParameters parameters;
        private final org.bukkit.entity.Entity target;

        private NavigationFieldWrapper(org.bukkit.entity.Entity entity, NavigationAbstract navigationAbstract, org.bukkit.entity.Entity entity2, NavigatorParameters navigatorParameters) {
            this.entity = entity;
            this.navigation = navigationAbstract;
            this.target = entity2;
            this.parameters = navigatorParameters;
        }

        @Override
        public Location getCurrentDestination() {
            return NMS.getDestination(this.entity);
        }

        @Override
        public Iterable<Vector> getPath() {
            return new NavigationIterable(this.navigation);
        }

        @Override
        public void setPath() {
            Location location = this.parameters.entityTargetLocationMapper().apply(this.target);
            if (location == null) {
                throw new IllegalStateException("mapper should not return null");
            }
            this.navigation.a(location.getX(), location.getY(), location.getZ(), (double)this.parameters.speed());
        }

        @Override
        public void stop() {
            NMSImpl.stopNavigation(this.navigation);
        }

        @Override
        public void update() {
            NMSImpl.updateNavigation(this.navigation);
        }
    }

    private static class NavigationIterable
    implements Iterable<Vector> {
        private final NavigationAbstract navigation;

        public NavigationIterable(NavigationAbstract navigationAbstract) {
            this.navigation = navigationAbstract;
        }

        @Override
        public Iterator<Vector> iterator() {
            final int n = this.navigation.k() == null ? 0 : this.navigation.k().e();
            return new Iterator<Vector>(){
                PathPoint curr;
                int i;
                {
                    this.curr = n > 0 ? navigation.k().a(0) : null;
                    this.i = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.curr != null;
                }

                @Override
                public Vector next() {
                    PathPoint pathPoint = this.curr;
                    this.curr = this.i + 1 < n ? navigation.k().a(++this.i) : null;
                    return new Vector(pathPoint.a, pathPoint.b, pathPoint.c);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class CitizensInventoryAnvil
    extends CraftInventoryAnvil
    implements ForwardingInventory {
        private final Inventory wrapped;

        public CitizensInventoryAnvil(Location location, IInventory iInventory, IInventory iInventory2, ContainerAnvil containerAnvil, Inventory inventory) {
            super(location, iInventory, iInventory2, containerAnvil);
            this.wrapped = inventory;
        }

        @Override
        public Inventory getWrapped() {
            return this.wrapped;
        }

        public void setItem(int n, org.bukkit.inventory.ItemStack itemStack) {
            super.setItem(n, itemStack);
            this.wrapped.setItem(n, itemStack);
        }
    }
}

