/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.util;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingSet;
import java.lang.invoke.MethodHandle;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.citizensnpcs.api.event.NPCLinkToPlayerEvent;
import net.citizensnpcs.api.event.NPCSeenByPlayerEvent;
import net.citizensnpcs.api.event.NPCUnlinkFromPlayerEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_16_R3.entity.EntityHumanNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EntityTrackerEntry;
import net.minecraft.server.v1_16_R3.PlayerChunkMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PlayerlistTracker
extends PlayerChunkMap.EntityTracker {
    private final Entity tracker;
    private Map<EntityPlayer, Boolean> trackingMap;
    private static final MethodHandle D = NMS.getGetter(EntityTrackerEntry.class, "d");
    private static final MethodHandle E = NMS.getGetter(EntityTrackerEntry.class, "e");
    private static final MethodHandle TRACKER = NMS.getGetter(PlayerChunkMap.EntityTracker.class, "tracker");
    private static final MethodHandle TRACKER_ENTRY = NMS.getGetter(PlayerChunkMap.EntityTracker.class, "trackerEntry");
    private static MethodHandle TRACKING_MAP_GETTER;
    private static MethodHandle TRACKING_MAP_SETTER;
    private static final MethodHandle TRACKING_RANGE;
    private static final MethodHandle TRACKING_RANGE_SETTER;
    private static final MethodHandle TRACKING_SET_SETTER;

    public PlayerlistTracker(PlayerChunkMap playerChunkMap, Entity entity, int n, int n2, boolean bl) {
        PlayerChunkMap playerChunkMap2 = playerChunkMap;
        Objects.requireNonNull(playerChunkMap2);
        super(playerChunkMap2, entity, n, n2, bl);
        this.tracker = entity;
        if (TRACKING_MAP_SETTER != null) {
            try {
                Map map;
                this.trackingMap = map = TRACKING_MAP_GETTER.invoke(this);
                TRACKING_MAP_SETTER.invoke(this, new ForwardingMap<EntityPlayer, Boolean>(){

                    protected Map<EntityPlayer, Boolean> delegate() {
                        return map;
                    }

                    public Boolean put(EntityPlayer entityPlayer, Boolean bl) {
                        Boolean bl2 = (Boolean)super.put((Object)entityPlayer, (Object)bl);
                        if (bl2 == null) {
                            PlayerlistTracker.this.updateLastPlayer(entityPlayer);
                        }
                        return bl2;
                    }

                    public Boolean remove(Object object) {
                        Boolean bl = (Boolean)super.remove(object);
                        if (bl.booleanValue()) {
                            Bukkit.getPluginManager().callEvent((Event)new NPCUnlinkFromPlayerEvent(((NPCHolder)PlayerlistTracker.this.tracker).getNPC(), (Player)((EntityPlayer)object).getBukkitEntity()));
                        }
                        return bl;
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else {
            try {
                final Set set = this.trackedPlayers;
                TRACKING_SET_SETTER.invoke(this, new ForwardingSet<EntityPlayer>(){

                    public boolean add(EntityPlayer entityPlayer) {
                        boolean bl = super.add((Object)entityPlayer);
                        if (bl) {
                            PlayerlistTracker.this.updateLastPlayer(entityPlayer);
                        }
                        return bl;
                    }

                    protected Set<EntityPlayer> delegate() {
                        return set;
                    }

                    public boolean remove(Object object) {
                        boolean bl = super.remove(object);
                        if (bl) {
                            Bukkit.getPluginManager().callEvent((Event)new NPCUnlinkFromPlayerEvent(((NPCHolder)PlayerlistTracker.this.tracker).getNPC(), (Player)((EntityPlayer)object).getBukkitEntity()));
                        }
                        return bl;
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public PlayerlistTracker(PlayerChunkMap playerChunkMap, PlayerChunkMap.EntityTracker entityTracker) {
        this(playerChunkMap, PlayerlistTracker.getTracker(entityTracker), PlayerlistTracker.getTrackingDistance(entityTracker), PlayerlistTracker.getD(entityTracker), PlayerlistTracker.getE(entityTracker));
    }

    private boolean isTracked(EntityPlayer entityPlayer) {
        return this.trackingMap != null ? this.trackingMap.containsKey(entityPlayer) : this.trackedPlayers.contains(entityPlayer);
    }

    public void updateLastPlayer(EntityPlayer entityPlayer) {
        if (entityPlayer != null) {
            Bukkit.getPluginManager().callEvent((Event)new NPCLinkToPlayerEvent(((NPCHolder)this.tracker).getNPC(), (Player)entityPlayer.getBukkitEntity()));
        }
    }

    public void updatePlayer(EntityPlayer entityPlayer) {
        if (entityPlayer instanceof EntityHumanNPC) {
            return;
        }
        if (!this.isTracked(entityPlayer) && this.tracker instanceof NPCHolder) {
            NPC nPC = ((NPCHolder)this.tracker).getNPC();
            NPCSeenByPlayerEvent nPCSeenByPlayerEvent = new NPCSeenByPlayerEvent(nPC, (Player)entityPlayer.getBukkitEntity());
            Bukkit.getPluginManager().callEvent((Event)nPCSeenByPlayerEvent);
            if (nPCSeenByPlayerEvent.isCancelled()) {
                return;
            }
            Integer n = (Integer)nPC.data().get(NPC.Metadata.TRACKING_RANGE);
            if (TRACKING_RANGE_SETTER != null && n != null && nPC.data().get("last-tracking-range", Integer.valueOf(-1)).intValue() != n.intValue()) {
                try {
                    TRACKING_RANGE_SETTER.invoke(this, n);
                    nPC.data().set("last-tracking-range", (Object)n);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        super.updatePlayer(entityPlayer);
    }

    private static int getD(PlayerChunkMap.EntityTracker entityTracker) {
        try {
            return D.invoke(TRACKER_ENTRY.invoke(entityTracker));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    private static boolean getE(PlayerChunkMap.EntityTracker entityTracker) {
        try {
            return E.invoke(TRACKER_ENTRY.invoke(entityTracker));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static Set<Player> getSeenBy(PlayerChunkMap.EntityTracker entityTracker) {
        if (TRACKING_MAP_GETTER != null) {
            Map map;
            try {
                map = TRACKING_MAP_GETTER.invoke(entityTracker);
            }
            catch (Throwable throwable) {
                return null;
            }
            return map.keySet().stream().map(entityPlayer -> entityPlayer.getBukkitEntity()).collect(Collectors.toSet());
        }
        return entityTracker.trackedPlayers.stream().map(entityPlayer -> entityPlayer.getBukkitEntity()).collect(Collectors.toSet());
    }

    private static Entity getTracker(PlayerChunkMap.EntityTracker entityTracker) {
        try {
            return TRACKER.invoke(entityTracker);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static int getTrackingDistance(PlayerChunkMap.EntityTracker entityTracker) {
        try {
            return TRACKING_RANGE.invoke(entityTracker);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    static {
        TRACKING_RANGE = NMS.getGetter(PlayerChunkMap.EntityTracker.class, "trackingDistance");
        TRACKING_RANGE_SETTER = NMS.getFirstFinalSetter(PlayerChunkMap.EntityTracker.class, Integer.TYPE);
        TRACKING_SET_SETTER = NMS.getFirstFinalSetter(PlayerChunkMap.EntityTracker.class, Set.class);
        try {
            if (PlayerChunkMap.EntityTracker.class.getField("trackedPlayerMap") != null) {
                TRACKING_MAP_SETTER = NMS.getFirstSetter(PlayerChunkMap.EntityTracker.class, Map.class);
                TRACKING_MAP_GETTER = NMS.getFirstGetter(PlayerChunkMap.EntityTracker.class, Map.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

