/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.entity.nonliving;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_19_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_19_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_19_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_19_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.core.Position;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftFishHook;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.util.Vector;

public class FishingHookController
extends MobEntityController {
    public FishingHookController() {
        super(EntityFishingHookNPC.class);
    }

    @Override
    protected Entity createEntity(Location location, NPC nPC) {
        WorldServer worldServer = ((CraftWorld)location.getWorld()).getHandle();
        EntityPlayer entityPlayer = new EntityPlayer(worldServer.n(), worldServer, new GameProfile(UUID.randomUUID(), "dummyfishhook")){};
        entityPlayer.e(location.getX(), location.getY(), location.getZ());
        entityPlayer.f(location.getYaw());
        entityPlayer.e(location.getPitch());
        entityPlayer.c(20.0f);
        entityPlayer.fJ().i.set(entityPlayer.fJ().l, (Object)new ItemStack((IMaterial)Items.qd, 1));
        EntityFishingHookNPC entityFishingHookNPC = new EntityFishingHookNPC((EntityTypes<? extends EntityFishingHook>)EntityTypes.bu, (World)worldServer, nPC, entityPlayer);
        return entityFishingHookNPC.getBukkitEntity();
    }

    public FishHook getBukkitEntity() {
        return (FishHook)super.getBukkitEntity();
    }

    public static class EntityFishingHookNPC
    extends EntityFishingHook
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityFishingHookNPC(EntityTypes<? extends EntityFishingHook> entityTypes, World world) {
            this(entityTypes, world, null, null);
        }

        public EntityFishingHookNPC(EntityTypes<? extends EntityFishingHook> entityTypes, World world, NPC nPC, EntityPlayer entityPlayer) {
            super((EntityHuman)entityPlayer, world, 0, 0);
            this.npc = (CitizensNPC)nPC;
        }

        public double f(net.minecraft.world.entity.Entity entity) {
            if (entity == this.j()) {
                return 0.0;
            }
            return super.f(entity);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new FishingHookNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction C_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.C_();
        }

        public boolean bn() {
            return this.npc == null ? super.bn() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        protected AxisAlignedBB am() {
            return NMSBoundingBox.makeBB(this.npc, super.am());
        }

        public void j(double d, double d2, double d3) {
            Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
            if (vector != null) {
                super.j(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(net.minecraft.world.entity.Entity entity) {
            super.g(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.e(nBTTagCompound) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(WorldServer worldServer, Position position) {
            if (this.npc == null) {
                return super.teleportTo(worldServer, position);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldServer, position);
        }

        public void l() {
            if (this.npc != null) {
                this.j().dD();
                NMSImpl.setLife(this, 0);
                this.npc.update();
            } else {
                super.l();
            }
        }

        public boolean a(TagKey<FluidType> tagKey, double d) {
            if (this.npc == null) {
                return super.a(tagKey, d);
            }
            Vec3D vec3D = this.dj().b(0.0, 0.0, 0.0);
            boolean bl = super.a(tagKey, d);
            if (!this.npc.isPushableByFluids()) {
                this.f(vec3D);
            }
            return bl;
        }
    }

    public static class FishingHookNPC
    extends CraftFishHook
    implements ForwardingNPCHolder {
        public FishingHookNPC(EntityFishingHookNPC entityFishingHookNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityFishingHook)entityFishingHookNPC);
        }
    }
}

