/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_19_R3.util.EntityJumpControl;
import net.citizensnpcs.nms.v1_19_R3.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_19_R3.util.EntityNavigation;
import net.citizensnpcs.nms.v1_19_R3.util.NMSImpl;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.pathfinder.PathType;
import org.bukkit.entity.Entity;

public interface MobAI {
    public Entity getBukkitEntity();

    public ControllerJump getJumpControl();

    public Map<PathType, Float> getMalus();

    public ControllerMove getMoveControl();

    public NavigationAbstract getNavigation();

    default public float getPathfindingMalus(PathType var1) {
        Map<PathType, Float> malus = this.getMalus();
        return malus.containsKey(var1) ? malus.get(var1).floatValue() : var1.a();
    }

    default public void setPathfindingMalus(PathType water, float oldWaterCost) {
        this.getMalus().put(water, Float.valueOf(oldWaterCost));
    }

    default public void tickAI() {
        this.getJumpControl().b();
        this.getMoveControl().a();
        NavigationAbstract nav = this.getNavigation();
        if (!nav.l()) {
            nav.c();
        }
    }

    default public void updatePathfindingRange(float range) {
        ((EntityLiving)NMSImpl.getHandle(this.getBukkitEntity())).a(GenericAttributes.b).a((double)range);
    }

    public static MobAI from(net.minecraft.world.entity.Entity handle) {
        if (handle instanceof EntityInsentient) {
            final EntityInsentient mob = (EntityInsentient)handle;
            return new MobAI(){

                @Override
                public Entity getBukkitEntity() {
                    return mob.getBukkitEntity();
                }

                @Override
                public ControllerJump getJumpControl() {
                    return mob.E();
                }

                @Override
                public Map<PathType, Float> getMalus() {
                    return null;
                }

                @Override
                public ControllerMove getMoveControl() {
                    return mob.D();
                }

                @Override
                public NavigationAbstract getNavigation() {
                    return mob.G();
                }

                @Override
                public float getPathfindingMalus(PathType pathType) {
                    return mob.a(pathType);
                }

                @Override
                public void setPathfindingMalus(PathType pathType, float f) {
                    mob.a(pathType, f);
                }

                @Override
                public void tickAI() {
                    mob.I().a();
                    mob.G().c();
                    mob.D().a();
                    mob.C().a();
                    mob.E().b();
                }
            };
        }
        if (handle instanceof MobAI) {
            return (MobAI)handle;
        }
        return null;
    }

    public static interface ForwardingMobAI
    extends MobAI {
        public MobAI getAI();

        @Override
        default public Entity getBukkitEntity() {
            return this.getAI().getBukkitEntity();
        }

        @Override
        default public ControllerJump getJumpControl() {
            return this.getAI().getJumpControl();
        }

        @Override
        default public Map<PathType, Float> getMalus() {
            return this.getAI().getMalus();
        }

        @Override
        default public ControllerMove getMoveControl() {
            return this.getAI().getMoveControl();
        }

        @Override
        default public NavigationAbstract getNavigation() {
            return this.getAI().getNavigation();
        }
    }

    public static class BasicMobAI
    implements MobAI {
        private final EntityJumpControl controllerJump;
        private final EntityMoveControl controllerMove;
        private final EntityLiving entity;
        private final Map<PathType, Float> malus;
        private final EntityNavigation navigation;

        public BasicMobAI(EntityLiving entityLiving) {
            this.entity = entityLiving;
            NMSImpl.setAttribute(entityLiving, GenericAttributes.b, Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
            entityLiving.a(GenericAttributes.d).a(0.3);
            this.controllerJump = new EntityJumpControl(entityLiving);
            this.controllerMove = new EntityMoveControl(entityLiving);
            this.navigation = new EntityNavigation(entityLiving, entityLiving.H);
            this.malus = Maps.newEnumMap(PathType.class);
        }

        @Override
        public Entity getBukkitEntity() {
            return this.entity.getBukkitEntity();
        }

        @Override
        public ControllerJump getJumpControl() {
            return this.controllerJump;
        }

        @Override
        public Map<PathType, Float> getMalus() {
            return this.malus;
        }

        @Override
        public ControllerMove getMoveControl() {
            return this.controllerMove;
        }

        @Override
        public NavigationAbstract getNavigation() {
            return this.navigation;
        }
    }
}

