/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.nms.v1_19_R3.util.NMSImpl;
import net.citizensnpcs.util.PlayerAnimation;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class PlayerAnimationImpl {
    private static Map<PlayerAnimation, Integer> DEFAULTS = Maps.newEnumMap(PlayerAnimation.class);

    public static void play(PlayerAnimation playerAnimation, Player player, Iterable<Player> iterable) {
        EntityPlayer entityPlayer = (EntityPlayer)NMSImpl.getHandle((Entity)player);
        if (DEFAULTS.containsKey((Object)playerAnimation)) {
            PlayerAnimationImpl.playDefaultAnimation(entityPlayer, iterable, DEFAULTS.get((Object)playerAnimation));
            return;
        }
        switch (playerAnimation) {
            case HURT: {
                PlayerAnimationImpl.sendPacketNearby(new ClientboundHurtAnimationPacket((EntityLiving)entityPlayer), iterable);
                break;
            }
            case SNEAK: {
                entityPlayer.b(EntityPose.f);
                PlayerAnimationImpl.sendEntityData(iterable, entityPlayer);
                break;
            }
            case START_ELYTRA: {
                entityPlayer.fP();
                break;
            }
            case STOP_ELYTRA: {
                entityPlayer.fQ();
                break;
            }
            case START_USE_MAINHAND_ITEM: {
                entityPlayer.c(EnumHand.a);
                PlayerAnimationImpl.sendEntityData(iterable, entityPlayer);
                entityPlayer.getBukkitEntity().setMetadata("citizens-using-item-remaining-ticks", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)entityPlayer.fh()));
                break;
            }
            case START_USE_OFFHAND_ITEM: {
                entityPlayer.c(EnumHand.b);
                PlayerAnimationImpl.sendEntityData(iterable, entityPlayer);
                entityPlayer.getBukkitEntity().setMetadata("citizens-using-item-remaining-ticks", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)entityPlayer.fh()));
                break;
            }
            case STOP_SNEAKING: {
                entityPlayer.b(EntityPose.a);
                PlayerAnimationImpl.sendEntityData(iterable, entityPlayer);
                break;
            }
            case STOP_USE_ITEM: {
                entityPlayer.fk();
                PlayerAnimationImpl.sendEntityData(iterable, entityPlayer);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static void playDefaultAnimation(EntityPlayer entityPlayer, Iterable<Player> iterable, int n) {
        PacketPlayOutAnimation packetPlayOutAnimation = new PacketPlayOutAnimation((net.minecraft.world.entity.Entity)entityPlayer, n);
        PlayerAnimationImpl.sendPacketNearby(packetPlayOutAnimation, iterable);
    }

    private static void sendEntityData(Iterable<Player> iterable, EntityPlayer entityPlayer) {
        if (!entityPlayer.aj().a()) {
            return;
        }
        PlayerAnimationImpl.sendPacketNearby(new PacketPlayOutEntityMetadata(entityPlayer.af(), entityPlayer.aj().b()), iterable);
    }

    protected static void sendPacketNearby(Packet<?> packet, Iterable<Player> iterable) {
        for (Player player : iterable) {
            NMSImpl.sendPacket(player, packet);
        }
    }

    static {
        DEFAULTS.put(PlayerAnimation.ARM_SWING, 0);
        DEFAULTS.put(PlayerAnimation.LEAVE_BED, 2);
        DEFAULTS.put(PlayerAnimation.ARM_SWING_OFFHAND, 3);
        DEFAULTS.put(PlayerAnimation.CRIT, 4);
        DEFAULTS.put(PlayerAnimation.MAGIC_CRIT, 5);
    }
}

